/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.flow.AnyPrimitiveSourceTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayCopyTypeFlow;
import com.oracle.graal.pointsto.flow.BoxTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.ConstantPrimitiveSourceTypeFlow;
import com.oracle.graal.pointsto.flow.ConstantTypeFlow;
import com.oracle.graal.pointsto.flow.DynamicNewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FilterTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.LoadFieldTypeFlow;
import com.oracle.graal.pointsto.flow.MergeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MonitorEnterTypeFlow;
import com.oracle.graal.pointsto.flow.NewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.NullCheckTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.SourceTypeFlow;
import com.oracle.graal.pointsto.flow.StoreFieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.builder.TypeFlowBuilder;
import com.oracle.graal.pointsto.flow.builder.TypeFlowGraphBuilder;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.nodes.UnsafePartitionLoadNode;
import com.oracle.graal.pointsto.nodes.UnsafePartitionStoreNode;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysis;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.extended.GetClassNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.java.MonitorEnterNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.NewMultiArrayNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndExchangeNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndSwapNode;
import jdk.graal.compiler.nodes.spi.LimitedValueProxy;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.phases.common.BoxNodeIdentityPhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.IterativeConditionalEliminationPhase;
import jdk.graal.compiler.phases.graph.MergeableState;
import jdk.graal.compiler.phases.graph.PostOrderNodeIterator;
import jdk.graal.compiler.replacements.nodes.BasicArrayCopyNode;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.MacroInvokable;
import jdk.graal.compiler.replacements.nodes.ObjectClone;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.graal.compiler.virtual.phases.ea.PartialEscapePhase;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.nativeimage.AnnotationAccess;

public class MethodTypeFlowBuilder {
    protected final PointsToAnalysis bb;
    protected final MethodFlowsGraph flowsGraph;
    protected final PointsToAnalysisMethod method;
    protected StructuredGraph graph;
    private NodeBitMap processedNodes;
    private Map<PhiNode, TypeFlowBuilder<?>> loopPhiFlows;
    private final MethodFlowsGraph.GraphKind graphKind;
    private boolean processed = false;
    private final boolean newFlowsGraph;
    protected final TypeFlowGraphBuilder typeFlowGraphBuilder;
    protected List<TypeFlow<?>> postInitFlows = List.of();
    private final TypeFlowBuilder<AnyPrimitiveSourceTypeFlow> anyPrimitiveSourceTypeFlowBuilder;

    public MethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod method, MethodFlowsGraph flowsGraph, MethodFlowsGraph.GraphKind graphKind) {
        this.bb = bb;
        this.method = method;
        this.graphKind = graphKind;
        TypeFlowBuilder<AnyPrimitiveSourceTypeFlow> typeFlowBuilder = bb.trackPrimitiveValues() ? TypeFlowBuilder.create(bb, null, AnyPrimitiveSourceTypeFlow.class, bb::getAnyPrimitiveSourceTypeFlow) : (this.anyPrimitiveSourceTypeFlowBuilder = null);
        if (flowsGraph == null) {
            this.flowsGraph = new MethodFlowsGraph(method, graphKind);
            this.newFlowsGraph = true;
        } else {
            this.flowsGraph = flowsGraph;
            this.newFlowsGraph = false;
            assert (graphKind == MethodFlowsGraph.GraphKind.FULL) : graphKind;
        }
        this.typeFlowGraphBuilder = new TypeFlowGraphBuilder(bb);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parse(Object reason, boolean forceReparse) {
        AnalysisParsedGraph analysisParsedGraph;
        AnalysisParsedGraph analysisParsedGraph2 = analysisParsedGraph = forceReparse ? this.method.reparseGraph(this.bb) : this.method.ensureGraphParsed(this.bb);
        if (analysisParsedGraph.isIntrinsic()) {
            this.method.registerAsIntrinsicMethod(reason);
        }
        if (analysisParsedGraph.getEncodedGraph() == null) {
            return false;
        }
        this.graph = InlineBeforeAnalysis.decodeGraph(this.bb, this.method, analysisParsedGraph);
        try (DebugContext.Scope s = this.graph.getDebug().scope((Object)"MethodTypeFlowBuilder", (Object)this.graph);){
            CanonicalizerPhase canonicalizerPhase = CanonicalizerPhase.create();
            canonicalizerPhase.apply(this.graph, (Object)this.bb.getProviders(this.method));
            if (((Boolean)PointstoOptions.ConditionalEliminationBeforeAnalysis.getValue(this.bb.getOptions())).booleanValue()) {
                new IterativeConditionalEliminationPhase(canonicalizerPhase, false).apply(this.graph, (Object)this.bb.getProviders(this.method));
            }
            if (((Boolean)PointstoOptions.EscapeAnalysisBeforeAnalysis.getValue(this.bb.getOptions())).booleanValue() && this.method.isOriginalMethod()) {
                new BoxNodeIdentityPhase().apply(this.graph, (Object)this.bb.getProviders(this.method));
                new PartialEscapePhase(false, canonicalizerPhase, this.bb.getOptions()).apply(this.graph, (Object)this.bb.getProviders(this.method));
            }
            if (!this.bb.getUniverse().hostVM().validateGraph(this.bb, this.graph)) {
                this.graph = null;
                boolean bl2 = false;
                return bl2;
            }
            MethodTypeFlowBuilder.registerUsedElements(this.bb, this.graph);
            boolean bl = true;
            return bl;
        }
        catch (Throwable ex) {
            throw this.graph.getDebug().handle(ex);
        }
    }

    protected static void registerUsedElements(PointsToAnalysis bb, StructuredGraph graph) {
        PointsToAnalysisMethod method = (PointsToAnalysisMethod)graph.method();
        HostedProviders providers = bb.getProviders(method);
        for (Node n : graph.getNodes()) {
            AnalysisField field;
            AnalysisType type;
            InstanceOfNode node;
            if (n instanceof InstanceOfNode) {
                node = (InstanceOfNode)n;
                type = (AnalysisType)node.type().getType();
                if (MethodTypeFlowBuilder.ignoreInstanceOfType(bb, type)) continue;
                type.registerAsReachable(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof NewInstanceNode) {
                node = (NewInstanceNode)n;
                type = (AnalysisType)node.instanceClass();
                type.registerAsAllocated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof VirtualObjectNode) {
                node = (VirtualObjectNode)n;
                type = (AnalysisType)node.type();
                type.registerAsAllocated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof CommitAllocationNode) {
                node = (CommitAllocationNode)n;
                List values = node.getValues();
                int objectStartIndex = 0;
                for (VirtualObjectNode virtualObject : node.getVirtualObjects()) {
                    AnalysisType type2 = (AnalysisType)virtualObject.type();
                    if (!type2.isArray()) {
                        for (int i = 0; i < virtualObject.entryCount(); ++i) {
                            ValueNode value = (ValueNode)values.get(objectStartIndex + i);
                            if (value.isJavaConstant() && value.asJavaConstant().isDefaultForKind()) continue;
                            AnalysisField field2 = (AnalysisField)((VirtualInstanceNode)virtualObject).field(i);
                            field2.registerAsWritten(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                        }
                    }
                    objectStartIndex += virtualObject.entryCount();
                }
                continue;
            }
            if (n instanceof NewArrayNode) {
                node = (NewArrayNode)n;
                type = ((AnalysisType)node.elementType()).getArrayClass();
                type.registerAsAllocated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof NewMultiArrayNode) {
                node = (NewMultiArrayNode)n;
                type = (AnalysisType)node.type();
                for (int i = 0; i < node.dimensionCount(); ++i) {
                    type.registerAsAllocated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                    type = type.getComponentType();
                }
                continue;
            }
            if (n instanceof BoxNode) {
                node = (BoxNode)n;
                type = (AnalysisType)StampTool.typeOrNull((ValueNode)node, (MetaAccessProvider)bb.getMetaAccess());
                type.registerAsAllocated(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof LoadFieldNode) {
                node = (LoadFieldNode)n;
                field = (AnalysisField)node.field();
                field.registerAsRead(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof StoreFieldNode) {
                node = (StoreFieldNode)n;
                field = (AnalysisField)node.field();
                field.registerAsWritten(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof ConstantNode) {
                ConstantNode cn = (ConstantNode)n;
                JavaConstant root = cn.asJavaConstant();
                if (!cn.hasUsages() || !cn.isJavaConstant() || root.getJavaKind() != JavaKind.Object || !root.isNonNull()) continue;
                assert (StampTool.isExactType((ValueNode)cn)) : cn;
                AnalysisType type3 = (AnalysisType)StampTool.typeOrNull((ValueNode)cn, (MetaAccessProvider)bb.getMetaAccess());
                type3.registerAsInHeap(new ObjectScanner.EmbeddedRootScan(AbstractAnalysisEngine.sourcePosition((ValueNode)cn), root));
                if (MethodTypeFlowBuilder.ignoreConstant(bb, cn)) continue;
                MethodTypeFlowBuilder.registerEmbeddedRoot(bb, cn);
                continue;
            }
            if (n instanceof FrameState) {
                node = (FrameState)n;
                AnalysisMethod frameStateMethod = (AnalysisMethod)node.getMethod();
                if (frameStateMethod == null) continue;
                frameStateMethod.getDeclaringClass().registerAsReachable(AbstractAnalysisEngine.syntheticSourcePosition((Node)node, method));
                continue;
            }
            if (n instanceof ForeignCall) {
                node = (ForeignCall)n;
                MethodTypeFlowBuilder.registerForeignCall(bb, providers.getForeignCalls(), node.getDescriptor(), graph.method());
                continue;
            }
            if (n instanceof UnaryMathIntrinsicNode) {
                node = (UnaryMathIntrinsicNode)n;
                MethodTypeFlowBuilder.registerForeignCall(bb, providers.getForeignCalls(), providers.getForeignCalls().getDescriptor(node.getOperation().foreignCallSignature), graph.method());
                continue;
            }
            if (!(n instanceof BinaryMathIntrinsicNode)) continue;
            node = (BinaryMathIntrinsicNode)n;
            MethodTypeFlowBuilder.registerForeignCall(bb, providers.getForeignCalls(), providers.getForeignCalls().getDescriptor(node.getOperation().foreignCallSignature), graph.method());
        }
    }

    protected static boolean ignoreConstant(PointsToAnalysis bb, ConstantNode cn) {
        if (!MethodTypeFlowBuilder.ignoreInstanceOfType(bb, (AnalysisType)bb.getConstantReflectionProvider().asJavaType(cn.asConstant()))) {
            return false;
        }
        for (Node usage : cn.usages()) {
            if (usage instanceof ClassIsAssignableFromNode) {
                if (((ClassIsAssignableFromNode)usage).getThisClass() == cn) continue;
                return false;
            }
            if (usage instanceof BytecodeExceptionNode) {
                if (((BytecodeExceptionNode)usage).getExceptionKind() == BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST) continue;
                return false;
            }
            if (usage instanceof FrameState) continue;
            return false;
        }
        return true;
    }

    protected static boolean ignoreInstanceOfType(PointsToAnalysis bb, AnalysisType type) {
        if (bb.getHostVM().ignoreInstanceOfTypeDisallowed()) {
            return false;
        }
        if (type == null) {
            return false;
        }
        return !type.isArray();
    }

    private static void registerEmbeddedRoot(PointsToAnalysis bb, ConstantNode cn) {
        bb.getUniverse().registerEmbeddedRoot(cn.asJavaConstant(), AbstractAnalysisEngine.sourcePosition((ValueNode)cn));
    }

    private static void registerForeignCall(PointsToAnalysis bb, ForeignCallsProvider foreignCallsProvider, ForeignCallDescriptor foreignCallDescriptor, ResolvedJavaMethod from) {
        Optional<AnalysisMethod> targetMethod = bb.getHostVM().handleForeignCall(foreignCallDescriptor, foreignCallsProvider);
        targetMethod.ifPresent(analysisMethod -> bb.addRootMethod((AnalysisMethod)analysisMethod, true, (Object)from, new MultiMethod.MultiMethodKey[0]));
    }

    private boolean handleNodeIntrinsic() {
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)this.method, Node.NodeIntrinsic.class)) {
            this.graph.getDebug().log("apply MethodTypeFlow on node intrinsic %s", (Object)this.method);
            AnalysisType returnType = (AnalysisType)this.method.getSignature().getReturnType();
            if (this.bb.isSupportedJavaKind(returnType.getJavaKind())) {
                TypeFlow<?> returnTypeFlow = this.flowsGraph.getReturnFlow().getDeclaredType().getTypeFlow(this.bb, true);
                BytecodePosition source = new BytecodePosition(null, (ResolvedJavaMethod)this.method, 0);
                returnTypeFlow = this.bb.analysisPolicy().proxy(source, returnTypeFlow);
                FormalReturnTypeFlow resultFlow = new FormalReturnTypeFlow(source, returnType);
                this.bb.analysisPolicy().addOriginalUse(this.bb, returnTypeFlow, resultFlow);
                this.flowsGraph.addMiscEntryFlow(returnTypeFlow);
                this.flowsGraph.setReturnFlow(resultFlow);
            }
            return true;
        }
        return false;
    }

    private void insertAllInstantiatedTypesReturn() {
        AnalysisError.guarantee(this.flowsGraph.getReturnFlow() == null, "Expected null return flow", new Object[0]);
        AnalysisType returnType = TypeFlow.filterUncheckedInterface((AnalysisType)this.method.getSignature().getReturnType());
        AnalysisError.guarantee(returnType.getJavaKind().isObject(), "Unexpected return type: %s", returnType);
        BytecodePosition position = AbstractAnalysisEngine.syntheticSourcePosition(null, this.method);
        FormalReturnTypeFlow returnFlow = new FormalReturnTypeFlow(position, returnType);
        this.flowsGraph.setReturnFlow(returnFlow);
        assert (returnType.equals(returnFlow.getDeclaredType())) : String.valueOf(returnType) + " != " + String.valueOf(returnFlow.getDeclaredType());
        returnType.getTypeFlow(this.bb, true).addUse(this.bb, returnFlow);
    }

    private void insertPlaceholderParamAndReturnFlows() {
        AnalysisType returnType;
        List<AnalysisType> paramTypes = this.method.toParameterList();
        BytecodePosition position = AbstractAnalysisEngine.syntheticSourcePosition(null, this.method);
        for (int index = 0; index < paramTypes.size(); ++index) {
            FormalParamTypeFlow parameter;
            if (this.flowsGraph.getParameter(index) != null || !this.bb.isSupportedJavaKind(paramTypes.get(index).getJavaKind())) continue;
            AnalysisType paramType = paramTypes.get(index);
            if (index == 0 && !this.method.isStatic()) {
                assert (paramType.equals(this.method.getDeclaringClass())) : String.valueOf(paramType) + ", " + String.valueOf(this.method);
                parameter = new FormalReceiverTypeFlow(position, paramType);
            } else {
                parameter = new FormalParamTypeFlow(position, paramType, index);
            }
            this.flowsGraph.setParameter(index, parameter);
        }
        if (this.flowsGraph.getReturnFlow() == null && this.bb.isSupportedJavaKind((returnType = (AnalysisType)this.method.getSignature().getReturnType()).getJavaKind())) {
            this.flowsGraph.setReturnFlow(new FormalReturnTypeFlow(position, returnType));
        }
    }

    private void createTypeFlow() {
        this.processedNodes = new NodeBitMap((Graph)this.graph);
        TypeFlowsOfNodes typeFlows = new TypeFlowsOfNodes();
        for (Node n : this.graph.getNodes()) {
            if (n instanceof ParameterNode) {
                node = (ParameterNode)n;
                if (this.bb.isSupportedJavaKind(node.getStackKind())) {
                    TypeFlowBuilder<FormalParamTypeFlow> paramBuilder = TypeFlowBuilder.create(this.bb, node, FormalParamTypeFlow.class, () -> {
                        boolean isStatic = Modifier.isStatic(this.method.getModifiers());
                        int index = node.index();
                        FormalParamTypeFlow parameter = this.flowsGraph.getParameter(index);
                        if (parameter != null) {
                            parameter.updateSource(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                        } else {
                            assert (this.newFlowsGraph) : "missing flow from original graph " + String.valueOf(parameter);
                            if (!isStatic && index == 0) {
                                AnalysisType paramType = this.method.getDeclaringClass();
                                parameter = new FormalReceiverTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), paramType);
                            } else {
                                int offset = isStatic ? 0 : 1;
                                AnalysisType paramType = (AnalysisType)this.method.getSignature().getParameterType(index - offset);
                                parameter = new FormalParamTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), paramType, index);
                            }
                            this.flowsGraph.setParameter(index, parameter);
                        }
                        return parameter;
                    });
                    this.typeFlowGraphBuilder.checkFormalParameterBuilder(paramBuilder);
                    typeFlows.add((ValueNode)node, paramBuilder);
                    this.typeFlowGraphBuilder.registerSinkBuilder(paramBuilder);
                }
            } else if (n instanceof BoxNode) {
                node = (BoxNode)n;
                AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node, (MetaAccessProvider)this.bb.getMetaAccess());
                TypeFlowBuilder<BoxTypeFlow> boxBuilder = TypeFlowBuilder.create(this.bb, node, BoxTypeFlow.class, () -> this.lambda$createTypeFlow$2((BoxNode)node, type));
                typeFlows.add((ValueNode)node, boxBuilder);
            }
            for (Node input : n.inputs()) {
                if (!(input instanceof ConstantNode) || typeFlows.contains((ValueNode)((ConstantNode)input))) continue;
                ConstantNode node = (ConstantNode)input;
                Constant constant = node.getValue();
                if (node.asJavaConstant() == null && constant instanceof VMConstant) continue;
                if (node.asJavaConstant().isNull()) {
                    TypeFlowBuilder<ConstantTypeFlow> sourceBuilder = TypeFlowBuilder.create(this.bb, node, ConstantTypeFlow.class, () -> {
                        ConstantTypeFlow constantSource = new ConstantTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), null, TypeState.forNull());
                        this.flowsGraph.addMiscEntryFlow(constantSource);
                        return constantSource;
                    });
                    typeFlows.add((ValueNode)node, sourceBuilder);
                    continue;
                }
                if (node.asJavaConstant().getJavaKind() != JavaKind.Object) continue;
                assert (StampTool.isExactType((ValueNode)node)) : node;
                AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node, (MetaAccessProvider)this.bb.getMetaAccess());
                assert (type.isInstantiated()) : type;
                TypeFlowBuilder<ConstantTypeFlow> sourceBuilder = TypeFlowBuilder.create(this.bb, node, ConstantTypeFlow.class, () -> {
                    JavaConstant constantValue = node.asJavaConstant();
                    BytecodePosition position = AbstractAnalysisEngine.sourcePosition((ValueNode)node);
                    ImageHeapConstant heapConstant = this.bb.getUniverse().getHeapScanner().toImageHeapObject(constantValue, new ObjectScanner.EmbeddedRootScan(position, constantValue));
                    ConstantTypeFlow constantSource = new ConstantTypeFlow(position, type, TypeState.forConstant(this.bb, heapConstant, type));
                    this.flowsGraph.addMiscEntryFlow(constantSource);
                    return constantSource;
                });
                typeFlows.add((ValueNode)node, sourceBuilder);
            }
        }
        new NodeIterator((FixedNode)this.graph.start(), typeFlows).apply();
        this.postInitFlows = this.typeFlowGraphBuilder.build();
    }

    protected ValueNode typeFlowUnproxify(ValueNode value) {
        ValueNode result = value;
        while (result instanceof LimitedValueProxy) {
            result = ((LimitedValueProxy)result).getOriginalNode();
        }
        return result;
    }

    protected void apply(boolean forceReparse, Object reason) {
        assert (!this.processed) : "can only call apply once per MethodTypeFlowBuilder";
        this.processed = true;
        if (this.handleNodeIntrinsic()) {
            assert (!this.method.getReturnsAllInstantiatedTypes()) : this.method;
            return;
        }
        if (this.method.getReturnsAllInstantiatedTypes()) {
            this.insertAllInstantiatedTypesReturn();
        }
        boolean insertPlaceholderFlows = this.bb.getHostVM().getMultiMethodAnalysisPolicy().insertPlaceholderParamAndReturnFlows(this.method.getMultiMethodKey());
        if (this.graphKind == MethodFlowsGraph.GraphKind.STUB) {
            AnalysisError.guarantee(insertPlaceholderFlows, "placeholder flows must be enabled for STUB graphkinds.", new Object[0]);
            this.insertPlaceholderParamAndReturnFlows();
            return;
        }
        if (!this.parse(reason, forceReparse)) {
            return;
        }
        this.bb.getHostVM().methodBeforeTypeFlowCreationHook(this.bb, this.method, this.graph);
        this.createTypeFlow();
        if (insertPlaceholderFlows) {
            this.insertPlaceholderParamAndReturnFlows();
        }
        this.method.setAnalyzedGraph(GraphEncoder.encodeSingleGraph((StructuredGraph)this.graph, (Architecture)AnalysisParsedGraph.HOST_ARCHITECTURE, (Iterable)this.flowsGraph.getNodeFlows().getKeys()));
    }

    protected boolean delegateNodeProcessing(FixedNode n, TypeFlowsOfNodes state) {
        return false;
    }

    protected void processMacroInvokable(TypeFlowsOfNodes state, MacroInvokable macro, boolean installResult) {
        ValueNode macroNode = macro.asNode();
        BytecodePosition invokePosition = this.getInvokePosition(macro, macroNode);
        this.processMethodInvocation(state, macroNode, macro.getInvokeKind(), (PointsToAnalysisMethod)macro.getTargetMethod(), (NodeInputList<ValueNode>)macro.getArguments(), installResult, invokePosition, false);
    }

    private BytecodePosition getInvokePosition(MacroInvokable macro, ValueNode macroNode) {
        NodeSourcePosition invokePosition = null;
        NodeSourcePosition position = macroNode.getNodeSourcePosition();
        if (position != null) {
            assert (position.getMethod().equals((Object)macro.getTargetMethod())) : "Unexpected macro node source position: " + String.valueOf(macro) + " at " + String.valueOf(position);
            invokePosition = position.getCaller();
        }
        if (invokePosition == null) {
            invokePosition = AbstractAnalysisEngine.syntheticSourcePosition((Node)macroNode, this.method);
        }
        return invokePosition;
    }

    protected void processMethodInvocation(TypeFlowsOfNodes state, Invoke invoke, CallTargetNode.InvokeKind invokeKind, PointsToAnalysisMethod targetMethod, NodeInputList<ValueNode> arguments) {
        FixedNode invokeNode = invoke.asFixedNode();
        BytecodePosition invokePosition = this.getInvokePosition(invokeNode);
        this.processMethodInvocation(state, (ValueNode)invokeNode, invokeKind, targetMethod, arguments, true, invokePosition, false);
    }

    protected BytecodePosition getInvokePosition(FixedNode invokeNode) {
        NodeSourcePosition invokePosition;
        for (invokePosition = invokeNode.getNodeSourcePosition(); invokePosition != null && invokePosition.getCaller() != null; invokePosition = invokePosition.getCaller()) {
        }
        if (invokePosition == null) {
            invokePosition = AbstractAnalysisEngine.syntheticSourcePosition((Node)invokeNode, this.method);
        }
        return invokePosition;
    }

    protected void processMethodInvocation(TypeFlowsOfNodes state, ValueNode invoke, CallTargetNode.InvokeKind invokeKind, PointsToAnalysisMethod targetMethod, NodeInputList<ValueNode> arguments, boolean installResult, BytecodePosition invokeLocation, boolean createDeoptInvokeTypeFlow) {
        this.bb.isCallAllowed(this.bb, this.method, targetMethod, invokeLocation);
        TypeFlowBuilder[] actualParametersBuilders = new TypeFlowBuilder[arguments.size()];
        for (int i = 0; i < actualParametersBuilders.length; ++i) {
            TypeFlowBuilder<?> paramBuilder;
            ValueNode actualParam = (ValueNode)arguments.get(i);
            if (!this.bb.isSupportedJavaKind(actualParam.getStackKind())) continue;
            actualParametersBuilders[i] = paramBuilder = state.lookup(actualParam);
            paramBuilder.markAsBuildingAnActualParameter();
            this.typeFlowGraphBuilder.registerSinkBuilder(paramBuilder);
        }
        TypeFlowBuilder<InvokeTypeFlow> invokeBuilder = TypeFlowBuilder.create(this.bb, invoke, InvokeTypeFlow.class, () -> {
            InvokeTypeFlow invokeFlow;
            TypeFlow[] actualParameters = new TypeFlow[actualParametersBuilders.length];
            for (int i = 0; i < actualParameters.length; ++i) {
                actualParameters[i] = actualParametersBuilders[i] != null ? actualParametersBuilders[i].get() : null;
            }
            ActualReturnTypeFlow actualReturn = null;
            AnalysisType receiverType = null;
            if (invokeKind.hasReceiver()) {
                receiverType = targetMethod.getDeclaringClass();
                AnalysisType receiverArgType = (AnalysisType)StampTool.typeOrNull((ValueNode)((ValueNode)arguments.get(0)));
                if (receiverArgType != null && receiverType.isAssignableFrom(receiverArgType)) {
                    receiverType = receiverArgType;
                }
            }
            MultiMethod.MultiMethodKey multiMethodKey = this.method.getMultiMethodKey();
            if (createDeoptInvokeTypeFlow) {
                invokeFlow = this.bb.analysisPolicy().createDeoptInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, multiMethodKey);
            } else {
                switch (invokeKind) {
                    case Static: {
                        invokeFlow = this.bb.analysisPolicy().createStaticInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, multiMethodKey);
                        break;
                    }
                    case Special: {
                        invokeFlow = this.bb.analysisPolicy().createSpecialInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, multiMethodKey);
                        break;
                    }
                    case Virtual: 
                    case Interface: {
                        invokeFlow = this.bb.analysisPolicy().createVirtualInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, multiMethodKey);
                        break;
                    }
                    default: {
                        throw JVMCIError.shouldNotReachHere();
                    }
                }
            }
            this.flowsGraph.addInvoke(invokeFlow);
            this.flowsGraph.addNodeFlow((Node)invoke, invokeFlow);
            if (invokeKind == CallTargetNode.InvokeKind.Special || invokeKind == CallTargetNode.InvokeKind.Virtual || invokeKind == CallTargetNode.InvokeKind.Interface) {
                this.bb.analysisPolicy().addOriginalObserver(this.bb, actualParameters[0], invokeFlow);
            }
            return invokeFlow;
        });
        if (!createDeoptInvokeTypeFlow && this.bb.isSupportedJavaKind(invoke.asNode().getStackKind())) {
            AnalysisType returnType = (AnalysisType)targetMethod.getSignature().getReturnType();
            TypeFlowBuilder<TypeFlow> actualReturnBuilder = TypeFlowBuilder.create(this.bb, invoke.asNode(), ActualReturnTypeFlow.class, () -> {
                InvokeTypeFlow invokeFlow = (InvokeTypeFlow)invokeBuilder.get();
                ActualReturnTypeFlow actualReturn = new ActualReturnTypeFlow((BytecodePosition)invokeFlow.source, returnType);
                this.flowsGraph.addMiscEntryFlow(actualReturn);
                invokeFlow.setActualReturn(this.bb, targetMethod.isStatic(), actualReturn);
                actualReturn.setInvokeFlow(invokeFlow);
                return actualReturn;
            });
            Stamp stamp = invoke.stamp(NodeView.DEFAULT);
            if (stamp instanceof ObjectStamp) {
                ObjectStamp stamp2 = (ObjectStamp)stamp;
                AnalysisType stampType = (AnalysisType)StampTool.typeOrNull((Stamp)stamp2, (MetaAccessProvider)this.bb.getMetaAccess());
                if (stamp2.nonNull() && !returnType.equals(stampType) && returnType.isAssignableFrom(stampType)) {
                    TypeFlowBuilder<FilterTypeFlow> filterBuilder = TypeFlowBuilder.create(this.bb, invoke, FilterTypeFlow.class, () -> {
                        FilterTypeFlow filterFlow = new FilterTypeFlow(invokeLocation, stampType, stamp2.isExactType(), true, true);
                        this.flowsGraph.addMiscEntryFlow(filterFlow);
                        return filterFlow;
                    });
                    filterBuilder.addUseDependency(actualReturnBuilder);
                    actualReturnBuilder = filterBuilder;
                }
            }
            this.typeFlowGraphBuilder.registerSinkBuilder(actualReturnBuilder);
            if (installResult) {
                state.add(invoke.asNode(), actualReturnBuilder);
            }
        }
        this.typeFlowGraphBuilder.registerSinkBuilder(invokeBuilder);
    }

    protected void processCommitAllocation(CommitAllocationNode commitAllocationNode, TypeFlowsOfNodes state) {
        HashMap<VirtualObjectNode, AllocatedObjectNode> allocatedObjects = new HashMap<VirtualObjectNode, AllocatedObjectNode>();
        for (AllocatedObjectNode allocatedObjectNode : commitAllocationNode.usages().filter(AllocatedObjectNode.class)) {
            AnalysisType type = (AnalysisType)allocatedObjectNode.getVirtualObject().type();
            this.processNewInstance((ValueNode)allocatedObjectNode, type, state);
            allocatedObjects.put(allocatedObjectNode.getVirtualObject(), allocatedObjectNode);
        }
        List values = commitAllocationNode.getValues();
        int objectStartIndex = 0;
        for (VirtualObjectNode virtualObject : commitAllocationNode.getVirtualObjects()) {
            AnalysisType type = (AnalysisType)virtualObject.type();
            ValueNode object = (ValueNode)allocatedObjects.get(virtualObject);
            if (object == null) {
                object = virtualObject;
            }
            for (int i = 0; i < virtualObject.entryCount(); ++i) {
                ValueNode value = (ValueNode)values.get(objectStartIndex + i);
                if (value.isJavaConstant() && value.asJavaConstant().isDefaultForKind()) continue;
                if (type.isArray()) {
                    this.processStoreIndexed((ValueNode)commitAllocationNode, object, value, state);
                    continue;
                }
                AnalysisField field = (AnalysisField)((VirtualInstanceNode)virtualObject).field(i);
                this.processStoreField((ValueNode)commitAllocationNode, field, object, value, state);
            }
            objectStartIndex += virtualObject.entryCount();
        }
        assert (values.size() == objectStartIndex) : values;
    }

    protected void processNewInstance(NewInstanceNode node, TypeFlowsOfNodes state) {
        this.processNewInstance((ValueNode)node, (AnalysisType)node.instanceClass(), state);
    }

    protected void processNewArray(NewArrayNode node, TypeFlowsOfNodes state) {
        this.processNewInstance((ValueNode)node, ((AnalysisType)node.elementType()).getArrayClass(), state);
    }

    protected void processNewInstance(ValueNode node, AnalysisType type, TypeFlowsOfNodes state) {
        assert (type.isInstantiated()) : type;
        TypeFlowBuilder<NewInstanceTypeFlow> newInstanceBuilder = TypeFlowBuilder.create(this.bb, node, NewInstanceTypeFlow.class, () -> {
            NewInstanceTypeFlow newInstance = new NewInstanceTypeFlow(AbstractAnalysisEngine.sourcePosition(node), type);
            this.flowsGraph.addMiscEntryFlow(newInstance);
            return newInstance;
        });
        state.add(node, newInstanceBuilder);
    }

    protected void processStoreField(StoreFieldNode node, TypeFlowsOfNodes state) {
        this.processStoreField((ValueNode)node, (AnalysisField)node.field(), node.object(), node.value(), state);
    }

    protected void processStoreField(ValueNode node, AnalysisField field, ValueNode object, ValueNode value, TypeFlowsOfNodes state) {
        assert (field.isWritten()) : field;
        if (this.bb.isSupportedJavaKind(value.getStackKind())) {
            TypeFlowBuilder<StoreFieldTypeFlow> storeFieldBuilder;
            TypeFlowBuilder<?> valueBuilder = state.lookup(value);
            BytecodePosition storeLocation = AbstractAnalysisEngine.sourcePosition(node);
            if (field.isStatic()) {
                storeFieldBuilder = TypeFlowBuilder.create(this.bb, node, StoreFieldTypeFlow.class, () -> {
                    FieldTypeFlow fieldFlow = field.getStaticFieldFlow();
                    StoreFieldTypeFlow.StoreStaticFieldTypeFlow storeFieldFlow = new StoreFieldTypeFlow.StoreStaticFieldTypeFlow(storeLocation, field, (TypeFlow<?>)valueBuilder.get(), fieldFlow);
                    this.flowsGraph.addMiscEntryFlow(storeFieldFlow);
                    return storeFieldFlow;
                });
                storeFieldBuilder.addUseDependency(valueBuilder);
            } else {
                TypeFlowBuilder<?> objectBuilder = state.lookup(object);
                storeFieldBuilder = TypeFlowBuilder.create(this.bb, node, StoreFieldTypeFlow.class, () -> {
                    StoreFieldTypeFlow.StoreInstanceFieldTypeFlow storeFieldFlow = new StoreFieldTypeFlow.StoreInstanceFieldTypeFlow(storeLocation, field, (TypeFlow<?>)valueBuilder.get(), (TypeFlow<?>)objectBuilder.get());
                    this.flowsGraph.addMiscEntryFlow(storeFieldFlow);
                    return storeFieldFlow;
                });
                storeFieldBuilder.addUseDependency(valueBuilder);
                storeFieldBuilder.addObserverDependency(objectBuilder);
            }
            this.typeFlowGraphBuilder.registerSinkBuilder(storeFieldBuilder);
        }
    }

    private void processStoreIndexed(StoreIndexedNode node, TypeFlowsOfNodes state) {
        this.processStoreIndexed((ValueNode)node, node.array(), node.value(), state);
    }

    private void processStoreIndexed(ValueNode node, ValueNode array, ValueNode value, TypeFlowsOfNodes state) {
        if (value.getStackKind() == JavaKind.Object) {
            AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)array, (MetaAccessProvider)this.bb.getMetaAccess());
            AnalysisType arrayType = type.isArray() ? type : this.bb.getObjectArrayType();
            TypeFlowBuilder<?> arrayBuilder = state.lookup(array);
            TypeFlowBuilder<?> valueBuilder = state.lookup(value);
            TypeFlowBuilder<OffsetStoreTypeFlow.StoreIndexedTypeFlow> storeIndexedBuilder = TypeFlowBuilder.create(this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                OffsetStoreTypeFlow.StoreIndexedTypeFlow storeIndexedFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow(AbstractAnalysisEngine.sourcePosition(node), arrayType, (TypeFlow<?>)arrayBuilder.get(), (TypeFlow<?>)valueBuilder.get());
                this.flowsGraph.addMiscEntryFlow(storeIndexedFlow);
                return storeIndexedFlow;
            });
            storeIndexedBuilder.addUseDependency(valueBuilder);
            storeIndexedBuilder.addObserverDependency(arrayBuilder);
            this.typeFlowGraphBuilder.registerSinkBuilder(storeIndexedBuilder);
        }
    }

    protected void checkUnsafeOffset(ValueNode base, ValueNode offset) {
    }

    private void processImplicitNonNull(ValueNode node, TypeFlowsOfNodes state) {
        this.processImplicitNonNull(node, node, state);
    }

    protected void processImplicitNonNull(ValueNode node, ValueNode source, TypeFlowsOfNodes state) {
        assert (node.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp) : node;
        if (!StampTool.isPointerNonNull((ValueNode)node)) {
            TypeFlowBuilder<?> inputBuilder = state.lookup(node);
            TypeFlowBuilder<NullCheckTypeFlow> nullCheckBuilder = TypeFlowBuilder.create(this.bb, source, NullCheckTypeFlow.class, () -> {
                NullCheckTypeFlow nullCheck;
                Object inputFlow = inputBuilder.get();
                if (inputFlow instanceof NullCheckTypeFlow && (nullCheck = (NullCheckTypeFlow)inputFlow).isBlockingNull()) {
                    return nullCheck;
                }
                NullCheckTypeFlow nullCheckFlow = new NullCheckTypeFlow(AbstractAnalysisEngine.sourcePosition(source), ((TypeFlow)inputFlow).getDeclaredType(), true);
                this.flowsGraph.addMiscEntryFlow(nullCheckFlow);
                return nullCheckFlow;
            });
            nullCheckBuilder.addUseDependency(inputBuilder);
            state.update(node, nullCheckBuilder);
        }
    }

    private /* synthetic */ BoxTypeFlow lambda$createTypeFlow$2(BoxNode node, AnalysisType type) {
        BoxTypeFlow boxFlow = new BoxTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), type);
        this.flowsGraph.addMiscEntryFlow(boxFlow);
        return boxFlow;
    }

    protected class TypeFlowsOfNodes
    extends MergeableState<TypeFlowsOfNodes>
    implements Cloneable {
        private final Map<Node, TypeFlowBuilder<?>> flows;

        TypeFlowsOfNodes() {
            this.flows = new HashMap();
        }

        protected TypeFlowsOfNodes(TypeFlowsOfNodes copyFrom) {
            this.flows = new HashMap(copyFrom.flows);
        }

        public boolean contains(ValueNode node) {
            return this.flows.containsKey(MethodTypeFlowBuilder.this.typeFlowUnproxify(node));
        }

        public TypeFlowBuilder<?> lookup(ValueNode n) {
            ValueNode node = MethodTypeFlowBuilder.this.typeFlowUnproxify(n);
            TypeFlowBuilder<Object> result = this.flows.get(node);
            if (result == null) {
                Stamp s = n.stamp(NodeView.DEFAULT);
                if (s instanceof IntegerStamp) {
                    IntegerStamp stamp = (IntegerStamp)s;
                    long lo = stamp.lowerBound();
                    long hi = stamp.upperBound();
                    AnalysisType type = (AnalysisType)stamp.javaType((MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    result = lo == hi ? TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, ConstantPrimitiveSourceTypeFlow.class, () -> {
                        ConstantPrimitiveSourceTypeFlow flow = new ConstantPrimitiveSourceTypeFlow(AbstractAnalysisEngine.sourcePosition(node), type, lo);
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(flow);
                        return flow;
                    }) : MethodTypeFlowBuilder.this.anyPrimitiveSourceTypeFlowBuilder;
                } else if (s instanceof ObjectStamp) {
                    ObjectStamp stamp = (ObjectStamp)s;
                    if (stamp.isEmpty()) {
                        throw AnalysisError.shouldNotReachHere("Stamp for node " + String.valueOf(n) + " is empty.");
                    }
                    AnalysisType stampType = (AnalysisType)StampTool.typeOrNull((Stamp)stamp, (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    result = stamp.isExactType() ? TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, SourceTypeFlow.class, () -> {
                        SourceTypeFlow src = new SourceTypeFlow(AbstractAnalysisEngine.sourcePosition(node), stampType, !stamp.nonNull());
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(src);
                        return src;
                    }) : TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, TypeFlow.class, () -> {
                        TypeFlow<?> proxy = MethodTypeFlowBuilder.this.bb.analysisPolicy().proxy(AbstractAnalysisEngine.sourcePosition(node), stampType.getTypeFlow(MethodTypeFlowBuilder.this.bb, true));
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(proxy);
                        return proxy;
                    });
                } else {
                    AnalysisError.shouldNotReachHere("Unsupported stamp " + String.valueOf(s));
                }
                this.flows.put((Node)node, result);
            }
            return result;
        }

        public void add(ValueNode node, TypeFlowBuilder<?> flow) {
            assert (!this.contains(node)) : node;
            this.flows.put((Node)MethodTypeFlowBuilder.this.typeFlowUnproxify(node), flow);
        }

        public void update(ValueNode node, TypeFlowBuilder<?> flow) {
            assert (this.contains(node)) : node;
            this.flows.put((Node)MethodTypeFlowBuilder.this.typeFlowUnproxify(node), flow);
        }

        public boolean merge(AbstractMergeNode merge, List<TypeFlowsOfNodes> withStates) {
            for (AbstractEndNode end : merge.forwardEnds()) {
                if (MethodTypeFlowBuilder.this.processedNodes.contains((Node)end)) continue;
                return false;
            }
            Iterator<Map.Entry<Node, TypeFlowBuilder<?>>> iterator = this.flows.entrySet().iterator();
            block1: while (iterator.hasNext()) {
                Map.Entry<Node, TypeFlowBuilder<?>> entry = iterator.next();
                Node node = entry.getKey();
                TypeFlowBuilder<?> oldFlow = entry.getValue();
                TypeFlowBuilder<Object> newFlow = oldFlow;
                for (TypeFlowsOfNodes other : withStates) {
                    TypeFlowBuilder<?> mergeFlow = other.flows.get(node);
                    if (mergeFlow == null) {
                        iterator.remove();
                        continue block1;
                    }
                    if (mergeFlow == newFlow) continue;
                    if (newFlow == oldFlow) {
                        newFlow = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, merge, MergeTypeFlow.class, () -> {
                            MergeTypeFlow newMergeFlow = new MergeTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)merge));
                            MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(newMergeFlow);
                            return newMergeFlow;
                        });
                        newFlow.addUseDependency(oldFlow);
                        entry.setValue(newFlow);
                    }
                    newFlow.addUseDependency(mergeFlow);
                }
            }
            return true;
        }

        public TypeFlowsOfNodes clone() {
            return new TypeFlowsOfNodes(this);
        }
    }

    class NodeIterator
    extends PostOrderNodeIterator<TypeFlowsOfNodes> {
        private TypeFlowBuilder<?> returnBuilder;

        NodeIterator(FixedNode start, TypeFlowsOfNodes typeFlows) {
            super(start, (MergeableState)typeFlows);
            this.returnBuilder = null;
        }

        private TypeFlowBuilder<?> uniqueReturnFlowBuilder(ReturnNode node) {
            AnalysisType returnType;
            if (this.returnBuilder == null && MethodTypeFlowBuilder.this.bb.isSupportedJavaKind((returnType = (AnalysisType)MethodTypeFlowBuilder.this.method.getSignature().getReturnType()).getJavaKind())) {
                this.returnBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, FormalReturnTypeFlow.class, () -> {
                    FormalReturnTypeFlow returnFlow = MethodTypeFlowBuilder.this.flowsGraph.getReturnFlow();
                    if (returnFlow != null) {
                        returnFlow.updateSource(AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                    } else {
                        assert (MethodTypeFlowBuilder.this.newFlowsGraph) : "missing flow from original graph " + String.valueOf(returnFlow);
                        returnFlow = new FormalReturnTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), returnType);
                        MethodTypeFlowBuilder.this.flowsGraph.setReturnFlow(returnFlow);
                    }
                    return returnFlow;
                });
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(this.returnBuilder);
            }
            return this.returnBuilder;
        }

        private void handleCondition(ValueNode source, LogicNode condition, boolean isTrue) {
            if (condition instanceof IsNullNode) {
                IsNullNode nullCheck = (IsNullNode)condition;
                ValueNode object = nullCheck.getValue();
                TypeFlowBuilder<?> inputBuilder = ((TypeFlowsOfNodes)this.state).lookup(object);
                TypeFlowBuilder<NullCheckTypeFlow> nullCheckBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, source, NullCheckTypeFlow.class, () -> {
                    NullCheckTypeFlow nullCheckFlow = new NullCheckTypeFlow(AbstractAnalysisEngine.sourcePosition(source), ((TypeFlow)inputBuilder.get()).getDeclaredType(), !isTrue);
                    MethodTypeFlowBuilder.this.flowsGraph.addNodeFlow((Node)source, nullCheckFlow);
                    return nullCheckFlow;
                });
                nullCheckBuilder.addUseDependency(inputBuilder);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(nullCheckBuilder);
                ((TypeFlowsOfNodes)this.state).update(object, nullCheckBuilder);
            } else if (condition instanceof InstanceOfNode) {
                InstanceOfNode instanceOf = (InstanceOfNode)condition;
                ValueNode object = instanceOf.getValue();
                TypeReference typeReference = instanceOf.type();
                AnalysisType type = (AnalysisType)instanceOf.type().getType();
                TypeFlowBuilder<FilterTypeFlow> filterBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, source, FilterTypeFlow.class, () -> {
                    FilterTypeFlow filterFlow = new FilterTypeFlow(AbstractAnalysisEngine.sourcePosition(source), type, typeReference.isExact(), isTrue, !isTrue ^ instanceOf.allowsNull());
                    MethodTypeFlowBuilder.this.flowsGraph.addNodeFlow((Node)source, filterFlow);
                    return filterFlow;
                });
                filterBuilder.addUseDependency(((TypeFlowsOfNodes)this.state).lookup(object));
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(filterBuilder);
                ((TypeFlowsOfNodes)this.state).update(object, filterBuilder);
            }
        }

        protected void node(FixedNode n) {
            MethodTypeFlowBuilder.this.processedNodes.mark((Node)n);
            if (MethodTypeFlowBuilder.this.delegateNodeProcessing(n, (TypeFlowsOfNodes)this.state)) {
                return;
            }
            if (n instanceof LoopEndNode) {
                LoopEndNode end = (LoopEndNode)n;
                LoopBeginNode merge = end.loopBegin();
                int predIdx = merge.phiPredecessorIndex((AbstractEndNode)end);
                for (PhiNode phi : merge.phis()) {
                    if (!MethodTypeFlowBuilder.this.bb.isSupportedJavaKind(phi.getStackKind())) continue;
                    MethodTypeFlowBuilder.this.loopPhiFlows.get(phi).addUseDependency(((TypeFlowsOfNodes)this.state).lookup(phi.valueAt(predIdx)));
                }
            } else if (n instanceof LoopBeginNode) {
                LoopBeginNode merge = (LoopBeginNode)n;
                for (PhiNode phi : merge.phis()) {
                    if (!MethodTypeFlowBuilder.this.bb.isSupportedJavaKind(phi.getStackKind())) continue;
                    TypeFlowBuilder<MergeTypeFlow> newFlowBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, merge, MergeTypeFlow.class, () -> {
                        MergeTypeFlow newFlow = new MergeTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)merge));
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(newFlow);
                        return newFlow;
                    });
                    newFlowBuilder.addUseDependency(((TypeFlowsOfNodes)this.state).lookup((ValueNode)phi));
                    ((TypeFlowsOfNodes)this.state).update((ValueNode)phi, newFlowBuilder);
                    if (MethodTypeFlowBuilder.this.loopPhiFlows == null) {
                        MethodTypeFlowBuilder.this.loopPhiFlows = new HashMap();
                    }
                    MethodTypeFlowBuilder.this.loopPhiFlows.put(phi, newFlowBuilder);
                }
            } else if (n instanceof EndNode) {
                EndNode end = (EndNode)n;
                AbstractMergeNode merge = end.merge();
                int predIdx = merge.phiPredecessorIndex((AbstractEndNode)end);
                for (PhiNode phi : merge.phis()) {
                    if (!MethodTypeFlowBuilder.this.bb.isSupportedJavaKind(phi.getStackKind())) continue;
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)phi, ((TypeFlowsOfNodes)this.state).lookup(phi.valueAt(predIdx)));
                }
            } else if (n instanceof ExceptionObjectNode) {
                ExceptionObjectNode node = (ExceptionObjectNode)n;
                TypeFlowBuilder<TypeFlow> exceptionObjectBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, TypeFlow.class, () -> {
                    TypeFlow<?> input = ((AnalysisType)StampTool.typeOrNull((ValueNode)node, (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess())).getTypeFlow(MethodTypeFlowBuilder.this.bb, false);
                    TypeFlow<?> exceptionObjectFlow = MethodTypeFlowBuilder.this.bb.analysisPolicy().proxy(AbstractAnalysisEngine.sourcePosition((ValueNode)node), input);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(exceptionObjectFlow);
                    return exceptionObjectFlow;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, exceptionObjectBuilder);
            } else if (n instanceof BeginNode) {
                BeginNode node = (BeginNode)n;
                Node pred = node.predecessor();
                if (pred instanceof IfNode) {
                    IfNode ifNode = (IfNode)pred;
                    this.handleCondition((ValueNode)node, ifNode.condition(), node == ifNode.trueSuccessor());
                }
            } else if (n instanceof FixedGuardNode) {
                FixedGuardNode node = (FixedGuardNode)n;
                this.handleCondition((ValueNode)node, node.condition(), !node.isNegated());
            } else if (n instanceof ReturnNode) {
                ReturnNode node;
                if (!MethodTypeFlowBuilder.this.method.getReturnsAllInstantiatedTypes() && (node = (ReturnNode)n).result() != null && MethodTypeFlowBuilder.this.bb.isSupportedJavaKind(node.result().getStackKind())) {
                    TypeFlowBuilder<?> returnFlowBuilder = this.uniqueReturnFlowBuilder(node);
                    returnFlowBuilder.addUseDependency(((TypeFlowsOfNodes)this.state).lookup(node.result()));
                }
            } else if (n instanceof CommitAllocationNode) {
                MethodTypeFlowBuilder.this.processCommitAllocation((CommitAllocationNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof NewInstanceNode) {
                MethodTypeFlowBuilder.this.processNewInstance((NewInstanceNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof DynamicNewInstanceNode) {
                TypeFlowBuilder<AllInstantiatedTypeFlow> instanceTypeBuilder;
                AnalysisType instanceType;
                DynamicNewInstanceNode node = (DynamicNewInstanceNode)n;
                ValueNode instanceTypeNode = node.getInstanceType();
                if (instanceTypeNode instanceof GetClassNode) {
                    GetClassNode getClassNode = (GetClassNode)instanceTypeNode;
                    ValueNode getClassReceiver = getClassNode.getObject();
                    instanceType = (AnalysisType)StampTool.typeOrNull((ValueNode)getClassReceiver, (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    instanceTypeBuilder = ((TypeFlowsOfNodes)this.state).lookup(getClassReceiver);
                } else {
                    instanceType = MethodTypeFlowBuilder.this.bb.getObjectType();
                    instanceTypeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, instanceType, AllInstantiatedTypeFlow.class, () -> (AllInstantiatedTypeFlow)instanceType.getTypeFlow(MethodTypeFlowBuilder.this.bb, false));
                }
                TypeFlowBuilder<DynamicNewInstanceTypeFlow> dynamicNewInstanceBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, DynamicNewInstanceTypeFlow.class, () -> {
                    DynamicNewInstanceTypeFlow newInstanceTypeFlow = new DynamicNewInstanceTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), (TypeFlow<?>)instanceTypeBuilder.get(), instanceType);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(newInstanceTypeFlow);
                    return newInstanceTypeFlow;
                });
                if (instanceTypeNode instanceof GetClassNode) {
                    dynamicNewInstanceBuilder.addObserverDependency(instanceTypeBuilder);
                }
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, dynamicNewInstanceBuilder);
            } else if (n instanceof NewArrayNode) {
                MethodTypeFlowBuilder.this.processNewArray((NewArrayNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof DynamicNewArrayNode) {
                DynamicNewArrayNode node = (DynamicNewArrayNode)n;
                AnalysisType arrayType = MethodTypeFlowBuilder.this.bb.getObjectType();
                TypeFlowBuilder<DynamicNewInstanceTypeFlow> dynamicNewArrayBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, DynamicNewInstanceTypeFlow.class, () -> {
                    DynamicNewInstanceTypeFlow newArrayTypeFlow = new DynamicNewInstanceTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), arrayType.getTypeFlow(MethodTypeFlowBuilder.this.bb, false), arrayType);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(newArrayTypeFlow);
                    return newArrayTypeFlow;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, dynamicNewArrayBuilder);
            } else if (n instanceof NewMultiArrayNode) {
                NewMultiArrayNode node = (NewMultiArrayNode)n;
                AnalysisType type = (AnalysisType)node.type();
                assert (type.isInstantiated()) : type;
                TypeFlowBuilder<NewInstanceTypeFlow> newArrayBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, NewInstanceTypeFlow.class, () -> {
                    NewInstanceTypeFlow newArray = new NewInstanceTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), type);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(newArray);
                    return newArray;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, newArrayBuilder);
            } else if (n instanceof LoadFieldNode) {
                LoadFieldNode node = (LoadFieldNode)n;
                AnalysisField field = (AnalysisField)node.field();
                assert (field.isAccessed()) : field;
                if (MethodTypeFlowBuilder.this.bb.isSupportedJavaKind(node.getStackKind())) {
                    TypeFlowBuilder<LoadFieldTypeFlow> loadFieldBuilder;
                    BytecodePosition loadLocation = AbstractAnalysisEngine.sourcePosition((ValueNode)node);
                    if (node.isStatic()) {
                        loadFieldBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, LoadFieldTypeFlow.LoadStaticFieldTypeFlow.class, () -> {
                            FieldTypeFlow fieldFlow = field.getStaticFieldFlow();
                            LoadFieldTypeFlow.LoadStaticFieldTypeFlow loadFieldFLow = new LoadFieldTypeFlow.LoadStaticFieldTypeFlow(loadLocation, field, fieldFlow);
                            MethodTypeFlowBuilder.this.flowsGraph.addNodeFlow((Node)node, loadFieldFLow);
                            return loadFieldFLow;
                        });
                    } else {
                        TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                        loadFieldBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, LoadFieldTypeFlow.LoadInstanceFieldTypeFlow.class, () -> {
                            LoadFieldTypeFlow.LoadInstanceFieldTypeFlow loadFieldFLow = new LoadFieldTypeFlow.LoadInstanceFieldTypeFlow(loadLocation, field, (TypeFlow<?>)objectBuilder.get());
                            MethodTypeFlowBuilder.this.flowsGraph.addNodeFlow((Node)node, loadFieldFLow);
                            return loadFieldFLow;
                        });
                        loadFieldBuilder.addObserverDependency(objectBuilder);
                    }
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(loadFieldBuilder);
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)node, loadFieldBuilder);
                }
                if (node.object() != null) {
                    MethodTypeFlowBuilder.this.processImplicitNonNull(node.object(), (TypeFlowsOfNodes)this.state);
                }
            } else if (n instanceof StoreFieldNode) {
                StoreFieldNode node = (StoreFieldNode)n;
                MethodTypeFlowBuilder.this.processStoreField(node, (TypeFlowsOfNodes)this.state);
                if (node.object() != null) {
                    MethodTypeFlowBuilder.this.processImplicitNonNull(node.object(), (TypeFlowsOfNodes)this.state);
                }
            } else if (n instanceof LoadIndexedNode) {
                LoadIndexedNode node = (LoadIndexedNode)n;
                TypeFlowBuilder<?> arrayBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.array());
                if (node.getStackKind() == JavaKind.Object) {
                    AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node.array(), (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    AnalysisType arrayType = type.isArray() ? type : MethodTypeFlowBuilder.this.bb.getObjectArrayType();
                    TypeFlowBuilder<OffsetLoadTypeFlow.LoadIndexedTypeFlow> loadIndexedBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.LoadIndexedTypeFlow.class, () -> {
                        OffsetLoadTypeFlow.LoadIndexedTypeFlow loadIndexedFlow = new OffsetLoadTypeFlow.LoadIndexedTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), arrayType, (TypeFlow<?>)arrayBuilder.get());
                        MethodTypeFlowBuilder.this.flowsGraph.addNodeFlow((Node)node, loadIndexedFlow);
                        return loadIndexedFlow;
                    });
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(loadIndexedBuilder);
                    loadIndexedBuilder.addObserverDependency(arrayBuilder);
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)node, loadIndexedBuilder);
                }
                MethodTypeFlowBuilder.this.processImplicitNonNull(node.array(), (TypeFlowsOfNodes)this.state);
            } else if (n instanceof StoreIndexedNode) {
                StoreIndexedNode node = (StoreIndexedNode)n;
                MethodTypeFlowBuilder.this.processStoreIndexed(node, (TypeFlowsOfNodes)this.state);
                MethodTypeFlowBuilder.this.processImplicitNonNull(node.array(), (TypeFlowsOfNodes)this.state);
            } else if (n instanceof UnsafePartitionLoadNode) {
                UnsafePartitionLoadNode node = (UnsafePartitionLoadNode)n;
                assert (node.object().getStackKind() == JavaKind.Object) : node.object();
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                AnalysisType partitionType = (AnalysisType)node.partitionType();
                AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object(), (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                assert (MethodTypeFlowBuilder.this.bb.getGraalNodeType().isAssignableFrom(objectType)) : objectType;
                AnalysisType componentType = MethodTypeFlowBuilder.this.bb.getObjectType();
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                TypeFlowBuilder<OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow> unsafeLoadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, (Object)node, OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow.class, () -> {
                    OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), objectType, componentType, (TypeFlow<?>)objectBuilder.get(), node.unsafePartitionKind(), partitionType);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(loadTypeFlow);
                    return loadTypeFlow;
                });
                unsafeLoadBuilder.addObserverDependency(objectBuilder);
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, unsafeLoadBuilder);
            } else if (n instanceof UnsafePartitionStoreNode) {
                UnsafePartitionStoreNode node = (UnsafePartitionStoreNode)n;
                assert (node.object().getStackKind() == JavaKind.Object) : node.object();
                assert (node.value().getStackKind() == JavaKind.Object) : node.value();
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                AnalysisType partitionType = (AnalysisType)node.partitionType();
                AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object(), (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                assert (MethodTypeFlowBuilder.this.bb.getGraalNodeType().isAssignableFrom(objectType)) : objectType;
                AnalysisType componentType = MethodTypeFlowBuilder.this.bb.getObjectType();
                AnalysisType valueType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.value(), (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                assert (valueType.isJavaLangObject() || MethodTypeFlowBuilder.this.bb.getGraalNodeType().isAssignableFrom(valueType) || MethodTypeFlowBuilder.this.bb.getGraalNodeListType().isAssignableFrom(valueType)) : valueType;
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                TypeFlowBuilder<?> valueBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.value());
                TypeFlowBuilder<OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow> unsafeStoreBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, (Object)node, OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow.class, () -> {
                    OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), objectType, componentType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)valueBuilder.get(), node.partitionKind(), partitionType);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(storeTypeFlow);
                    return storeTypeFlow;
                });
                unsafeStoreBuilder.addUseDependency(valueBuilder);
                unsafeStoreBuilder.addObserverDependency(objectBuilder);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(unsafeStoreBuilder);
            } else if (n instanceof RawLoadNode) {
                RawLoadNode node = (RawLoadNode)n;
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                if (node.object().getStackKind() == JavaKind.Object && node.getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<OffsetLoadTypeFlow> loadBuilder;
                    AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object(), (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                    BytecodePosition loadLocation = AbstractAnalysisEngine.sourcePosition((ValueNode)node);
                    if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                        loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.LoadIndexedTypeFlow.class, () -> {
                            OffsetLoadTypeFlow.LoadIndexedTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.LoadIndexedTypeFlow(loadLocation, objectType, (TypeFlow<?>)objectBuilder.get());
                            MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(loadTypeFlow);
                            return loadTypeFlow;
                        });
                    } else {
                        AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                        loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.UnsafeLoadTypeFlow.class, () -> {
                            OffsetLoadTypeFlow.UnsafeLoadTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.UnsafeLoadTypeFlow(loadLocation, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get());
                            MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(loadTypeFlow);
                            return loadTypeFlow;
                        });
                    }
                    loadBuilder.addObserverDependency(objectBuilder);
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)node, loadBuilder);
                }
            } else if (n instanceof RawStoreNode) {
                RawStoreNode node = (RawStoreNode)n;
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                if (node.object().getStackKind() == JavaKind.Object && node.value().getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<OffsetStoreTypeFlow> storeBuilder;
                    AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object(), (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                    TypeFlowBuilder<?> valueBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.value());
                    BytecodePosition storeLocation = AbstractAnalysisEngine.sourcePosition((ValueNode)node);
                    if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.StoreIndexedTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow(storeLocation, objectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)valueBuilder.get());
                            MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    } else {
                        AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.UnsafeStoreTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.UnsafeStoreTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.UnsafeStoreTypeFlow(storeLocation, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)valueBuilder.get());
                            MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    }
                    storeBuilder.addUseDependency(valueBuilder);
                    storeBuilder.addObserverDependency(objectBuilder);
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(storeBuilder);
                }
            } else if (n instanceof UnsafeCompareAndSwapNode) {
                UnsafeCompareAndSwapNode node = (UnsafeCompareAndSwapNode)n;
                ValueNode object = node.object();
                ValueNode newValue = node.newValue();
                MethodTypeFlowBuilder.this.checkUnsafeOffset(object, node.offset());
                if (object.getStackKind() == JavaKind.Object && newValue.getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<OffsetStoreTypeFlow> storeBuilder;
                    AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)object, (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(object);
                    TypeFlowBuilder<?> newValueBuilder = ((TypeFlowsOfNodes)this.state).lookup(newValue);
                    BytecodePosition storeLocation = AbstractAnalysisEngine.sourcePosition((ValueNode)node);
                    if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.StoreIndexedTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow(storeLocation, objectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                            MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    } else {
                        AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.UnsafeStoreTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.UnsafeStoreTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.UnsafeStoreTypeFlow(storeLocation, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                            MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    }
                    storeBuilder.addUseDependency(newValueBuilder);
                    storeBuilder.addObserverDependency(objectBuilder);
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(storeBuilder);
                }
            } else if (n instanceof UnsafeCompareAndExchangeNode) {
                UnsafeCompareAndExchangeNode node = (UnsafeCompareAndExchangeNode)n;
                this.modelUnsafeReadAndWriteFlow((ValueNode)node, node.object(), node.newValue(), node.offset());
            } else if (n instanceof AtomicReadAndWriteNode) {
                AtomicReadAndWriteNode node = (AtomicReadAndWriteNode)n;
                this.modelUnsafeReadAndWriteFlow((ValueNode)node, node.object(), node.newValue(), node.offset());
            } else if (n instanceof BasicArrayCopyNode) {
                TypeFlowBuilder<?> dstBuilder;
                BasicArrayCopyNode node = (BasicArrayCopyNode)n;
                TypeFlowBuilder<?> srcBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getSource());
                if (srcBuilder != (dstBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getDestination()))) {
                    AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node.asNode(), (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                    TypeFlowBuilder<ArrayCopyTypeFlow> arrayCopyBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, ArrayCopyTypeFlow.class, () -> {
                        ArrayCopyTypeFlow arrayCopyFlow = new ArrayCopyTypeFlow(AbstractAnalysisEngine.sourcePosition(node.asNode()), type, (TypeFlow<?>)srcBuilder.get(), (TypeFlow<?>)dstBuilder.get());
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(arrayCopyFlow);
                        return arrayCopyFlow;
                    });
                    arrayCopyBuilder.addObserverDependency(srcBuilder);
                    arrayCopyBuilder.addObserverDependency(dstBuilder);
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(arrayCopyBuilder);
                }
            } else if (n instanceof InvokeNode || n instanceof InvokeWithExceptionNode) {
                Invoke invoke = (Invoke)n;
                CallTargetNode dstBuilder = invoke.callTarget();
                if (dstBuilder instanceof MethodCallTargetNode) {
                    MethodCallTargetNode target = (MethodCallTargetNode)dstBuilder;
                    NodeInputList arguments = target.arguments();
                    MethodTypeFlowBuilder.this.processMethodInvocation((TypeFlowsOfNodes)this.state, invoke, target.invokeKind(), (PointsToAnalysisMethod)target.targetMethod(), (NodeInputList<ValueNode>)arguments);
                    if (target.invokeKind().hasReceiver()) {
                        MethodTypeFlowBuilder.this.processImplicitNonNull((ValueNode)arguments.get(0), invoke.asNode(), (TypeFlowsOfNodes)this.state);
                    }
                }
            } else if (n instanceof ObjectClone) {
                ObjectClone node = (ObjectClone)n;
                TypeFlowBuilder<?> inputBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getObject());
                AnalysisType inputType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.getObject(), (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                TypeFlowBuilder<CloneTypeFlow> cloneBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, CloneTypeFlow.class, () -> {
                    CloneTypeFlow cloneFlow = new CloneTypeFlow(AbstractAnalysisEngine.sourcePosition(node.asNode()), inputType, (TypeFlow<?>)inputBuilder.get());
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(cloneFlow);
                    return cloneFlow;
                });
                cloneBuilder.addObserverDependency(inputBuilder);
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node.asFixedNode(), cloneBuilder);
            } else if (n instanceof MonitorEnterNode) {
                MonitorEnterNode node = (MonitorEnterNode)n;
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                TypeFlowBuilder<MonitorEnterTypeFlow> monitorEntryBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, MonitorEnterTypeFlow.class, () -> {
                    MonitorEnterTypeFlow monitorEntryFlow = new MonitorEnterTypeFlow(AbstractAnalysisEngine.sourcePosition((ValueNode)node), MethodTypeFlowBuilder.this.bb);
                    MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(monitorEntryFlow);
                    return monitorEntryFlow;
                });
                monitorEntryBuilder.addUseDependency(objectBuilder);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(monitorEntryBuilder);
            } else if (n instanceof MacroInvokable) {
                MacroInvokable node = (MacroInvokable)n;
                MethodTypeFlowBuilder.this.processMacroInvokable((TypeFlowsOfNodes)this.state, node, true);
                if (node.getInvokeKind().hasReceiver()) {
                    MethodTypeFlowBuilder.this.processImplicitNonNull(node.getArgument(0), node.asNode(), (TypeFlowsOfNodes)this.state);
                }
            }
        }

        private void modelUnsafeReadAndWriteFlow(ValueNode node, ValueNode object, ValueNode newValue, ValueNode offset) {
            assert (node instanceof UnsafeCompareAndExchangeNode || node instanceof AtomicReadAndWriteNode) : node;
            MethodTypeFlowBuilder.this.checkUnsafeOffset(object, offset);
            if (object.getStackKind() == JavaKind.Object && newValue.getStackKind() == JavaKind.Object) {
                TypeFlowBuilder<OffsetLoadTypeFlow> loadBuilder;
                TypeFlowBuilder<OffsetStoreTypeFlow> storeBuilder;
                AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)object, (MetaAccessProvider)MethodTypeFlowBuilder.this.bb.getMetaAccess());
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(object);
                TypeFlowBuilder<?> newValueBuilder = ((TypeFlowsOfNodes)this.state).lookup(newValue);
                BytecodePosition location = AbstractAnalysisEngine.sourcePosition(node);
                if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                    storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                        OffsetStoreTypeFlow.StoreIndexedTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow(location, objectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(storeTypeFlow);
                        return storeTypeFlow;
                    });
                    loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.LoadIndexedTypeFlow.class, () -> {
                        OffsetLoadTypeFlow.LoadIndexedTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.LoadIndexedTypeFlow(location, objectType, (TypeFlow<?>)objectBuilder.get());
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(loadTypeFlow);
                        return loadTypeFlow;
                    });
                } else {
                    AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                    storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.UnsafeStoreTypeFlow.class, () -> {
                        OffsetStoreTypeFlow.UnsafeStoreTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.UnsafeStoreTypeFlow(location, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(storeTypeFlow);
                        return storeTypeFlow;
                    });
                    loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.UnsafeLoadTypeFlow.class, () -> {
                        OffsetLoadTypeFlow.UnsafeLoadTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.UnsafeLoadTypeFlow(location, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get());
                        MethodTypeFlowBuilder.this.flowsGraph.addMiscEntryFlow(loadTypeFlow);
                        return loadTypeFlow;
                    });
                }
                storeBuilder.addUseDependency(newValueBuilder);
                storeBuilder.addObserverDependency(objectBuilder);
                loadBuilder.addObserverDependency(objectBuilder);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(storeBuilder);
                ((TypeFlowsOfNodes)this.state).add(node, loadBuilder);
            }
        }
    }
}

