/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaKind;

public class FieldTypeFlow
extends TypeFlow<AnalysisField> {
    private static final AtomicReferenceFieldUpdater<FieldTypeFlow, FieldFilterTypeFlow> FILTER_FLOW_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FieldTypeFlow.class, FieldFilterTypeFlow.class, "filterFlow");
    private AnalysisObject object;
    private volatile FieldFilterTypeFlow filterFlow;

    private static TypeState initialFieldState(AnalysisField field) {
        if (field.getJavaKind() == JavaKind.Object && field.canBeNull()) {
            return TypeState.forNull();
        }
        return TypeState.forEmpty();
    }

    public FieldTypeFlow(AnalysisField field, AnalysisType type) {
        super(field, FieldTypeFlow.filterUncheckedInterface(type), FieldTypeFlow.initialFieldState(field));
    }

    public FieldTypeFlow(AnalysisField field, AnalysisType type, AnalysisObject object) {
        this(field, type);
        this.object = object;
    }

    public AnalysisObject object() {
        return this.object;
    }

    @Override
    public TypeFlow<AnalysisField> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        throw JVMCIError.shouldNotReachHere((String)"The field flow should not be cloned. Use Load/StoreFieldTypeFlow.");
    }

    @Override
    public boolean canSaturate() {
        return false;
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        this.getDeclaredType().getTypeFlow(bb, true).addUse(bb, this);
    }

    public FieldFilterTypeFlow filterFlow(PointsToAnalysis bb) {
        assert (((AnalysisField)this.source).isUnsafeAccessed()) : "Filter flow requested for non unsafe accessed field.";
        if (this.filterFlow == null && FILTER_FLOW_UPDATER.compareAndSet(this, null, new FieldFilterTypeFlow((AnalysisField)this.source))) {
            this.filterFlow.addUse(bb, this);
        }
        return this.filterFlow;
    }

    @Override
    public String toString() {
        return "FieldFlow<" + ((AnalysisField)this.source).format("%h.%n") + System.lineSeparator() + this.getState() + ">";
    }
}

