/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import java.util.Objects;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.runtime.JVMCI;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalJVMCICompiler;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.runtime.RuntimeProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class GraalAccess {
    private static final GraalRuntime graalRuntime = ((GraalJVMCICompiler)JVMCI.getRuntime().getCompiler()).getGraalRuntime();
    private static final TargetDescription originalTarget;
    private static final Providers originalProviders;
    private static final SnippetReflectionProvider originalSnippetReflection;

    private GraalAccess() {
    }

    public static TargetDescription getOriginalTarget() {
        return originalTarget;
    }

    public static Providers getOriginalProviders() {
        return originalProviders;
    }

    public static SnippetReflectionProvider getOriginalSnippetReflection() {
        return originalSnippetReflection;
    }

    public static <T> T getGraalCapability(Class<T> clazz) {
        return (T)graalRuntime.getCapability(clazz);
    }

    static {
        Backend hostBackend = GraalAccess.getGraalCapability(RuntimeProvider.class).getHostBackend();
        originalTarget = Objects.requireNonNull(hostBackend.getTarget());
        originalProviders = Objects.requireNonNull(hostBackend.getProviders());
        originalSnippetReflection = Objects.requireNonNull(GraalAccess.getGraalCapability(SnippetReflectionProvider.class));
    }
}

