/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class ConcurrentLightHashSet {
    private ConcurrentLightHashSet() {
    }

    public static int size(Object elements) {
        if (elements == null) {
            return 0;
        }
        if (elements instanceof ConcurrentHashMap) {
            ConcurrentHashMap elementsMap = (ConcurrentHashMap)elements;
            return elementsMap.size();
        }
        return 1;
    }

    public static <T, U> boolean addElement(U holder, AtomicReferenceFieldUpdater<U, Object> updater, T newElement) {
        Object oldElements;
        block5: {
            assert (newElement != null);
            while (true) {
                if ((oldElements = updater.get(holder)) == null) {
                    if (!updater.compareAndSet(holder, oldElements, newElement)) continue;
                    return true;
                }
                if (oldElements instanceof ConcurrentHashMap) {
                    ConcurrentHashMap elementsMap = (ConcurrentHashMap)oldElements;
                    return elementsMap.putIfAbsent(newElement, Boolean.TRUE) == null;
                }
                if (oldElements == newElement) break block5;
                ConcurrentHashMap<Object, Boolean> newElements = new ConcurrentHashMap<Object, Boolean>();
                newElements.put(oldElements, Boolean.TRUE);
                newElements.put(newElement, Boolean.TRUE);
                if (updater.compareAndSet(holder, oldElements, newElements)) break;
            }
            return true;
        }
        assert (oldElements == newElement);
        return false;
    }

    public static <T, U> Collection<T> getElements(U holder, AtomicReferenceFieldUpdater<U, Object> updater) {
        Object u = updater.get(holder);
        if (u == null) {
            return Collections.emptySet();
        }
        if (u instanceof ConcurrentHashMap) {
            ConcurrentHashMap elementsMap = (ConcurrentHashMap)u;
            return elementsMap.keySet();
        }
        return Collections.singleton(u);
    }

    public static <T, U> void forEach(U holder, AtomicReferenceFieldUpdater<U, Object> updater, Consumer<? super T> action) {
        Object u = updater.get(holder);
        if (u == null) {
            return;
        }
        if (u instanceof ConcurrentHashMap) {
            ConcurrentHashMap elementsMap = (ConcurrentHashMap)u;
            ((ConcurrentHashMap.KeySetView)elementsMap.keySet()).forEach(action);
        } else {
            action.accept(u);
        }
    }

    public static <T, U> boolean removeElement(U holder, AtomicReferenceFieldUpdater<U, Object> updater, T element) {
        block3: {
            Object e;
            do {
                if ((e = updater.get(holder)) == null) {
                    return false;
                }
                if (e instanceof ConcurrentHashMap) {
                    ConcurrentHashMap elementsMap = (ConcurrentHashMap)e;
                    return elementsMap.remove(element) != null;
                }
                if (!element.equals(e)) break block3;
            } while (!updater.compareAndSet(holder, e, null));
            return true;
        }
        return false;
    }

    public static <T, U> boolean removeElementIf(U holder, AtomicReferenceFieldUpdater<U, Object> updater, Predicate<? super T> filter) {
        block3: {
            Object e;
            do {
                if ((e = updater.get(holder)) == null) {
                    return false;
                }
                if (e instanceof ConcurrentHashMap) {
                    ConcurrentHashMap elementsMap = (ConcurrentHashMap)e;
                    return elementsMap.keySet().removeIf(filter);
                }
                if (!filter.test(e)) break block3;
            } while (!updater.compareAndSet(holder, e, null));
            return true;
        }
        return false;
    }

    public static <U> void clear(U holder, AtomicReferenceFieldUpdater<U, Object> updater) {
        updater.set(holder, null);
    }
}

