/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import jdk.vm.ci.code.BytecodePosition;

public final class SourceTypeFlow
extends TypeFlow<BytecodePosition> {
    public SourceTypeFlow(BytecodePosition position, AnalysisType type, boolean canBeNull) {
        super(position, type, canBeNull);
    }

    public SourceTypeFlow(SourceTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows, original.getState().canBeNull() ? TypeState.forNull() : TypeState.forEmpty());
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new SourceTypeFlow(this, methodFlows);
    }

    @Override
    public void initFlow(PointsToAnalysis bb) {
        this.declaredType.registerInstantiatedCallback(a -> this.addState(bb, TypeState.forExactType(bb, this.declaredType, false)));
    }

    @Override
    public boolean needsInitialization() {
        return true;
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        AnalysisError.shouldNotReachHere("NewInstanceTypeFlow cannot saturate.");
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        AnalysisError.shouldNotReachHere("NewInstanceTypeFlow cannot saturate.");
    }

    @Override
    protected void onSaturated(PointsToAnalysis bb) {
        AnalysisError.shouldNotReachHere("NewInstanceTypeFlow cannot saturate.");
    }

    @Override
    public boolean canSaturate() {
        return false;
    }

    @Override
    public String toString() {
        return "SourceFlow<" + this.getState() + ">";
    }
}

