/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public class ConstantTypeFlow
extends TypeFlow<BytecodePosition> {
    private final TypeState constantState;

    public ConstantTypeFlow(BytecodePosition position, AnalysisType type, TypeState constantState) {
        super(position, type, TypeState.forEmpty());
        this.constantState = constantState;
        assert (this.source != null);
        assert (this.declaredType == null || this.declaredType.isInstantiated()) : "Type " + this.declaredType + " not instantiated " + position;
    }

    public ConstantTypeFlow(ConstantTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
        this.constantState = original.constantState;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new ConstantTypeFlow(this, methodFlows);
    }

    @Override
    public void initFlow(PointsToAnalysis bb) {
        this.addState(bb, this.constantState);
    }

    @Override
    public String toString() {
        return "ConstantFlow<" + this.getState() + ">";
    }
}

