/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Executable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

public interface OriginalMethodProvider {
    public static Executable getJavaMethod(SnippetReflectionProvider reflectionProvider, ResolvedJavaMethod method) {
        if (method instanceof OriginalMethodProvider) {
            return ((OriginalMethodProvider)method).getJavaMethod();
        }
        try {
            ResolvedJavaMethod.Parameter[] parameters = method.getParameters();
            Class[] parameterTypes = new Class[parameters.length];
            ResolvedJavaType declaringClassType = method.getDeclaringClass();
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypes[i] = OriginalClassProvider.getJavaClass(reflectionProvider, parameters[i].getType().resolve(declaringClassType));
            }
            Class<?> declaringClass = OriginalClassProvider.getJavaClass(reflectionProvider, declaringClassType);
            if (method.isConstructor()) {
                return declaringClass.getDeclaredConstructor(parameterTypes);
            }
            return declaringClass.getDeclaredMethod(method.getName(), parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw AnalysisError.shouldNotReachHere();
        }
    }

    public Executable getJavaMethod();
}

