/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.builder;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.graalvm.compiler.phases.common.LazyValue;

public final class TypeFlowBuilder<T extends TypeFlow<?>> {
    private final Object source;
    private final Class<T> flowClass;
    private final LazyValue<T> lazyTypeFlowCreator;
    private final Set<TypeFlowBuilder<?>> useDependencies;
    private final Set<TypeFlowBuilder<?>> observerDependencies;
    private boolean buildingAnActualParameter;
    private boolean buildingAnActualReceiver;
    private boolean isMaterialized;

    public static <U extends TypeFlow<?>> TypeFlowBuilder<U> create(PointsToAnalysis bb, Object source, Class<U> clazz, Supplier<U> supplier) {
        TypeFlowBuilder<U> builder = new TypeFlowBuilder<U>(source, clazz, new LazyValue(supplier));
        PointsToStats.registerTypeFlowBuilder(bb, builder);
        return builder;
    }

    private TypeFlowBuilder(Object source, Class<T> flowClass, LazyValue<T> creator) {
        this.flowClass = flowClass;
        this.source = source;
        this.lazyTypeFlowCreator = creator;
        this.useDependencies = new HashSet();
        this.observerDependencies = new HashSet();
        this.buildingAnActualParameter = false;
        this.buildingAnActualReceiver = false;
        this.isMaterialized = false;
    }

    public void markAsBuildingAnActualParameter() {
        this.buildingAnActualParameter = true;
    }

    public boolean isBuildingAnActualParameter() {
        return this.buildingAnActualParameter;
    }

    public void markAsBuildingAnActualReceiver() {
        this.buildingAnActualReceiver = true;
    }

    public boolean isBuildingAnActualReceiver() {
        return this.buildingAnActualReceiver;
    }

    public boolean isMaterialized() {
        return this.isMaterialized;
    }

    public Class<T> getFlowClass() {
        return this.flowClass;
    }

    public Object getSource() {
        return this.source;
    }

    public void addUseDependency(TypeFlowBuilder<?> dependency) {
        this.useDependencies.add(dependency);
    }

    Collection<TypeFlowBuilder<?>> getUseDependencies() {
        return this.useDependencies;
    }

    public void addObserverDependency(TypeFlowBuilder<?> dependency) {
        this.observerDependencies.add(dependency);
    }

    Collection<TypeFlowBuilder<?>> getObserverDependencies() {
        return this.observerDependencies;
    }

    public T get() {
        TypeFlow value = (TypeFlow)this.lazyTypeFlowCreator.get();
        this.isMaterialized = true;
        value.setUsedAsAParameter(this.buildingAnActualParameter);
        value.setUsedAsAReceiver(this.buildingAnActualReceiver);
        return (T)value;
    }
}

