/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractSpecialInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.free.DefaultAnalysisContextPolicy;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.typestore.ArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;
import com.oracle.graal.pointsto.typestore.UnifiedArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.UnifiedFieldTypeStore;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.options.OptionValues;

public class DefaultAnalysisPolicy
extends AnalysisPolicy {
    private DefaultAnalysisContextPolicy contextPolicy = new DefaultAnalysisContextPolicy();

    public DefaultAnalysisPolicy(OptionValues options) {
        super(options);
    }

    public DefaultAnalysisContextPolicy contextPolicy() {
        return this.contextPolicy;
    }

    @Override
    public boolean needsConstantCache() {
        return false;
    }

    @Override
    public boolean isSummaryObject(AnalysisObject object) {
        return object.isContextInsensitiveObject();
    }

    @Override
    public boolean isMergingEnabled() {
        return false;
    }

    @Override
    public void noteMerge(PointsToAnalysis bb, TypeState t) {
    }

    @Override
    public void noteMerge(PointsToAnalysis bb, AnalysisObject ... a) {
    }

    @Override
    public void noteMerge(PointsToAnalysis bb, AnalysisObject a) {
    }

    @Override
    public boolean isContextSensitiveAllocation(PointsToAnalysis bb, AnalysisType type, AnalysisContext allocationContext) {
        return false;
    }

    @Override
    public AnalysisObject createHeapObject(PointsToAnalysis bb, AnalysisType type, BytecodeLocation allocationSite, AnalysisContext allocationContext) {
        return type.getContextInsensitiveAnalysisObject();
    }

    @Override
    public AnalysisObject createConstantObject(PointsToAnalysis bb, JavaConstant constant, AnalysisType exactType) {
        return exactType.getContextInsensitiveAnalysisObject();
    }

    @Override
    public BytecodeLocation createAllocationSite(PointsToAnalysis bb, int bci, AnalysisMethod method) {
        return BytecodeLocation.create(bci, method);
    }

    @Override
    public FieldTypeStore createFieldTypeStore(AnalysisObject object, AnalysisField field, AnalysisUniverse universe) {
        return new UnifiedFieldTypeStore(field, object);
    }

    @Override
    public ArrayElementsTypeStore createArrayElementsTypeStore(AnalysisObject object, AnalysisUniverse universe) {
        if (object.type().isArray()) {
            if (this.aliasArrayTypeFlows) {
                if (object.type().getComponentType().isJavaLangObject()) {
                    return new UnifiedArrayElementsTypeStore(object);
                }
                return universe.objectType().getArrayClass().getContextInsensitiveAnalysisObject().getArrayElementsTypeStore();
            }
            return new UnifiedArrayElementsTypeStore(object);
        }
        return null;
    }

    @Override
    public AbstractVirtualInvokeTypeFlow createVirtualInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, AnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        return new DefaultVirtualInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
    }

    @Override
    public AbstractSpecialInvokeTypeFlow createSpecialInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, AnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        return new DefaultSpecialInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
    }

    private static final class DefaultSpecialInvokeTypeFlow
    extends AbstractSpecialInvokeTypeFlow {
        MethodFlowsGraph calleeFlows = null;

        DefaultSpecialInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, AnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
            super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
        }

        private DefaultSpecialInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, DefaultSpecialInvokeTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new DefaultSpecialInvokeTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            assert (this.isClone());
            this.initCallee();
            if (this.calleeFlows == null) {
                this.calleeFlows = this.callee.addContext(bb, bb.contextPolicy().emptyContext(), this);
                this.linkCallee(bb, false, this.calleeFlows);
            }
            TypeState invokeState = this.filterReceiverState(bb, this.getReceiver().getState());
            this.updateReceiver(bb, this.calleeFlows, invokeState);
        }

        @Override
        public Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis bb) {
            if (this.callee == null) {
                return Collections.emptyList();
            }
            MethodFlowsGraph methodFlows = this.callee.getFlows(bb.contextPolicy().emptyContext());
            return Collections.singletonList(methodFlows);
        }
    }

    private static class DefaultVirtualInvokeTypeFlow
    extends AbstractVirtualInvokeTypeFlow {
        private TypeState seenReceiverTypes = TypeState.forEmpty();

        protected DefaultVirtualInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, AnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
            super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
        }

        protected DefaultVirtualInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, DefaultVirtualInvokeTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new DefaultVirtualInvokeTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            assert (this.isClone() || this.isContextInsensitive());
            if (this.isSaturated()) {
                return;
            }
            TypeState receiverState = this.getReceiver().getState();
            if (!this.isContextInsensitive()) {
                receiverState = this.filterReceiverState(bb, receiverState);
            }
            for (AnalysisType type : receiverState.types()) {
                AnalysisMethod method;
                if (this.isSaturated()) {
                    return;
                }
                if (this.seenReceiverTypes.containsType(type) || (method = type.resolveConcreteMethod(this.getTargetMethod())) == null || Modifier.isAbstract(method.getModifiers())) continue;
                assert (!Modifier.isAbstract(method.getModifiers()));
                MethodTypeFlow callee = method.getTypeFlow();
                MethodFlowsGraph calleeFlows = callee.addContext(bb, bb.contextPolicy().emptyContext(), this);
                assert (callee.getContexts()[0] == bb.contextPolicy().emptyContext());
                if (this.addCallee(callee.getMethod())) {
                    this.linkCallee(bb, false, calleeFlows);
                }
                this.updateReceiver(bb, calleeFlows, TypeState.forExactType(bb, type, false));
            }
            this.seenReceiverTypes = receiverState;
        }

        @Override
        public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
            assert (this.isClone() && !this.isContextInsensitive());
            this.setSaturated();
            this.getReceiver().removeObserver(this);
            for (AnalysisMethod callee : super.getCallees()) {
                MethodFlowsGraph calleeFlows = callee.getTypeFlow().getFlows(bb.contextPolicy().emptyContext());
                for (int i = 0; i < this.actualParameters.length; ++i) {
                    FormalParamTypeFlow formalParam = calleeFlows.getParameter(i);
                    if (this.actualParameters[i] == null || formalParam == null) continue;
                    this.actualParameters[i].removeUse(formalParam);
                }
                if (this.actualReturn == null || calleeFlows.getResult() == null) continue;
                calleeFlows.getResult().removeUse(this.actualReturn);
            }
            AbstractVirtualInvokeTypeFlow contextInsensitiveInvoke = (AbstractVirtualInvokeTypeFlow)this.targetMethod.initAndGetContextInsensitiveInvoke(bb, (BytecodePosition)this.source);
            contextInsensitiveInvoke.addInvokeLocation((BytecodePosition)this.getSource());
            for (int i = 1; i < this.actualParameters.length; ++i) {
                if (this.actualParameters[i] == null) continue;
                this.actualParameters[i].addUse(bb, contextInsensitiveInvoke.getActualParameter(i));
            }
            if (this.actualReturn != null) {
                contextInsensitiveInvoke.getActualReturn().addUse(bb, this.actualReturn);
            }
        }

        @Override
        public void setSaturated() {
            super.setSaturated();
            if (this.isClone()) {
                this.originalInvoke.setSaturated();
            }
        }

        @Override
        public final Collection<AnalysisMethod> getCallees() {
            if (this.isSaturated()) {
                return this.targetMethod.getContextInsensitiveInvoke().getCallees();
            }
            return super.getCallees();
        }

        @Override
        public Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis bb) {
            Collection<AnalysisMethod> calleesList = this.getCallees();
            ArrayList<MethodFlowsGraph> methodFlowsGraphs = new ArrayList<MethodFlowsGraph>(calleesList.size());
            for (AnalysisMethod method : calleesList) {
                methodFlowsGraphs.add(method.getTypeFlow().getFlows(bb.contextPolicy().emptyContext()));
            }
            return methodFlowsGraphs;
        }
    }
}

