/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.ValueNode;

public class CloneTypeFlow
extends TypeFlow<BytecodePosition> {
    private BytecodeLocation cloneSite;
    private TypeFlow<?> input;
    protected final AnalysisContext allocationContext;

    public CloneTypeFlow(ValueNode node, AnalysisType inputType, BytecodeLocation cloneLabel, TypeFlow<?> input) {
        super(node.getNodeSourcePosition(), inputType);
        this.cloneSite = cloneLabel;
        this.allocationContext = null;
        this.input = input;
    }

    public CloneTypeFlow(BigBang bb, CloneTypeFlow original, MethodFlowsGraph methodFlows, AnalysisContext allocationContext) {
        super(original, methodFlows);
        this.cloneSite = original.cloneSite;
        this.allocationContext = allocationContext;
        this.input = methodFlows.lookupCloneOf(bb, original.input);
    }

    @Override
    public TypeFlow<BytecodePosition> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        AnalysisContext enclosingContext = methodFlows.context();
        AnalysisContext allocContext = bb.contextPolicy().allocationContext(enclosingContext, (Integer)PointstoOptions.MaxHeapContextDepth.getValue(bb.getOptions()));
        return new CloneTypeFlow(bb, this, methodFlows, allocContext);
    }

    @Override
    public void onObservedUpdate(BigBang bb) {
        TypeState resultState;
        assert (this.isClone() && this.context != null);
        TypeState inputState = this.input.getState();
        TypeState currentState = this.getState();
        if (inputState.isEmpty() || inputState.isNull()) {
            resultState = inputState.forNonNull(bb);
        } else {
            resultState = inputState.typesStream().filter(t -> !currentState.containsType((AnalysisType)t)).map(type -> TypeState.forClone(bb, this.cloneSite, type, this.allocationContext)).reduce(TypeState.forEmpty(), (s1, s2) -> TypeState.forUnion(bb, s1, s2));
            assert (!resultState.canBeNull());
        }
        this.addState(bb, resultState);
    }

    @Override
    public void update(BigBang bb) {
        assert (this.isClone());
        TypeState inputState = this.input.getState();
        TypeState cloneState = this.getState();
        for (AnalysisType type : inputState.types()) {
            if (type.isArray()) {
                if (bb.analysisPolicy().aliasArrayTypeFlows()) continue;
                for (AnalysisObject originalObject : inputState.objects(type)) {
                    if (originalObject.isPrimitiveArray() || originalObject.isEmptyObjectArrayConstant(bb)) continue;
                    ArrayElementsTypeFlow originalObjectElementsFlow = originalObject.getArrayElementsFlow(bb, false);
                    for (AnalysisObject cloneObject : cloneState.objects(type)) {
                        if (cloneObject.isPrimitiveArray() || cloneObject.isEmptyObjectArrayConstant(bb)) continue;
                        ArrayElementsTypeFlow cloneObjectElementsFlow = cloneObject.getArrayElementsFlow(bb, true);
                        originalObjectElementsFlow.addUse(bb, cloneObjectElementsFlow);
                    }
                }
                continue;
            }
            for (AnalysisObject originalObject : inputState.objects(type)) {
                for (AnalysisField field : type.getInstanceFields(true)) {
                    FieldTypeFlow originalObjectFieldFlow = originalObject.getInstanceFieldFlow(bb, this.method(), field, false);
                    for (AnalysisObject cloneObject : cloneState.objects(type)) {
                        FieldTypeFlow cloneObjectFieldFlow = cloneObject.getInstanceFieldFlow(bb, this.method(), field, true);
                        originalObjectFieldFlow.addUse(bb, cloneObjectFieldFlow);
                    }
                }
            }
        }
        super.update(bb);
    }

    @Override
    public void onObservedSaturated(BigBang bb, TypeFlow<?> observed) {
        assert (this.isClone());
        this.replaceObservedWith(bb, this.declaredType);
    }

    @Override
    public void setObserved(TypeFlow<?> newInputFlow) {
        this.input = newInputFlow;
    }

    public BytecodeLocation getCloneSite() {
        return this.cloneSite;
    }

    @Override
    public String toString() {
        return "Clone<" + super.toString() + ">";
    }
}

