/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.nodes;

import com.oracle.graal.pointsto.api.UnsafePartitionKind;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_IGNORED, cycles=NodeCycles.CYCLES_IGNORED)
public class AnalysisUnsafePartitionLoadNode
extends FixedWithNextNode {
    public static final NodeClass<AnalysisUnsafePartitionLoadNode> TYPE = NodeClass.create(AnalysisUnsafePartitionLoadNode.class);
    @Node.Input
    ValueNode object;
    @Node.Input
    ValueNode offset;
    protected final JavaKind accessKind;
    protected final LocationIdentity locationIdentity;
    protected final UnsafePartitionKind partitionKind;
    protected final ResolvedJavaType partitionType;

    public AnalysisUnsafePartitionLoadNode(ValueNode object, ValueNode offset, JavaKind accessKind, LocationIdentity locationIdentity, UnsafePartitionKind partitionKind, ResolvedJavaType partitionType) {
        super(TYPE, StampFactory.forKind((JavaKind)accessKind.getStackKind()));
        this.object = object;
        this.offset = offset;
        this.accessKind = accessKind;
        this.locationIdentity = locationIdentity;
        this.partitionKind = partitionKind;
        this.partitionType = partitionType;
    }

    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    public ValueNode object() {
        return this.object;
    }

    public ValueNode offset() {
        return this.offset;
    }

    public JavaKind accessKind() {
        return this.accessKind;
    }

    public UnsafePartitionKind unsafePartitionKind() {
        return this.partitionKind;
    }

    public ResolvedJavaType partitionType() {
        return this.partitionType;
    }
}

