/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.EmptyTypeState;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import org.graalvm.compiler.options.OptionValues;

public class SingleTypeState
extends TypeState {
    protected final BigBang bigbang;
    protected final AnalysisObject[] objects;
    protected final boolean canBeNull;
    private boolean merged;

    public SingleTypeState(BigBang bb, boolean canBeNull, int properties, ArrayList<AnalysisObject> objects) {
        this(bb, canBeNull, properties, objects.toArray(new AnalysisObject[objects.size()]));
    }

    public SingleTypeState(BigBang bb, boolean canBeNull, int properties, AnalysisObject ... objects) {
        super(properties);
        this.bigbang = bb;
        this.objects = objects;
        this.canBeNull = canBeNull;
        this.merged = false;
        assert (objects.length > 0) : "Single type state with no objects.";
        assert (!((Boolean)PointstoOptions.ExtendedAsserts.getValue(bb.getOptions())).booleanValue() || this.checkObjects(bb.getOptions()));
        PointsToStats.registerTypeState(bb, this);
    }

    protected SingleTypeState(BigBang bb, boolean canBeNull, SingleTypeState other) {
        super(other.properties);
        this.bigbang = bb;
        this.objects = other.objects;
        this.canBeNull = canBeNull;
        this.merged = other.merged;
        PointsToStats.registerTypeState(bb, this);
    }

    protected boolean checkObjects(OptionValues options) {
        assert (((Boolean)PointstoOptions.ExtendedAsserts.getValue(options)).booleanValue());
        for (int idx = 0; idx < this.objects.length - 1; ++idx) {
            AnalysisObject o0 = this.objects[idx];
            AnalysisObject o1 = this.objects[idx + 1];
            assert (o0 != null && o1 != null) : "Object state must contain non null elements.";
            assert (o0.type().equals(o1.type())) : "Single type state objects must have the same type.";
            assert (o0.getId() < o1.getId()) : "Analysis objects must be sorted by ID.";
        }
        return true;
    }

    @Override
    public int typesCount() {
        return 1;
    }

    @Override
    public boolean hasExactTypes(BitSet inputTypesBitSet) {
        return inputTypesBitSet.cardinality() == 1 && inputTypesBitSet.get(this.exactType().getId());
    }

    @Override
    public AnalysisType exactType() {
        return this.objects[0].type();
    }

    @Override
    protected Iterator<AnalysisType> typesIterator() {
        return new Iterator<AnalysisType>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public AnalysisType next() {
                this.hasNext = false;
                return SingleTypeState.this.exactType();
            }
        };
    }

    @Override
    public boolean containsType(AnalysisType exactType) {
        return this.exactType().equals(exactType);
    }

    @Override
    public final int objectsCount() {
        return this.objects.length;
    }

    @Override
    public final AnalysisObject[] objects() {
        return this.objects;
    }

    @Override
    public AnalysisObject[] objectsArray(AnalysisType type) {
        return this.exactType().equals(type) ? this.objects : null;
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(final AnalysisType type) {
        return new Iterator<AnalysisObject>(){
            private boolean typesEqual;
            private int idx;
            {
                this.typesEqual = SingleTypeState.this.exactType().equals(type);
                this.idx = 0;
            }

            @Override
            public boolean hasNext() {
                return this.typesEqual && this.idx < SingleTypeState.this.objects.length;
            }

            @Override
            public AnalysisObject next() {
                return SingleTypeState.this.objects[this.idx++];
            }
        };
    }

    @Override
    public final boolean canBeNull() {
        return this.canBeNull;
    }

    @Override
    public TypeState exactTypeState(BigBang bb, AnalysisType exactType) {
        if (this.containsType(exactType)) {
            return this;
        }
        return EmptyTypeState.SINGLETON;
    }

    @Override
    protected TypeState forCanBeNull(BigBang bb, boolean stateCanBeNull) {
        if (stateCanBeNull == this.canBeNull()) {
            return this;
        }
        return new SingleTypeState(bb, stateCanBeNull, this);
    }

    @Override
    public void noteMerge(BigBang bb) {
        assert (bb.analysisPolicy().isMergingEnabled());
        if (!this.merged) {
            for (AnalysisObject obj : this.objects) {
                obj.noteMerge(bb);
            }
            this.merged = true;
        }
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.objects);
        result = 31 * result + (this.canBeNull ? 1 : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleTypeState that = (SingleTypeState)o;
        return this.canBeNull == that.canBeNull && this.exactType().equals(that.exactType()) && Arrays.equals(this.objects, that.objects);
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append("1TypeMObject<").append(this.canBeNull ? "null," : "").append(Arrays.toString(this.objects)).append(">");
        return strb.toString();
    }
}

