/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.constraints;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedList;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;

public final class ShortestInvokeChainPrinter {
    public static void print(BigBang bb, AnalysisMethod target) {
        ShortestInvokeChainPrinter.print(bb, target, System.out);
    }

    public static void print(BigBang bb, AnalysisMethod target, PrintStream out) {
        LinkedList<AnalysisMethod> workList = new LinkedList<AnalysisMethod>();
        HashMap<AnalysisMethod, Element> visited = new HashMap<AnalysisMethod, Element>();
        for (AnalysisMethod m : bb.getUniverse().getMethods()) {
            if (!m.isEntryPoint()) continue;
            workList.addLast(m);
            visited.put(m, new Element(m, null, null));
        }
        while (workList.size() > 0) {
            AnalysisMethod method = (AnalysisMethod)workList.removeFirst();
            Element methodElement = (Element)visited.get(method);
            assert (methodElement != null);
            for (InvokeTypeFlow invoke : method.getTypeFlow().getInvokes()) {
                for (AnalysisMethod callee : invoke.getCallees()) {
                    if (visited.containsKey(callee)) continue;
                    Element calleeElement = new Element(callee, methodElement, invoke);
                    visited.put(callee, calleeElement);
                    if (callee.equals(target)) {
                        ShortestInvokeChainPrinter.printPath(calleeElement, out);
                        return;
                    }
                    workList.addLast(callee);
                }
            }
        }
        ShortestInvokeChainPrinter.printNoPath(out);
    }

    private static void printPath(Element start, PrintStream out) {
        Element cur = start;
        out.print("\tat " + cur.method.asStackTraceElement(0));
        while (cur.parent != null) {
            out.print("\n\tat " + cur.parent.method.asStackTraceElement(((MethodCallTargetNode)cur.invoke.getSource()).invoke().bci()));
            cur = cur.parent;
        }
    }

    private static void printNoPath(PrintStream out) {
        out.println("\tno path found from entry point to target method");
    }

    static class Element {
        protected final Element parent;
        protected final AnalysisMethod method;
        protected final InvokeTypeFlow invoke;

        protected Element(AnalysisMethod method, Element parent, InvokeTypeFlow invoke) {
            this.parent = parent;
            this.method = method;
            this.invoke = invoke;
        }
    }
}

