/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.DirEntry;

public class FileEntry {
    private final String fileName;
    private final DirEntry dirEntry;
    private final int idx;

    public FileEntry(String fileName, DirEntry dirEntry, int idx) {
        this.fileName = fileName;
        this.dirEntry = dirEntry;
        this.idx = idx;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getIdx() {
        return this.idx;
    }

    public String getPathName() {
        DirEntry dirEntry = this.getDirEntry();
        if (dirEntry == null) {
            return "";
        }
        return dirEntry.getPathString();
    }

    public String getFullName() {
        if (this.dirEntry == null) {
            return this.fileName;
        }
        return this.dirEntry.getPath().resolve(this.getFileName()).toString();
    }

    public DirEntry getDirEntry() {
        return this.dirEntry;
    }

    public String toString() {
        if (this.getDirEntry() == null) {
            return this.getFileName() == null ? "-" : this.getFileName();
        }
        if (this.getFileName() == null) {
            return "--";
        }
        return String.format("FileEntry(%s)", this.getFullName());
    }
}

