/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.StringTable;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Range {
    private static final String CLASS_DELIMITER = ".";
    private final MethodEntry methodEntry;
    private final String fullMethodName;
    private final String fullMethodNameWithParams;
    private final int lo;
    private int hi;
    private final int line;
    private final int depth;
    private final Range primary;
    private Range caller;
    private Range firstCallee;
    private Range lastCallee;
    private Range siblingCallee;
    private DebugInfoProvider.DebugLocalValueInfo[] localValueInfos;
    private DebugInfoProvider.DebugLocalInfo[] localInfos;

    public int getLocalValueCount() {
        assert (!this.isPrimary()) : "primary range does not have local values";
        return this.localValueInfos.length;
    }

    public DebugInfoProvider.DebugLocalValueInfo getLocalValue(int i) {
        assert (!this.isPrimary()) : "primary range does not have local values";
        assert (i >= 0 && i < this.localValueInfos.length) : "bad index";
        return this.localValueInfos[i];
    }

    public DebugInfoProvider.DebugLocalInfo getLocal(int i) {
        assert (!this.isPrimary()) : "primary range does not have local vars";
        assert (i >= 0 && i < this.localInfos.length) : "bad index";
        return this.localInfos[i];
    }

    public Range(StringTable stringTable, MethodEntry methodEntry, int lo, int hi, int line) {
        this(stringTable, methodEntry, lo, hi, line, null, false, null);
    }

    public Range(StringTable stringTable, MethodEntry methodEntry, int lo, int hi, int line, Range primary, boolean isTopLevel, Range caller) {
        assert (methodEntry != null);
        if (methodEntry.fileEntry != null) {
            stringTable.uniqueDebugString(methodEntry.fileEntry.getFileName());
            stringTable.uniqueDebugString(methodEntry.fileEntry.getPathName());
        }
        this.methodEntry = methodEntry;
        this.fullMethodName = isTopLevel ? stringTable.uniqueDebugString(this.constructClassAndMethodName()) : stringTable.uniqueString(this.constructClassAndMethodName());
        this.fullMethodNameWithParams = this.constructClassAndMethodNameWithParams();
        this.lo = lo;
        this.hi = hi;
        this.line = line;
        this.primary = primary;
        this.firstCallee = null;
        this.lastCallee = null;
        this.siblingCallee = null;
        this.caller = caller;
        if (caller != null) {
            caller.addCallee(this);
        }
        this.depth = this.isPrimary() ? -1 : caller.depth + 1;
    }

    private void addCallee(Range callee) {
        assert (this.lo <= callee.lo);
        assert (this.hi >= callee.hi);
        assert (callee.caller == this);
        assert (callee.siblingCallee == null);
        if (this.firstCallee == null) {
            assert (this.lastCallee == null);
            this.firstCallee = this.lastCallee = callee;
        } else {
            this.lastCallee.siblingCallee = callee;
            this.lastCallee = callee;
        }
    }

    public boolean contains(Range other) {
        return this.lo <= other.lo && this.hi >= other.hi;
    }

    public boolean isPrimary() {
        return this.getPrimary() == null;
    }

    public Range getPrimary() {
        return this.primary;
    }

    public String getClassName() {
        return this.methodEntry.ownerType.typeName;
    }

    public String getMethodName() {
        return this.methodEntry.memberName;
    }

    public String getSymbolName() {
        return this.methodEntry.getSymbolName();
    }

    public int getHi() {
        return this.hi;
    }

    public int getLo() {
        return this.lo;
    }

    public int getLine() {
        return this.line;
    }

    public String getFullMethodName() {
        return this.fullMethodName;
    }

    public String getFullMethodNameWithParams() {
        return this.fullMethodNameWithParams;
    }

    public boolean isDeoptTarget() {
        return this.methodEntry.isDeopt();
    }

    private String getExtendedMethodName(boolean includeClass, boolean includeParams, boolean includeReturnType) {
        StringBuilder builder = new StringBuilder();
        if (includeReturnType && this.methodEntry.valueType.typeName.length() > 0) {
            builder.append(this.methodEntry.valueType.typeName);
            builder.append(' ');
        }
        if (includeClass && this.getClassName() != null) {
            builder.append(this.getClassName());
            builder.append(CLASS_DELIMITER);
        }
        builder.append(this.getMethodName());
        if (includeParams) {
            builder.append("(");
            TypeEntry[] paramTypes = this.methodEntry.getParamTypes();
            if (paramTypes != null) {
                String prefix = "";
                for (TypeEntry t : paramTypes) {
                    builder.append(prefix);
                    builder.append(t.getTypeName());
                    prefix = ", ";
                }
            }
            builder.append(')');
        }
        if (includeReturnType) {
            builder.append(" ");
            builder.append(this.methodEntry.valueType.typeName);
        }
        return builder.toString();
    }

    private String constructClassAndMethodName() {
        return this.getExtendedMethodName(true, false, false);
    }

    private String constructClassAndMethodNameWithParams() {
        return this.getExtendedMethodName(true, true, false);
    }

    public FileEntry getFileEntry() {
        return this.methodEntry.fileEntry;
    }

    public int getFileIndex() {
        Range primaryRange = this.isPrimary() ? this : this.getPrimary();
        ClassEntry owner = primaryRange.methodEntry.ownerType();
        return owner.localFilesIdx(this.getFileEntry());
    }

    public int getModifiers() {
        return this.methodEntry.modifiers;
    }

    public String toString() {
        return String.format("Range(lo=0x%05x hi=0x%05x %s %s:%d)", this.lo, this.hi, this.constructClassAndMethodNameWithParams(), this.methodEntry.getFullFileName(), this.line);
    }

    public String getFileName() {
        return this.methodEntry.getFileName();
    }

    public MethodEntry getMethodEntry() {
        return this.methodEntry;
    }

    public Range getCaller() {
        return this.caller;
    }

    public Range getFirstCallee() {
        return this.firstCallee;
    }

    public Range getSiblingCallee() {
        return this.siblingCallee;
    }

    public boolean isLeaf() {
        return this.firstCallee == null;
    }

    public boolean includesInlineRanges() {
        Range child = this.firstCallee;
        while (child != null && child.isLeaf()) {
            child = child.siblingCallee;
        }
        return child != null;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setLocalValueInfo(DebugInfoProvider.DebugLocalValueInfo[] localValueInfos) {
        int len = localValueInfos.length;
        this.localValueInfos = localValueInfos;
        this.localInfos = new DebugInfoProvider.DebugLocalInfo[len];
        for (int i = 0; i < len; ++i) {
            this.localInfos[i] = this.methodEntry.recordLocal(localValueInfos[i]);
        }
    }

    public HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>> getVarRangeMap() {
        int i;
        MethodEntry calleeMethod;
        if (this.isPrimary()) {
            calleeMethod = this.getMethodEntry();
        } else {
            assert (!this.isLeaf()) : "should only be looking up var ranges for inlined calls";
            calleeMethod = this.firstCallee.getMethodEntry();
        }
        HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>> varRangeMap = new HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>>();
        if (calleeMethod.getThisParam() != null) {
            varRangeMap.put(calleeMethod.getThisParam(), new ArrayList());
        }
        for (i = 0; i < calleeMethod.getParamCount(); ++i) {
            varRangeMap.put(calleeMethod.getParam(i), new ArrayList());
        }
        for (i = 0; i < calleeMethod.getLocalCount(); ++i) {
            varRangeMap.put(calleeMethod.getLocal(i), new ArrayList());
        }
        return this.updateVarRangeMap(varRangeMap);
    }

    public HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>> updateVarRangeMap(HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>> varRangeMap) {
        Range subRange = this.firstCallee;
        while (subRange != null) {
            this.addVarRanges(subRange, varRangeMap);
            subRange = subRange.siblingCallee;
        }
        return varRangeMap;
    }

    public void addVarRanges(Range subRange, HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>> varRangeMap) {
        int localValueCount = subRange.getLocalValueCount();
        block3: for (int i = 0; i < localValueCount; ++i) {
            DebugInfoProvider.DebugLocalValueInfo localValueInfo = subRange.getLocalValue(i);
            DebugInfoProvider.DebugLocalInfo local = subRange.getLocal(i);
            if (local == null) continue;
            switch (localValueInfo.localKind()) {
                case REGISTER: 
                case STACKSLOT: 
                case CONSTANT: {
                    List<Range> varRanges = varRangeMap.get(local);
                    assert (varRanges != null) : "local not present in var to ranges map!";
                    varRanges.add(subRange);
                    continue block3;
                }
            }
        }
    }

    public DebugInfoProvider.DebugLocalValueInfo lookupValue(DebugInfoProvider.DebugLocalInfo local) {
        int localValueCount = this.getLocalValueCount();
        for (int i = 0; i < localValueCount; ++i) {
            if (this.getLocal(i) != local) continue;
            return this.getLocalValue(i);
        }
        return null;
    }
}

