/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVUtil;
import org.graalvm.compiler.debug.DebugContext;

abstract class CVSymbolRecord {
    private static final int SYMBOL_RECORD_HEADER_SIZE = 8;
    protected final CVDebugInfo cvDebugInfo;
    protected final int type;
    protected int recordStartPosition;

    CVSymbolRecord(CVDebugInfo cvDebugInfo, int type) {
        this.cvDebugInfo = cvDebugInfo;
        this.type = type;
    }

    final int computeFullSize(int initialPos) {
        this.recordStartPosition = initialPos;
        int pos = initialPos + 8;
        return this.computeSize(pos);
    }

    final int computeFullContents(byte[] buffer, int initialPos) {
        int pos;
        int lenPos = pos = CVUtil.putInt(this.type, buffer, initialPos);
        pos = this.computeContents(buffer, initialPos + 8);
        CVUtil.putInt(pos - initialPos - 8, buffer, lenPos);
        return pos;
    }

    public int getPos() {
        return this.recordStartPosition;
    }

    public int getCommand() {
        return this.type;
    }

    protected abstract int computeSize(int var1);

    protected abstract int computeContents(byte[] var1, int var2);

    public String toString() {
        return "CVSymbolRecord(type=" + this.type + ",pos=" + this.recordStartPosition + ")";
    }

    public void logContents(DebugContext debugContext) {
    }
}

