/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.pecoff.PECoffMachine;
import com.oracle.objectfile.pecoff.PECoffObjectFile;
import com.oracle.objectfile.pecoff.PECoffRelocationTable;
import com.oracle.objectfile.pecoff.PECoffSymtab;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Map;

public class PECoffUserDefinedSection
extends PECoffObjectFile.PECoffSection
implements ObjectFile.RelocatableSectionImpl {
    private PECoffRelocationTable rel;
    private PECoffRelocationTable rela;
    protected ElementImpl impl;

    @Override
    public ElementImpl getImpl() {
        return this.impl;
    }

    PECoffUserDefinedSection(PECoffObjectFile owner, String name, int alignment, ElementImpl impl) {
        this(owner, name, alignment, impl, EnumSet.noneOf(PECoffObjectFile.PECoffSectionFlag.class));
    }

    PECoffUserDefinedSection(PECoffObjectFile owner, String name, int alignment, ElementImpl impl, EnumSet<PECoffObjectFile.PECoffSectionFlag> flags) {
        this(owner, name, alignment, impl, flags, -1);
    }

    PECoffUserDefinedSection(PECoffObjectFile owner, String name, int alignment, ElementImpl impl, EnumSet<PECoffObjectFile.PECoffSectionFlag> flags, int sectionIndex) {
        PECoffObjectFile pECoffObjectFile = owner;
        pECoffObjectFile.getClass();
        super(name, alignment, flags, sectionIndex);
        this.impl = impl;
    }

    public void setImpl(ElementImpl impl) {
        assert (impl == null);
        this.impl = impl;
        if (impl.isLoadable()) {
            this.flags.add(PECoffObjectFile.PECoffSectionFlag.READ);
        } else {
            this.flags.remove(PECoffObjectFile.PECoffSectionFlag.READ);
        }
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        return this.impl.getDependencies(decisions);
    }

    @Override
    public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
        return this.impl.getOrDecideOffset(alreadyDecided, offsetHint);
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return this.impl.getOrDecideSize(alreadyDecided, sizeHint);
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        return this.impl.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
        return this.impl.getOrDecideVaddr(alreadyDecided, vaddrHint);
    }

    @Override
    public int getMemSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
        return this.impl.getMemSize(alreadyDecided);
    }

    @Override
    public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
        return this.impl.getDecisions(copyingIn);
    }

    @Override
    public ObjectFile.Element getOrCreateRelocationElement(boolean useImplicitAddend) {
        PECoffRelocationTable rs;
        PECoffSymtab syms = (PECoffSymtab)this.getOwner().elementForName(".symtab");
        if (syms == null) {
            throw new IllegalStateException("cannot create a relocation section without corresponding symtab");
        }
        boolean withExplicitAddends = !useImplicitAddend;
        PECoffRelocationTable pECoffRelocationTable = rs = withExplicitAddends ? this.rela : this.rel;
        if (rs == null) {
            rs = this.getOwner().getOrCreateRelocSection(syms, withExplicitAddends);
            assert (rs != null);
            if (withExplicitAddends) {
                this.rela = rs;
            } else {
                this.rel = rs;
            }
        }
        return rs;
    }

    @Override
    public void markRelocationSite(int offset, ByteBuffer bb, ObjectFile.RelocationKind k, String symbolName, boolean useImplicitAddend, Long explicitAddend) {
        long desiredInlineAddendValue;
        if (useImplicitAddend != (explicitAddend == null)) {
            throw new IllegalArgumentException("must have either an explicit or implicit addend");
        }
        PECoffSymtab syms = (PECoffSymtab)this.getOwner().elementForName(".symtab");
        PECoffRelocationTable rs = (PECoffRelocationTable)this.getOrCreateRelocationElement(useImplicitAddend);
        assert (symbolName != null);
        PECoffSymtab.Entry ent = syms.getSymbol(symbolName);
        if (ent == null) {
            PECoffUserDefinedSection.warn("attempting to mark relocation site for non-existent symbol " + symbolName);
            return;
        }
        AssemblyBuffer sbb = new AssemblyBuffer(bb);
        sbb.setByteOrder(this.getOwner().getByteOrder());
        sbb.pushSeek(offset);
        int length = ObjectFile.RelocationKind.getRelocationSize(k);
        long currentInlineAddendValue = sbb.readTruncatedLong(length);
        if (explicitAddend != null) {
            assert (currentInlineAddendValue == 0L);
            desiredInlineAddendValue = explicitAddend;
        } else {
            desiredInlineAddendValue = currentInlineAddendValue;
        }
        if (ObjectFile.RelocationKind.isPCRelative(k)) {
            desiredInlineAddendValue += (long)length;
        }
        sbb.seek(offset);
        sbb.writeTruncatedLong(desiredInlineAddendValue, length);
        sbb.pop();
        rs.addEntry(this, offset, PECoffMachine.getRelocation(this.getOwner().getMachine(), k), ent, explicitAddend);
    }

    private static void warn(String msg) {
        System.err.println("Warning: " + msg);
    }
}

