/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.PrimaryEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVLineRecord;
import org.graalvm.compiler.debug.DebugContext;

public class CVLineRecordBuilder {
    private CVDebugInfo cvDebugInfo;
    private DebugContext debugContext;
    private CVLineRecord lineRecord;
    private PrimaryEntry primaryEntry;

    CVLineRecordBuilder(DebugContext theDebugContext, CVDebugInfo cvDebugInfo) {
        this.debugContext = theDebugContext;
        this.cvDebugInfo = cvDebugInfo;
    }

    public void debug(String format, Object ... args) {
        this.cvDebugInfo.getCVSymbolSection().verboseLog(this.debugContext, format, args);
    }

    CVLineRecord build(PrimaryEntry entry) {
        this.primaryEntry = entry;
        Range primaryRange = this.primaryEntry.getPrimary();
        this.debug("DEBUG_S_LINES linerecord for 0x%05x file: %s:%d\n", primaryRange.getLo(), primaryRange.getFileName(), primaryRange.getLine());
        this.lineRecord = new CVLineRecord(this.cvDebugInfo, primaryRange.getSymbolName());
        this.debug("CVLineRecord.computeContents: processing primary range %s\n", primaryRange);
        this.processRange(primaryRange);
        for (Range subRange : this.primaryEntry.getSubranges()) {
            this.debug("CVLineRecord.computeContents: processing range %s\n", subRange);
            this.processRange(subRange);
        }
        return this.lineRecord;
    }

    private void processRange(Range range) {
        FileEntry file = this.cvDebugInfo.findFile(range.getFileAsPath());
        if (file == null) {
            this.debug("processRange: range has no file: %s\n", range);
            return;
        }
        if (range.getLine() == -1) {
            this.debug("processRange: ignoring: bad line number\n", new Object[0]);
            return;
        }
        int fileId = this.cvDebugInfo.getCVSymbolSection().getFileTableRecord().addFile(file);
        if (this.lineRecord.isEmpty() || this.lineRecord.getCurrentFileId() != fileId) {
            this.debug("processRange: addNewFile: %s\n", file);
            this.lineRecord.addNewFile(fileId);
        }
        int lineLoAddr = range.getLo() - this.primaryEntry.getPrimary().getLo();
        int line = Math.max(range.getLine(), 1);
        this.debug("processRange:   addNewLine: 0x%05x %s\n", lineLoAddr, line);
        this.lineRecord.addNewLine(lineLoAddr, line);
    }
}

