/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.util.Arrays;

public class NativeImageResourcePathRepresentation {
    protected final byte[] path;
    protected volatile int[] offsets;
    protected byte[] resolved;
    private int hashcode = 0;

    public NativeImageResourcePathRepresentation(byte[] resourcePath, boolean normalized) {
        this.path = normalized ? resourcePath : NativeImageResourcePathRepresentation.normalize(resourcePath);
    }

    public static String toCanonicalForm(String resourceName) {
        String withoutTrailingSlash = resourceName.endsWith("/") ? resourceName.substring(0, resourceName.length() - 1) : resourceName;
        NativeImageResourcePathRepresentation path = new NativeImageResourcePathRepresentation(withoutTrailingSlash.getBytes(StandardCharsets.UTF_8), true);
        return new String(NativeImageResourcePathRepresentation.getResolved(path));
    }

    private static byte[] normalize(byte[] resourcePath) {
        if (resourcePath.length == 0) {
            return resourcePath;
        }
        int i = 0;
        for (int j = 0; j < resourcePath.length; ++j) {
            int k = resourcePath[j];
            if (k == 92 || k == 47 && j == resourcePath.length - 1) {
                return NativeImageResourcePathRepresentation.normalize(resourcePath, j);
            }
            if (k == 47 && i == 47) {
                return NativeImageResourcePathRepresentation.normalize(resourcePath, j - 1);
            }
            if (k == 0) {
                throw new InvalidPathException(new String(resourcePath, StandardCharsets.UTF_8), "Path: nul character not allowed");
            }
            i = k;
        }
        return resourcePath;
    }

    private static byte[] normalize(byte[] resourcePath, int index) {
        int i;
        byte[] arrayOfByte = new byte[resourcePath.length];
        for (i = 0; i < index; ++i) {
            arrayOfByte[i] = resourcePath[i];
        }
        int j = i;
        int k = 0;
        while (i < resourcePath.length) {
            int m;
            if ((m = resourcePath[i++]) == 92) {
                m = 47;
            }
            if (m == 47 && k == 47) continue;
            if (m == 0) {
                throw new InvalidPathException(new String(resourcePath, StandardCharsets.UTF_8), "Path: nul character not allowed");
            }
            arrayOfByte[j++] = (byte)m;
            k = m;
        }
        if (j > 1 && arrayOfByte[j - 1] == 47) {
            --j;
        }
        return j == arrayOfByte.length ? arrayOfByte : Arrays.copyOf(arrayOfByte, j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initOffsets() {
        if (this.offsets == null) {
            int count = 0;
            int index = 0;
            while (index < this.path.length) {
                byte c;
                if ((c = this.path[index++]) == 47) continue;
                ++count;
                while (index < this.path.length && this.path[index] != 47) {
                    ++index;
                }
            }
            int[] result = new int[count];
            count = 0;
            index = 0;
            while (index < this.path.length) {
                byte m = this.path[index];
                if (m == 47) {
                    ++index;
                    continue;
                }
                result[count++] = index++;
                while (index < this.path.length && this.path[index] != 47) {
                    ++index;
                }
            }
            NativeImageResourcePathRepresentation nativeImageResourcePathRepresentation = this;
            synchronized (nativeImageResourcePathRepresentation) {
                if (this.offsets == null) {
                    this.offsets = result;
                }
            }
        }
    }

    protected static byte[] getResolved(NativeImageResourcePathRepresentation p) {
        int nc = p.getNameCount();
        byte[] path = p.path;
        int[] offsets = p.offsets;
        byte[] to = new byte[path.length];
        int[] lastM = new int[nc];
        int lastMOff = -1;
        int m = 0;
        for (int i = 0; i < nc; ++i) {
            int len;
            int n = offsets[i];
            int n2 = len = i == offsets.length - 1 ? path.length - n : offsets[i + 1] - n - 1;
            if (len == 1 && path[n] == 46) {
                if (m != 0 || path[0] != 47) continue;
                to[m++] = 47;
                continue;
            }
            if (len == 2 && path[n] == 46 && path[n + 1] == 46) {
                if (lastMOff >= 0) {
                    m = lastM[lastMOff--];
                    continue;
                }
                if (path[0] == 47) {
                    if (m != 0) continue;
                    to[m++] = 47;
                    continue;
                }
                if (m != 0 && to[m - 1] != 47) {
                    to[m++] = 47;
                }
                while (len-- > 0) {
                    to[m++] = path[n++];
                }
                continue;
            }
            if (m == 0 && path[0] == 47 || m != 0 && to[m - 1] != 47) {
                to[m++] = 47;
            }
            lastM[++lastMOff] = m;
            while (len-- > 0) {
                to[m++] = path[n++];
            }
        }
        if (m > 1 && to[m - 1] == 47) {
            --m;
        }
        return m == to.length ? to : Arrays.copyOf(to, m);
    }

    public int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    public int hashCode() {
        int h = this.hashcode;
        if (h == 0) {
            this.hashcode = h = Arrays.hashCode(this.path);
        }
        return h;
    }
}

