/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class GlobUtils {
    public static final List<Character> ALWAYS_ESCAPED_GLOB_WILDCARDS = List.of(Character.valueOf('?'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'));
    public static final String STAR = "*";
    public static final String STAR_STAR = "**";
    public static final String LEVEL_IDENTIFIER = "/";
    public static final String SAME_LEVEL_IDENTIFIER = "#";
    private static final Pattern threeConsecutiveStarsRegex = Pattern.compile(".*[*]{3,}.*");
    private static final Pattern emptyLevelsRegex = Pattern.compile(".*/{2,}.*");
    private static final String ALL_UNNAMED = "ALL_UNNAMED";

    private GlobUtils() {
    }

    public static String transformToTriePath(String resource, String module) {
        Object resolvedModuleName = module == null || module.isEmpty() ? ALL_UNNAMED : StringUtil.toSlashSeparated(module);
        if (!((String)resolvedModuleName).endsWith(LEVEL_IDENTIFIER)) {
            resolvedModuleName = (String)resolvedModuleName + LEVEL_IDENTIFIER;
        }
        String resolvedResourceName = resource.startsWith(LEVEL_IDENTIFIER) ? resource.substring(1) : resource;
        return (String)resolvedModuleName + resolvedResourceName;
    }

    public static String validatePattern(String pattern) {
        StringBuilder sb = new StringBuilder();
        if (pattern.isEmpty()) {
            sb.append("Pattern ").append(pattern).append(" : Pattern cannot be empty. ");
            return sb.toString();
        }
        if (threeConsecutiveStarsRegex.matcher(pattern).matches()) {
            sb.append("Pattern contains more than two consecutive * characters. ");
        }
        if (emptyLevelsRegex.matcher(pattern).matches()) {
            sb.append("Pattern contains empty levels. ");
        }
        if (pattern.contains("**/**")) {
            sb.append("Pattern contains invalid sequence **/**. Valid pattern should have ** followed by something other than **. ");
        }
        boolean escapeMode = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char current = pattern.charAt(i);
            if (ALWAYS_ESCAPED_GLOB_WILDCARDS.contains(Character.valueOf(current)) && !escapeMode) {
                sb.append("Pattern contains unescaped character ").append(current).append(". ");
            }
            escapeMode = current == '\\';
        }
        if (pattern.startsWith(ALL_UNNAMED)) {
            List<List<GlobToken>> patternParts = GlobUtils.tokenize(pattern);
            patternParts.removeFirst();
            block1: for (List<GlobToken> levelTokens : patternParts) {
                for (GlobToken token : levelTokens) {
                    if (token.kind == GlobToken.Kind.LITERAL) break block1;
                    if (token.kind != GlobToken.Kind.STAR_STAR) continue;
                    String patternWithoutModule = pattern.substring(ALL_UNNAMED.length() + 1);
                    LogUtils.warning("Pattern: " + patternWithoutModule + " contains ** without previous literal. This pattern is too generic and therefore can match many resources. Please make the pattern more specific by adding non-generic level before ** level.");
                }
            }
        }
        if (!sb.isEmpty()) {
            sb.insert(0, "Pattern " + pattern + " : ");
        }
        return sb.toString();
    }

    public static List<List<GlobToken>> tokenize(String glob) {
        String pattern = !glob.endsWith(LEVEL_IDENTIFIER) ? glob : glob.substring(0, glob.length() - 1);
        ArrayList<List<GlobToken>> parts = new ArrayList<List<GlobToken>>();
        for (String level : pattern.split(LEVEL_IDENTIFIER)) {
            parts.add(GlobUtils.tokenizePart(level));
        }
        return parts;
    }

    private static List<GlobToken> tokenizePart(String glob) {
        if (glob.equals(STAR_STAR)) {
            return List.of(new GlobToken(GlobToken.Kind.STAR_STAR, glob));
        }
        if (glob.equals(STAR)) {
            return List.of(new GlobToken(GlobToken.Kind.STAR, glob));
        }
        ArrayList<GlobToken> tokens = new ArrayList<GlobToken>();
        StringBuilder currentToken = new StringBuilder();
        boolean escaped = false;
        for (char c : glob.toCharArray()) {
            currentToken.append(c);
            if (c == STAR.charAt(0) && !escaped) {
                tokens.add(new GlobToken(GlobToken.Kind.LITERAL_STAR, currentToken.toString()));
                currentToken.setLength(0);
            }
            escaped = c == '\\';
        }
        if (!currentToken.isEmpty()) {
            tokens.add(new GlobToken(GlobToken.Kind.LITERAL, currentToken.toString()));
        }
        return tokens;
    }

    public record GlobToken(Kind kind, String value) {

        public static enum Kind {
            STAR_STAR,
            STAR,
            LITERAL_STAR,
            LITERAL;

        }
    }
}

