/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public final class TypeResult<T> {
    private final String name;
    private final T type;
    private final Throwable exception;

    public static <V> TypeResult<V> forType(String name, V type) {
        return new TypeResult<V>(name, type);
    }

    public static TypeResult<Class<?>> forClass(Class<?> clazz) {
        return new TypeResult(clazz.getName(), clazz);
    }

    public static <T> TypeResult<T> forException(String name, Throwable exception) {
        return new TypeResult<Object>(name, null, exception);
    }

    public static <T> TypeResult<T> toSingleElement(TypeResult<List<T>> result) {
        if (result.isPresent()) {
            if (result.get().size() != 1) {
                throw new IllegalArgumentException("Ambiguous type descriptor not allowed here");
            }
            return TypeResult.forType(result.getName(), result.get().getFirst());
        }
        return TypeResult.forException(result.getName(), result.getException());
    }

    public static <T> TypeResult<List<T>> toList(TypeResult<T> result) {
        if (result.isPresent()) {
            return TypeResult.forType(result.getName(), List.of(result.get()));
        }
        return TypeResult.forException(result.getName(), result.getException());
    }

    private TypeResult(String name, T type) {
        this(name, type, null);
    }

    private TypeResult(String name, T type, Throwable exception) {
        this.name = name;
        this.type = type;
        this.exception = exception;
    }

    public boolean isPresent() {
        return this.type != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.type != null) {
            consumer.accept(this.type);
        }
    }

    public T get() {
        return this.type;
    }

    public <U> TypeResult<U> map(Function<T, U> f) {
        if (this.isPresent()) {
            return new TypeResult<U>(this.name, f.apply(this.get()));
        }
        return TypeResult.forException(this.name, this.getException());
    }

    public String getName() {
        return this.name;
    }

    public Throwable getException() {
        return this.exception;
    }

    public T getOrFail() {
        if (this.type != null) {
            return this.type;
        }
        throw new IllegalStateException("Type " + this.name + " not found", this.exception);
    }
}

