/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import com.oracle.svm.util.ModuleSupport;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectionUtil {
    private static final Method fieldGetDeclaredFields0 = ReflectionUtil.lookupMethod(Class.class, "getDeclaredFields0", Boolean.TYPE);

    private ReflectionUtil() {
    }

    private static void openModule(Class<?> declaringClass) {
        ModuleSupport.accessModuleByClass(ModuleSupport.Access.OPEN, ReflectionUtil.class, declaringClass);
    }

    public static Class<?> lookupClass(boolean optional, String className) {
        try {
            return Class.forName(className, false, ReflectionUtil.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            if (optional) {
                return null;
            }
            throw new ReflectionUtilError(ex);
        }
    }

    public static Method lookupMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtil.lookupMethod(false, declaringClass, methodName, parameterTypes);
    }

    public static Method lookupMethod(boolean optional, Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        try {
            Method result = declaringClass.getDeclaredMethod(methodName, parameterTypes);
            ReflectionUtil.openModule(declaringClass);
            result.setAccessible(true);
            return result;
        }
        catch (ReflectiveOperationException ex) {
            if (optional) {
                return null;
            }
            throw new ReflectionUtilError(ex);
        }
    }

    public static Method lookupPublicMethodInClassHierarchy(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtil.lookupPublicMethodInClassHierarchy(false, clazz, methodName, parameterTypes);
    }

    public static Method lookupPublicMethodInClassHierarchy(boolean optional, Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            Method result = clazz.getMethod(methodName, parameterTypes);
            ReflectionUtil.openModule(result.getDeclaringClass());
            result.setAccessible(true);
            return result;
        }
        catch (ReflectiveOperationException ex) {
            if (optional) {
                return null;
            }
            throw new ReflectionUtilError(ex);
        }
    }

    public static <T> Constructor<T> lookupConstructor(Class<T> declaringClass, Class<?> ... parameterTypes) {
        return ReflectionUtil.lookupConstructor(false, declaringClass, parameterTypes);
    }

    public static <T> Constructor<T> lookupConstructor(boolean optional, Class<T> declaringClass, Class<?> ... parameterTypes) {
        try {
            Constructor<T> result = declaringClass.getDeclaredConstructor(parameterTypes);
            ReflectionUtil.openModule(declaringClass);
            result.setAccessible(true);
            return result;
        }
        catch (ReflectiveOperationException ex) {
            if (optional) {
                return null;
            }
            throw new ReflectionUtilError(ex);
        }
    }

    public static <T> T invokeMethod(Method method, Object receiver, Object ... arguments) {
        try {
            method.setAccessible(true);
            return (T)method.invoke(receiver, arguments);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                throw ReflectionUtil.rethrow(cause);
            }
            throw new ReflectionUtilError(ex);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtilError(ex);
        }
    }

    private static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    public static <T> T newInstance(Class<T> declaringClass) {
        try {
            return ReflectionUtil.lookupConstructor(declaringClass, new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtilError(ex);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... initArgs) {
        try {
            return constructor.newInstance(initArgs);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtilError(ex);
        }
    }

    public static VarHandle unreflectField(Class<?> declaringClass, String fieldName, MethodHandles.Lookup lookup) {
        try {
            Field field = ReflectionUtil.lookupField(declaringClass, fieldName);
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(declaringClass, lookup);
            return privateLookup.unreflectVarHandle(field);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionUtilError(ex);
        }
    }

    public static Field lookupField(Class<?> declaringClass, String fieldName) {
        return ReflectionUtil.lookupField(false, declaringClass, fieldName);
    }

    public static Field lookupField(boolean optional, Class<?> declaringClass, String fieldName) {
        try {
            Field result = declaringClass.getDeclaredField(fieldName);
            ReflectionUtil.openModule(declaringClass);
            result.setAccessible(true);
            return result;
        }
        catch (ReflectiveOperationException ex) {
            try {
                Field[] allFields;
                for (Field field : allFields = (Field[])fieldGetDeclaredFields0.invoke(declaringClass, false)) {
                    if (!field.getName().equals(fieldName)) continue;
                    ReflectionUtil.openModule(declaringClass);
                    field.setAccessible(true);
                    return field;
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            if (optional) {
                return null;
            }
            throw new ReflectionUtilError(ex);
        }
    }

    public static <T> T readField(Class<?> declaringClass, String fieldName, Object receiver) {
        try {
            return (T)ReflectionUtil.lookupField(declaringClass, fieldName).get(receiver);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtilError(ex);
        }
    }

    public static <T> T readStaticField(Class<?> declaringClass, String fieldName) {
        return ReflectionUtil.readField(declaringClass, fieldName, null);
    }

    public static void writeField(Class<?> declaringClass, String fieldName, Object receiver, Object value) {
        try {
            ReflectionUtil.lookupField(declaringClass, fieldName).set(receiver, value);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtilError(ex);
        }
    }

    public static void writeStaticField(Class<?> declaringClass, String fieldName, Object value) {
        ReflectionUtil.writeField(declaringClass, fieldName, null, value);
    }

    public static final class ReflectionUtilError
    extends Error {
        private ReflectionUtilError(Throwable cause) {
            super(cause);
        }
    }
}

