/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMException;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLazyException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import com.oracle.truffle.llvm.runtime.types.visitors.RecursiveTypeCheckVisitor;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;
import java.util.Arrays;
import java.util.List;

public abstract class Type {
    public static final Type[] EMPTY_ARRAY = new Type[0];

    protected boolean verifyCycleFree(Type type) {
        RecursiveTypeCheckVisitor.check(this, type);
        return true;
    }

    public static Type[] getRawTypeArray(TypeArrayBuilder types) {
        return types.getRawArray();
    }

    public abstract long getBitSize() throws TypeOverflowException;

    protected final long getBitSizeUnchecked() {
        try {
            return this.getBitSize();
        }
        catch (TypeOverflowException e) {
            throw new TypeOverflowExceptionUnchecked(e);
        }
    }

    public abstract void accept(TypeVisitor var1);

    public abstract LLVMExpressionNode createNullConstant(NodeFactory var1, DataLayout var2, GetStackSpaceFactory var3);

    public abstract int getAlignment(DataLayout var1);

    public abstract long getSize(DataLayout var1) throws TypeOverflowException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static Type getIntegerType(int size) {
        switch (size) {
            case 1: {
                return PrimitiveType.I1;
            }
            case 8: {
                return PrimitiveType.I8;
            }
            case 16: {
                return PrimitiveType.I16;
            }
            case 32: {
                return PrimitiveType.I32;
            }
            case 64: {
                return PrimitiveType.I64;
            }
        }
        return new VariableBitWidthType(size);
    }

    public static Type createConstantForType(Type type, Object value) {
        if (type instanceof PrimitiveType) {
            return new PrimitiveType(((PrimitiveType)type).getPrimitiveKind(), value);
        }
        return new VariableBitWidthType(((VariableBitWidthType)type).getBitSizeInt(), value);
    }

    public static boolean isIntegerType(Type type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            PrimitiveType.PrimitiveKind kind = primitive.getPrimitiveKind();
            return kind == PrimitiveType.PrimitiveKind.I1 || kind == PrimitiveType.PrimitiveKind.I8 || kind == PrimitiveType.PrimitiveKind.I16 || kind == PrimitiveType.PrimitiveKind.I32 || kind == PrimitiveType.PrimitiveKind.I64;
        }
        return type instanceof VariableBitWidthType;
    }

    public static boolean isFloatingpointType(Type type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            PrimitiveType.PrimitiveKind kind = primitive.getPrimitiveKind();
            return kind == PrimitiveType.PrimitiveKind.F128 || kind == PrimitiveType.PrimitiveKind.FLOAT || kind == PrimitiveType.PrimitiveKind.HALF || kind == PrimitiveType.PrimitiveKind.PPC_FP128 || kind == PrimitiveType.PrimitiveKind.X86_FP80 || kind == PrimitiveType.PrimitiveKind.DOUBLE;
        }
        return false;
    }

    public static FrameSlotKind getFrameSlotKind(Type type) {
        long bitSize;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            PrimitiveType.PrimitiveKind kind = primitive.getPrimitiveKind();
            switch (kind) {
                case FLOAT: {
                    return FrameSlotKind.Float;
                }
                case DOUBLE: {
                    return FrameSlotKind.Double;
                }
                case I1: {
                    return FrameSlotKind.Boolean;
                }
                case I16: 
                case I32: {
                    return FrameSlotKind.Int;
                }
                case I64: {
                    return FrameSlotKind.Long;
                }
                case I8: {
                    return FrameSlotKind.Byte;
                }
            }
            return FrameSlotKind.Object;
        }
        if (type instanceof VariableBitWidthType && Type.fitsIntoUnsignedInt(bitSize = ((VariableBitWidthType)type).getBitSize())) {
            switch (Type.toUnsignedInt(bitSize)) {
                case 1: {
                    return FrameSlotKind.Boolean;
                }
                case 8: {
                    return FrameSlotKind.Byte;
                }
                case 16: 
                case 32: {
                    return FrameSlotKind.Int;
                }
                case 64: {
                    return FrameSlotKind.Long;
                }
            }
            return FrameSlotKind.Object;
        }
        return FrameSlotKind.Object;
    }

    public static int getPadding(long offset, int alignment) {
        assert ((alignment == 0 ? 0L : ((long)alignment - offset % (long)alignment) % (long)alignment) == (long)((int)(alignment == 0 ? 0L : ((long)alignment - offset % (long)alignment) % (long)alignment)));
        return (int)(alignment == 0 ? 0L : ((long)alignment - offset % (long)alignment) % (long)alignment);
    }

    public static int getPadding(long offset, Type type, DataLayout targetDataLayout) {
        int alignment = type.getAlignment(targetDataLayout);
        return Type.getPadding(offset, alignment);
    }

    public static boolean fitsIntoUnsignedInt(long l) {
        return (l & 0xFFFFFFFF00000000L) == 0L;
    }

    public static int toUnsignedInt(long l) {
        assert (Type.fitsIntoUnsignedInt(l));
        return (int)l;
    }

    public static long multiplyUnsignedExact(long x, long y) throws TypeOverflowException {
        long res = x * y;
        long overflow = ExactMath.multiplyHighUnsigned((long)x, (long)y);
        if (overflow != 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new TypeOverflowException("unsigned multiplication overflow");
        }
        return res;
    }

    public static long multiplySignedExact(long x, long y) throws TypeOverflowException {
        try {
            return Math.multiplyExact(x, y);
        }
        catch (ArithmeticException e) {
            throw new TypeOverflowException(e);
        }
    }

    public static long addUnsignedExact(long x, long y) throws TypeOverflowException {
        long res = x + y;
        if (Long.compareUnsigned(res, x) < 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new TypeOverflowException("unsigned addition overflow");
        }
        return res;
    }

    public static long subUnsignedExact(long x, long y) throws TypeOverflowException {
        if (Long.compareUnsigned(x, y) < 0) {
            throw new TypeOverflowException("unsigned subtraction underflow");
        }
        return x - y;
    }

    protected static long addUnsignedExactUnchecked(long x, long y) {
        try {
            return Type.addUnsignedExact(x, y);
        }
        catch (TypeOverflowException e) {
            throw new TypeOverflowExceptionUnchecked(e);
        }
    }

    public static LLVMExpressionNode handleOverflowExpression(TypeOverflowException e) {
        return LLVMLazyException.createExpressionNode(Type::throwOverflowExceptionAsLLVMException, e);
    }

    public static LLVMStatementNode handleOverflowStatement(TypeOverflowException e) {
        return LLVMLazyException.createStatementNode(Type::throwOverflowExceptionAsLLVMException, e);
    }

    public static LLVMAllocateNode handleOverflowAllocate(TypeOverflowException e) {
        return LLVMLazyException.createAllocateNode(Type::throwOverflowExceptionAsLLVMException, e);
    }

    public static LLVMException throwOverflowExceptionAsLLVMException(Node node, TypeOverflowException e) {
        throw new LLVMUnsupportedException(node, LLVMUnsupportedException.UnsupportedReason.UNSUPPORTED_VALUE_RANGE, (Throwable)e);
    }

    public static class TypeArrayBuilder {
        private Type[] types;

        public TypeArrayBuilder(int size) {
            this.types = new Type[size];
        }

        public void set(int idx, Type type) {
            this.check();
            this.types[idx] = type;
        }

        public Type get(int idx) {
            this.check();
            return this.types[idx];
        }

        public int size() {
            this.check();
            return this.types.length;
        }

        public List<Type> asList() {
            return Arrays.asList(this.getRawArray());
        }

        private Type[] getRawArray() {
            this.check();
            Type[] ret = this.types;
            this.types = null;
            return ret;
        }

        private void check() {
            if (this.types == null) {
                throw new IllegalStateException("TypeArray already finalized");
            }
        }
    }

    public static final class TypeOverflowException
    extends Exception {
        private static final long serialVersionUID = 2239196977333486425L;

        public TypeOverflowException(Throwable cause) {
            super(cause);
        }

        public TypeOverflowException(String message) {
            super(message);
        }
    }

    protected static final class TypeOverflowExceptionUnchecked
    extends RuntimeException {
        private static final long serialVersionUID = 1284366666528782360L;

        public TypeOverflowExceptionUnchecked(TypeOverflowException cause) {
            super(cause);
        }

        @Override
        public synchronized TypeOverflowException getCause() {
            return (TypeOverflowException)super.getCause();
        }
    }
}

