/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteOrder;

public abstract class LLVMPolyglotWriteBuffer
extends LLVMNode {
    protected boolean isWritableBufferPointer(LLVMPointer receiver) {
        LLVMInteropType exportType = receiver.getExportType();
        return exportType instanceof LLVMInteropType.Buffer && ((LLVMInteropType.Buffer)exportType).isWritable();
    }

    protected boolean inBounds(LLVMPointer receiver, long byteOffset, int length) {
        return byteOffset >= 0L && byteOffset + (long)length <= receiver.getExportType().getSize();
    }

    protected boolean isNativeOrder(ByteOrder order) {
        return order == ByteOrder.nativeOrder();
    }

    protected void throwUnsupported(LLVMPointer receiver, long byteOffset) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotWriteBufferDoubleNode
    extends LLVMPolyglotWriteBuffer {
        public abstract void execute(LLVMPointer var1, ByteOrder var2, long var3, double var5) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isWritableBufferPointer(receiver)"})
        public void doNative(LLVMNativePointer receiver, ByteOrder order, long byteOffset, double value, @Cached BranchProfile exception, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode storeOffset) throws InvalidBufferOffsetException {
            if (!this.inBounds(receiver, byteOffset, 8)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            long bits = Double.doubleToRawLongBits(value);
            storeOffset.executeWithTarget(receiver, byteOffset, this.isNativeOrder(order) ? bits : Long.reverseBytes(bits));
        }

        @Specialization(guards={"isWritableBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public void doNonForeign(LLVMManagedPointer pointer, ByteOrder order, long byteOffset, double value, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode storeOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException {
            if (!this.inBounds(pointer, byteOffset, 8)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            long bits = Double.doubleToRawLongBits(value);
            storeOffset.executeWithTarget(pointer, byteOffset, this.isNativeOrder(order) ? bits : Long.reverseBytes(bits));
        }

        @Fallback
        public void unsupported(LLVMPointer receiver, ByteOrder order, long byteOffset, double value) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotWriteBufferFloatNode
    extends LLVMPolyglotWriteBuffer {
        public abstract void execute(LLVMPointer var1, ByteOrder var2, long var3, float var5) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isWritableBufferPointer(receiver)"})
        public void doNative(LLVMNativePointer receiver, ByteOrder order, long byteOffset, float value, @Cached BranchProfile exception, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode storeOffset) throws InvalidBufferOffsetException {
            if (!this.inBounds(receiver, byteOffset, 4)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            int bits = Float.floatToRawIntBits(value);
            storeOffset.executeWithTarget(receiver, byteOffset, this.isNativeOrder(order) ? bits : Integer.reverseBytes(bits));
        }

        @Specialization(guards={"isWritableBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public void doNonForeign(LLVMManagedPointer pointer, ByteOrder order, long byteOffset, float value, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode storeOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException {
            if (!this.inBounds(pointer, byteOffset, 4)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            int bits = Float.floatToRawIntBits(value);
            storeOffset.executeWithTarget(pointer, byteOffset, this.isNativeOrder(order) ? bits : Integer.reverseBytes(bits));
        }

        @Fallback
        public void unsupported(LLVMPointer receiver, ByteOrder order, long byteOffset, float value) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotWriteBufferLongNode
    extends LLVMPolyglotWriteBuffer {
        public abstract void execute(LLVMPointer var1, ByteOrder var2, long var3, long var5) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isWritableBufferPointer(receiver)"})
        public void doNative(LLVMNativePointer receiver, ByteOrder order, long byteOffset, long value, @Cached BranchProfile exception, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode storeOffset) throws InvalidBufferOffsetException {
            if (!this.inBounds(receiver, byteOffset, 8)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            storeOffset.executeWithTarget(receiver, byteOffset, this.isNativeOrder(order) ? value : Long.reverseBytes(value));
        }

        @Specialization(guards={"isWritableBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public void doNonForeign(LLVMManagedPointer pointer, ByteOrder order, long byteOffset, long value, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode storeOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException {
            if (!this.inBounds(pointer, byteOffset, 8)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            storeOffset.executeWithTarget(pointer, byteOffset, this.isNativeOrder(order) ? value : Long.reverseBytes(value));
        }

        @Fallback
        public void unsupported(LLVMPointer receiver, ByteOrder order, long byteOffset, long value) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotWriteBufferIntNode
    extends LLVMPolyglotWriteBuffer {
        public abstract void execute(LLVMPointer var1, ByteOrder var2, long var3, int var5) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isWritableBufferPointer(receiver)"})
        public void doNative(LLVMNativePointer receiver, ByteOrder order, long byteOffset, int value, @Cached BranchProfile exception, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode storeOffset) throws InvalidBufferOffsetException {
            if (!this.inBounds(receiver, byteOffset, 4)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            storeOffset.executeWithTarget(receiver, byteOffset, this.isNativeOrder(order) ? value : Integer.reverseBytes(value));
        }

        @Specialization(guards={"isWritableBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public void doNonForeign(LLVMManagedPointer pointer, ByteOrder order, long byteOffset, int value, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode storeOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException {
            if (!this.inBounds(pointer, byteOffset, 4)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            storeOffset.executeWithTarget(pointer, byteOffset, this.isNativeOrder(order) ? value : Integer.reverseBytes(value));
        }

        @Fallback
        public void unsupported(LLVMPointer receiver, ByteOrder order, long byteOffset, int value) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotWriteBufferShortNode
    extends LLVMPolyglotWriteBuffer {
        public abstract void execute(LLVMPointer var1, ByteOrder var2, long var3, short var5) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isWritableBufferPointer(receiver)"})
        public void doNative(LLVMNativePointer receiver, ByteOrder order, long byteOffset, short value, @Cached BranchProfile exception, @Cached LLVMI16StoreNode.LLVMI16OffsetStoreNode storeOffset) throws InvalidBufferOffsetException {
            if (!this.inBounds(receiver, byteOffset, 2)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            storeOffset.executeWithTarget(receiver, byteOffset, this.isNativeOrder(order) ? value : Short.reverseBytes(value));
        }

        @Specialization(guards={"isWritableBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public void doNonForeign(LLVMManagedPointer pointer, ByteOrder order, long byteOffset, short value, @Cached LLVMI16StoreNode.LLVMI16OffsetStoreNode storeOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException {
            if (!this.inBounds(pointer, byteOffset, 2)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            storeOffset.executeWithTarget(pointer, byteOffset, this.isNativeOrder(order) ? value : Short.reverseBytes(value));
        }

        @Fallback
        public void unsupported(LLVMPointer receiver, ByteOrder order, long byteOffset, short value) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotWriteBufferByteNode
    extends LLVMPolyglotWriteBuffer {
        public abstract void execute(LLVMPointer var1, long var2, byte var4) throws UnsupportedMessageException, InvalidBufferOffsetException;

        @Specialization(guards={"isWritableBufferPointer(receiver)"})
        public void doNative(LLVMNativePointer receiver, long byteOffset, byte value, @Cached BranchProfile exception, @Cached LLVMI8StoreNode.LLVMI8OffsetStoreNode storeOffset) throws InvalidBufferOffsetException {
            if (!this.inBounds(receiver, byteOffset, 1)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            storeOffset.executeWithTarget(receiver, byteOffset, value);
        }

        @Specialization(guards={"isWritableBufferPointer(pointer)", "!foreignsLib.isForeign(pointer)"}, limit="3")
        @GenerateAOT.Exclude
        public void doNonForeign(LLVMManagedPointer pointer, long byteOffset, byte value, @Cached LLVMI8StoreNode.LLVMI8OffsetStoreNode storeOffset, @Cached BranchProfile exception, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) throws InvalidBufferOffsetException {
            if (!this.inBounds(pointer, byteOffset, 1)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)8L);
            }
            storeOffset.executeWithTarget(pointer, byteOffset, value);
        }

        @Fallback
        public void unsupported(LLVMPointer receiver, long byteOffset, byte value) throws UnsupportedMessageException {
            this.throwUnsupported(receiver, byteOffset);
        }
    }
}

