/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

public abstract class LLVMAMD64GetFlagNodes {
    private static final byte ZERO = 0;
    private static final byte ONE = 1;

    private LLVMAMD64GetFlagNodes() {
    }

    @NodeChildren(value={@NodeChild(value="zf"), @NodeChild(value="sf"), @NodeChild(value="of")})
    public static abstract class LLVMAMD64GetFlagLENode
    extends LLVMExpressionNode {
        @Specialization
        protected byte doI8(boolean zf, boolean sf, boolean of) {
            return zf || sf != of ? (byte)1 : 0;
        }
    }

    @NodeChildren(value={@NodeChild(value="zf"), @NodeChild(value="sf"), @NodeChild(value="of")})
    public static abstract class LLVMAMD64GetFlagGNode
    extends LLVMExpressionNode {
        @Specialization
        protected byte doI8(boolean zf, boolean sf, boolean of) {
            return !zf && sf == of ? (byte)1 : 0;
        }
    }

    @NodeChildren(value={@NodeChild(value="value1"), @NodeChild(value="value2")})
    public static abstract class LLVMAMD64GetFlagXorNode
    extends LLVMExpressionNode {
        @Specialization
        protected byte doI8(boolean value1, boolean value2) {
            return value1 != value2 ? (byte)1 : 0;
        }
    }

    @NodeChildren(value={@NodeChild(value="value1"), @NodeChild(value="value2")})
    public static abstract class LLVMAMD64GetFlagEqualNode
    extends LLVMExpressionNode {
        @Specialization
        protected byte doI8(boolean value1, boolean value2) {
            return value1 == value2 ? (byte)1 : 0;
        }
    }

    @NodeChildren(value={@NodeChild(value="value1"), @NodeChild(value="value2")})
    public static abstract class LLVMAMD64GetFlagAndNode
    extends LLVMExpressionNode {
        @Specialization
        protected byte doI8(boolean value1, boolean value2) {
            return value1 && value2 ? (byte)1 : 0;
        }
    }

    @NodeChildren(value={@NodeChild(value="value1"), @NodeChild(value="value2")})
    public static abstract class LLVMAMD64GetFlagNorNode
    extends LLVMExpressionNode {
        @Specialization
        protected byte doI8(boolean value1, boolean value2) {
            return !value1 && !value2 ? (byte)1 : 0;
        }
    }

    @NodeChildren(value={@NodeChild(value="value1"), @NodeChild(value="value2")})
    public static abstract class LLVMAMD64GetFlagOrNode
    extends LLVMExpressionNode {
        @Specialization
        protected byte doI8(boolean value1, boolean value2) {
            return value1 || value2 ? (byte)1 : 0;
        }
    }

    @NodeChild(value="value")
    public static abstract class LLVMAMD64GetFlagNegNode
    extends LLVMExpressionNode {
        @Specialization
        protected byte doI8(boolean value) {
            return value ? (byte)0 : 1;
        }
    }

    @NodeChild(value="value")
    public static abstract class LLVMAMD64GetFlagNode
    extends LLVMExpressionNode {
        @Specialization
        protected byte doI8(boolean value) {
            return value ? (byte)1 : 0;
        }
    }
}

