/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
final class VirtualAllocGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<LLVMManagedWriteLibrary> LL_VM_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);

    private VirtualAllocGen() {
    }

    static {
        LibraryExport.register(LLVMManagedAccessDefaults.VirtualAlloc.class, (LibraryExport[])new LibraryExport[]{new LLVMManagedReadLibraryExports(), new LLVMManagedWriteLibraryExports()});
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, byte[].class, true, false, 0);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            assert (receiver instanceof byte[]);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            assert (receiver instanceof byte[]);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMManagedReadLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof byte[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof byte[];
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.VirtualAlloc.isAccessible((byte[])receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI8(arg0Value, arg1Value, (LLVMManagedWriteLibrary)LL_VM_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value), BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI16(arg0Value, arg1Value, (LLVMManagedWriteLibrary)LL_VM_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value), BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI32(arg0Value, arg1Value, (LLVMManagedWriteLibrary)LL_VM_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value), BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI64(arg0Value, arg1Value, (LLVMManagedWriteLibrary)LL_VM_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value), BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readFloat(arg0Value, arg1Value, (LLVMManagedWriteLibrary)LL_VM_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value), BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readDouble(arg0Value, arg1Value, (LLVMManagedWriteLibrary)LL_VM_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value), BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readPointer(arg0Value, arg1Value, (LLVMManagedWriteLibrary)LL_VM_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value), BranchProfile.getUncached());
            }
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
        private static final class Cached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private LLVMManagedWriteLibrary receiverLLVMManagedWriteLibrary_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile exception;

            protected Cached(Object receiver) {
                byte[] castReceiver = (byte[])receiver;
                this.receiverLLVMManagedWriteLibrary_ = (LLVMManagedWriteLibrary)LL_VM_MANAGED_WRITE_LIBRARY_.create((Object)castReceiver);
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof byte[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof byte[])) {
                    return false;
                }
                return this.receiverLLVMManagedWriteLibrary_.accepts(receiver);
            }

            @Override
            public boolean isReadable(Object receiver) {
                assert (receiver instanceof byte[]) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                return LLVMManagedAccessDefaults.VirtualAlloc.isAccessible((byte[])receiver);
            }

            @Override
            public byte readI8(Object arg0Value_, long arg1Value) {
                BranchProfile exception_;
                assert (arg0Value_ instanceof byte[]) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (exception_ = this.exception) != null) {
                    LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                    return LLVMManagedAccessDefaults.VirtualAlloc.readI8(arg0Value, arg1Value, self__, exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI8Node_AndSpecialize(arg0Value, arg1Value);
            }

            private byte readI8Node_AndSpecialize(byte[] arg0Value, long arg1Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                LLVMManagedWriteLibrary self__ = null;
                self__ = this.receiverLLVMManagedWriteLibrary_;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 1;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI8(arg0Value, arg1Value, self__, exception_);
            }

            @Override
            public short readI16(Object arg0Value_, long arg1Value) {
                BranchProfile exception_;
                assert (arg0Value_ instanceof byte[]) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0 && (exception_ = this.exception) != null) {
                    LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                    return LLVMManagedAccessDefaults.VirtualAlloc.readI16(arg0Value, arg1Value, self__, exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI16Node_AndSpecialize(arg0Value, arg1Value);
            }

            private short readI16Node_AndSpecialize(byte[] arg0Value, long arg1Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                LLVMManagedWriteLibrary self__ = null;
                self__ = this.receiverLLVMManagedWriteLibrary_;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 2;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI16(arg0Value, arg1Value, self__, exception_);
            }

            @Override
            public int readI32(Object arg0Value_, long arg1Value) {
                BranchProfile exception_;
                assert (arg0Value_ instanceof byte[]) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0 && (exception_ = this.exception) != null) {
                    LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                    return LLVMManagedAccessDefaults.VirtualAlloc.readI32(arg0Value, arg1Value, self__, exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI32Node_AndSpecialize(arg0Value, arg1Value);
            }

            private int readI32Node_AndSpecialize(byte[] arg0Value, long arg1Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                LLVMManagedWriteLibrary self__ = null;
                self__ = this.receiverLLVMManagedWriteLibrary_;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 4;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI32(arg0Value, arg1Value, self__, exception_);
            }

            @Override
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                BranchProfile exception_;
                assert (arg0Value_ instanceof byte[]) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0 && (exception_ = this.exception) != null) {
                    LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                    return LLVMManagedAccessDefaults.VirtualAlloc.readI64(arg0Value, arg1Value, self__, exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI64Node_AndSpecialize(arg0Value, arg1Value);
            }

            private long readI64Node_AndSpecialize(byte[] arg0Value, long arg1Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                LLVMManagedWriteLibrary self__ = null;
                self__ = this.receiverLLVMManagedWriteLibrary_;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 8;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI64(arg0Value, arg1Value, self__, exception_);
            }

            @Override
            public float readFloat(Object arg0Value_, long arg1Value) {
                BranchProfile exception_;
                assert (arg0Value_ instanceof byte[]) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0 && (exception_ = this.exception) != null) {
                    LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                    return LLVMManagedAccessDefaults.VirtualAlloc.readFloat(arg0Value, arg1Value, self__, exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            private float readFloatNode_AndSpecialize(byte[] arg0Value, long arg1Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                LLVMManagedWriteLibrary self__ = null;
                self__ = this.receiverLLVMManagedWriteLibrary_;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 0x10;
                return LLVMManagedAccessDefaults.VirtualAlloc.readFloat(arg0Value, arg1Value, self__, exception_);
            }

            @Override
            public double readDouble(Object arg0Value_, long arg1Value) {
                BranchProfile exception_;
                assert (arg0Value_ instanceof byte[]) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0 && (exception_ = this.exception) != null) {
                    LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                    return LLVMManagedAccessDefaults.VirtualAlloc.readDouble(arg0Value, arg1Value, self__, exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            private double readDoubleNode_AndSpecialize(byte[] arg0Value, long arg1Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                LLVMManagedWriteLibrary self__ = null;
                self__ = this.receiverLLVMManagedWriteLibrary_;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 0x20;
                return LLVMManagedAccessDefaults.VirtualAlloc.readDouble(arg0Value, arg1Value, self__, exception_);
            }

            @Override
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                BranchProfile exception_;
                assert (arg0Value_ instanceof byte[]) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedReadLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0 && (exception_ = this.exception) != null) {
                    LLVMManagedWriteLibrary self__ = this.receiverLLVMManagedWriteLibrary_;
                    return LLVMManagedAccessDefaults.VirtualAlloc.readPointer(arg0Value, arg1Value, self__, exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readPointerNode_AndSpecialize(arg0Value, arg1Value);
            }

            private LLVMPointer readPointerNode_AndSpecialize(byte[] arg0Value, long arg1Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                LLVMManagedWriteLibrary self__ = null;
                self__ = this.receiverLLVMManagedWriteLibrary_;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 0x40;
                return LLVMManagedAccessDefaults.VirtualAlloc.readPointer(arg0Value, arg1Value, self__, exception_);
            }
        }
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
    private static final class LLVMManagedWriteLibraryExports
    extends LibraryExport<LLVMManagedWriteLibrary> {
        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, byte[].class, true, false, 0);
        }

        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            assert (receiver instanceof byte[]);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            assert (receiver instanceof byte[]);
            return new Cached();
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMManagedWriteLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof byte[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof byte[];
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                if (arg2Value instanceof Long) {
                    long arg2Value_ = (Long)arg2Value;
                    LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writeI64(arg0Value, arg1Value, arg2Value_, this, BranchProfile.getUncached());
                    return;
                }
                if (arg2Value instanceof LLVMPointer) {
                    LLVMPointer arg2Value_ = (LLVMPointer)arg2Value;
                    LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writePointer(arg0Value, arg1Value, arg2Value_, LLVMNativePointerSupportFactory.ToNativePointerNodeGen.getUncached(), BranchProfile.getUncached());
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException3LJL((Node)this, arg0Value, arg1Value, arg2Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.VirtualAlloc.isAccessible((byte[])receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI8(arg0Value, arg1Value, arg2Value, this, BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI16(arg0Value, arg1Value, arg2Value, this, BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI32(arg0Value, arg1Value, arg2Value, this, BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI64(arg0Value, arg1Value, arg2Value, this, BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeFloat(arg0Value, arg1Value, arg2Value, this, BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                byte[] arg0Value = (byte[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeDouble(arg0Value, arg1Value, arg2Value, this, BranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException3LJL(Node thisNode_, Object arg0Value, long arg1Value, Object arg2Value) {
                return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value, arg2Value});
            }
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
        private static final class Cached
        extends LLVMManagedWriteLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile exception;
            @Node.Child
            private WriteGenericI64WritePointerData writeGenericI64_writePointer_cache;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof byte[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof byte[];
            }

            @Override
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg2Value instanceof Long) {
                        long arg2Value_ = (Long)arg2Value;
                        BranchProfile exception_ = this.exception;
                        if (exception_ != null) {
                            Cached self__ = this;
                            LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writeI64(arg0Value, arg1Value, arg2Value_, self__, exception_);
                            return;
                        }
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof LLVMPointer) {
                        LLVMPointer arg2Value_ = (LLVMPointer)arg2Value;
                        WriteGenericI64WritePointerData s1_ = this.writeGenericI64_writePointer_cache;
                        if (s1_ != null) {
                            LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writePointer(arg0Value, arg1Value, arg2Value_, s1_.toNativePointer_, s1_.exception_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeGenericI64AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeGenericI64AndSpecialize(byte[] arg0Value, long arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                Cached self__ = null;
                if (arg2Value instanceof Long) {
                    BranchProfile exception_;
                    long arg2Value_ = (Long)arg2Value;
                    self__ = this;
                    BranchProfile exception__shared = this.exception;
                    if (exception__shared != null) {
                        exception_ = exception__shared;
                    } else {
                        exception_ = BranchProfile.create();
                        if (exception_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.exception == null) {
                        VarHandle.storeStoreFence();
                        this.exception = exception_;
                    }
                    this.state_0_ = state_0 |= 1;
                    LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writeI64(arg0Value, arg1Value, arg2Value_, self__, exception_);
                    return;
                }
                if (arg2Value instanceof LLVMPointer) {
                    LLVMPointer arg2Value_ = (LLVMPointer)arg2Value;
                    WriteGenericI64WritePointerData s1_ = (WriteGenericI64WritePointerData)this.insert(new WriteGenericI64WritePointerData());
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointer__ = (LLVMNativePointerSupport.ToNativePointerNode)s1_.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                    Objects.requireNonNull(toNativePointer__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s1_.toNativePointer_ = toNativePointer__;
                    BranchProfile exception__ = BranchProfile.create();
                    Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s1_.exception_ = exception__;
                    VarHandle.storeStoreFence();
                    this.writeGenericI64_writePointer_cache = s1_;
                    this.state_0_ = state_0 |= 2;
                    LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writePointer(arg0Value, arg1Value, arg2Value_, toNativePointer__, exception__);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                return LLVMManagedAccessDefaults.VirtualAlloc.isAccessible((byte[])receiver);
            }

            @Override
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                BranchProfile exception_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0 && (exception_ = this.exception) != null) {
                    Cached self__ = this;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI8(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI8Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI8Node_AndSpecialize(byte[] arg0Value, long arg1Value, byte arg2Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                Cached self__ = null;
                self__ = this;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 4;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI8(arg0Value, arg1Value, arg2Value, self__, exception_);
            }

            @Override
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                BranchProfile exception_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0 && (exception_ = this.exception) != null) {
                    Cached self__ = this;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI16(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI16Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI16Node_AndSpecialize(byte[] arg0Value, long arg1Value, short arg2Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                Cached self__ = null;
                self__ = this;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 8;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI16(arg0Value, arg1Value, arg2Value, self__, exception_);
            }

            @Override
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                BranchProfile exception_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0 && (exception_ = this.exception) != null) {
                    Cached self__ = this;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI32(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI32Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI32Node_AndSpecialize(byte[] arg0Value, long arg1Value, int arg2Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                Cached self__ = null;
                self__ = this;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 0x10;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI32(arg0Value, arg1Value, arg2Value, self__, exception_);
            }

            @Override
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                BranchProfile exception_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0 && (exception_ = this.exception) != null) {
                    Cached self__ = this;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI64(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI64Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI64Node_AndSpecialize(byte[] arg0Value, long arg1Value, long arg2Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                Cached self__ = null;
                self__ = this;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 0x20;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI64(arg0Value, arg1Value, arg2Value, self__, exception_);
            }

            @Override
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                BranchProfile exception_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0 && (exception_ = this.exception) != null) {
                    Cached self__ = this;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeFloat(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeFloatNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeFloatNode_AndSpecialize(byte[] arg0Value, long arg1Value, float arg2Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                Cached self__ = null;
                self__ = this;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 0x40;
                LLVMManagedAccessDefaults.VirtualAlloc.writeFloat(arg0Value, arg1Value, arg2Value, self__, exception_);
            }

            @Override
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                BranchProfile exception_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMManagedWriteLibraryExports.assertAdopted((Node)((Node)this)));
                byte[] arg0Value = (byte[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x80) != 0 && (exception_ = this.exception) != null) {
                    Cached self__ = this;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeDouble(arg0Value, arg1Value, arg2Value, self__, exception_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeDoubleNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeDoubleNode_AndSpecialize(byte[] arg0Value, long arg1Value, double arg2Value) {
                BranchProfile exception_;
                int state_0 = this.state_0_;
                Cached self__ = null;
                self__ = this;
                BranchProfile exception__shared = this.exception;
                if (exception__shared != null) {
                    exception_ = exception__shared;
                } else {
                    exception_ = BranchProfile.create();
                    if (exception_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.exception == null) {
                    VarHandle.storeStoreFence();
                    this.exception = exception_;
                }
                this.state_0_ = state_0 |= 0x80;
                LLVMManagedAccessDefaults.VirtualAlloc.writeDouble(arg0Value, arg1Value, arg2Value, self__, exception_);
            }

            @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
            @DenyReplace
            private static final class WriteGenericI64WritePointerData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                LLVMNativePointerSupport.ToNativePointerNode toNativePointer_;
                @CompilerDirectives.CompilationFinal
                BranchProfile exception_;

                WriteGenericI64WritePointerData() {
                }
            }
        }
    }
}

