/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropSpecialAccessNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

@GenerateUncached
public abstract class LLVMInteropSpecialAccessNode
extends LLVMNode {
    public abstract Object execute(Object var1, ForeignToLLVM.ForeignToLLVMType var2, LLVMInteropType.Structured var3, long var4);

    protected LLVMInteropType.SpecialStructAccessor notNullOrException(LLVMInteropType.SpecialStruct type, long offset, LLVMInteropType.SpecialStructAccessor accessor) {
        if (accessor == null) {
            throw new LLVMPolyglotException((Node)this, "The type '%s' has no node at offset %d.", type.toDisplayString(false), offset);
        }
        return accessor;
    }

    protected Object doAccess(Object foreign, ForeignToLLVM.ForeignToLLVMType accessType, LLVMInteropType.SpecialStruct type, long offset, LLVMInteropType.SpecialStructAccessor accessor, ToLLVM toLLVM, BranchProfile exception1, BranchProfile exception2, BranchProfile exception3, InteropLibrary interop) {
        if (accessor == null) {
            exception1.enter();
            throw new LLVMPolyglotException((Node)this, "The type '%s' has no node at offset %d.", type.toDisplayString(false), offset);
        }
        if (accessor.type instanceof LLVMInteropType.Value) {
            try {
                return toLLVM.executeWithType(accessor.getter.get(foreign, interop), (LLVMInteropType.Value)accessor.type, accessType);
            }
            catch (UnsupportedMessageException ex) {
                exception3.enter();
                throw new LLVMPolyglotException(this, "Special read failed with unsupported message exception.");
            }
        }
        exception2.enter();
        throw new LLVMPolyglotException((Node)this, "Special read of type '%s' is not supported.", accessor.type.toDisplayString(false));
    }

    @CompilerDirectives.TruffleBoundary
    LLVMInteropType.SpecialStructAccessor findAccessor(LLVMInteropType.SpecialStruct type, long offset) {
        return type.findAccessor(offset);
    }

    @Specialization(guards={"type == cachedType", "offset == cachedOffset"})
    @GenerateAOT.Exclude
    public Object doSpecialized(Object foreign, ForeignToLLVM.ForeignToLLVMType accessType, LLVMInteropType.SpecialStruct type, long offset, @Cached(value="type") LLVMInteropType.SpecialStruct cachedType, @Cached(value="offset") long cachedOffset, @Cached(value="findAccessor(cachedType, cachedOffset)") LLVMInteropType.SpecialStructAccessor accessor, @Cached ToLLVM toLLVM, @Cached BranchProfile exception1, @Cached BranchProfile exception2, @Cached BranchProfile exception3, @CachedLibrary(limit="3") InteropLibrary interop) {
        return this.doAccess(foreign, accessType, cachedType, cachedOffset, accessor, toLLVM, exception1, exception2, exception3, interop);
    }

    @Specialization(replaces={"doSpecialized"})
    @GenerateAOT.Exclude
    public Object doUnspecialized(Object foreign, ForeignToLLVM.ForeignToLLVMType accessType, LLVMInteropType.SpecialStruct type, long offset, @Cached ToLLVM toLLVM, @Cached BranchProfile exception1, @Cached BranchProfile exception2, @Cached BranchProfile exception3, @CachedLibrary(limit="3") InteropLibrary interop) {
        LLVMInteropType.SpecialStructAccessor accessor = this.findAccessor(type, offset);
        return this.doAccess(foreign, accessType, type, offset, accessor, toLLVM, exception1, exception2, exception3, interop);
    }

    public static LLVMInteropSpecialAccessNode create() {
        return LLVMInteropSpecialAccessNodeGen.create();
    }
}

