/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

public abstract class LLVMAccessForeignObjectNode
extends LLVMNode {
    protected LLVMPolyglotException oob(BranchProfile oobProfile, InvalidBufferOffsetException ex) {
        oobProfile.enter();
        throw new LLVMPolyglotException((Node)this, "Out-of-bounds buffer access (offset %d, length %d)", ex.getByteOffset(), ex.getLength());
    }

    static abstract class OffsetDummy
    extends LLVMNode {
        OffsetDummy() {
        }

        static OffsetDummy create() {
            return null;
        }

        abstract long execute();
    }

    static abstract class ForeignDummy
    extends LLVMNode {
        ForeignDummy() {
        }

        static ForeignDummy create() {
            return null;
        }

        abstract Object execute();
    }

    @GenerateUncached
    static abstract class GetForeignTypeNode
    extends LLVMNode {
        GetForeignTypeNode() {
        }

        public abstract Object execute(LLVMPointer var1);

        @Specialization
        Object doNative(LLVMNativePointer pointer) {
            return null;
        }

        @Specialization(guards={"types.hasNativeType(pointer.getObject())"})
        Object doManagedWithType(LLVMManagedPointer pointer, @CachedLibrary(limit="3") NativeTypeLibrary types) {
            return types.getNativeType(pointer.getObject());
        }

        @Specialization(limit="3", guards={"!types.hasNativeType(pointer.getObject())", "interop.hasBufferElements(pointer.getObject())"})
        @GenerateAOT.Exclude
        LLVMInteropType.Buffer doManagedBuffer(LLVMManagedPointer pointer, @CachedLibrary(value="pointer.getObject()") NativeTypeLibrary types, @CachedLibrary(value="pointer.getObject()") InteropLibrary interop) {
            return LLVMInteropType.BUFFER;
        }

        @Specialization(limit="3", guards={"!types.hasNativeType(pointer.getObject())", "!interop.hasBufferElements(pointer.getObject())"})
        @GenerateAOT.Exclude
        Object doManagedUnknown(LLVMManagedPointer pointer, @CachedLibrary(value="pointer.getObject()") NativeTypeLibrary types, @CachedLibrary(value="pointer.getObject()") InteropLibrary interop) {
            return null;
        }
    }

    @GenerateUncached
    static abstract class ResolveNativePointerNode
    extends LLVMNode {
        ResolveNativePointerNode() {
        }

        final boolean isWrappedAutoDerefHandle(LLVMNativePointerSupport.IsPointerNode isPointerNode, LLVMNativePointerSupport.AsPointerNode asPointerNode, Object obj) {
            try {
                assert (isPointerNode.execute(obj));
                return this.isAutoDerefHandle(asPointerNode.execute(obj));
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        public abstract LLVMPointer execute(Object var1, long var2);

        @Specialization(limit="3", guards={"isPointerNode.execute(receiver)", "!isWrappedAutoDerefHandle(isPointerNode, asPointerNode, receiver)"})
        LLVMNativePointer doPointer(Object receiver, long offset, @Cached LLVMNativePointerSupport.IsPointerNode isPointerNode, @Cached LLVMNativePointerSupport.AsPointerNode asPointerNode) {
            try {
                long addr = asPointerNode.execute(receiver) + offset;
                return LLVMNativePointer.create(addr);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization(limit="3", guards={"isPointerNode.execute(receiver)", "isWrappedAutoDerefHandle(isPointerNode, asPointerNode, receiver)"})
        LLVMManagedPointer doDerefHandle(Object receiver, long offset, @Cached LLVMDerefHandleGetReceiverNode receiverNode, @Cached LLVMNativePointerSupport.IsPointerNode isPointerNode, @Cached LLVMNativePointerSupport.AsPointerNode asPointerNode) {
            try {
                long addr = asPointerNode.execute(receiver) + offset;
                return receiverNode.execute(addr);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization(limit="3", guards={"!isPointerNode.execute(receiver)"})
        LLVMManagedPointer doManaged(Object receiver, long offset, @Cached LLVMNativePointerSupport.IsPointerNode isPointerNode) {
            return LLVMManagedPointer.create(receiver).increment(offset);
        }
    }
}

