/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;

@CompilerDirectives.ValueType
@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=LLVMAsForeignLibrary.class, useForAOT=true, useForAOTPriority=1)})
public final class LLVMNegatedForeignObject
extends LLVMInternalTruffleObject {
    final Object foreign;

    public static Object negate(Object obj) {
        if (obj instanceof LLVMNegatedForeignObject) {
            return ((LLVMNegatedForeignObject)obj).getForeign();
        }
        return new LLVMNegatedForeignObject(obj);
    }

    private LLVMNegatedForeignObject(Object foreign) {
        this.foreign = foreign;
    }

    public Object getForeign() {
        return this.foreign;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LLVMNegatedForeignObject) {
            LLVMNegatedForeignObject other = (LLVMNegatedForeignObject)obj;
            return this.foreign.equals(other.foreign);
        }
        return false;
    }

    public int hashCode() {
        return -this.foreign.hashCode();
    }

    @ExportMessage
    boolean isNull(@CachedLibrary(value="this.foreign") InteropLibrary interop) {
        return interop.isNull(this.getForeign());
    }

    @ExportMessage
    boolean isPointer(@CachedLibrary(value="this.foreign") InteropLibrary interop) {
        return interop.isPointer(this.getForeign());
    }

    @ExportMessage
    long asPointer(@CachedLibrary(value="this.foreign") InteropLibrary interop) throws UnsupportedMessageException {
        return -interop.asPointer(this.getForeign());
    }

    @ExportMessage
    void toNative(@CachedLibrary(value="this.foreign") InteropLibrary interop) {
        interop.toNative(this.getForeign());
    }

    @ExportMessage
    public static boolean isForeign(LLVMNegatedForeignObject receiver) {
        return false;
    }
}

