/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMSyscallEntry;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import com.oracle.truffle.llvm.runtime.inlineasm.InlineAssemblyParserBase;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVAListNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorage;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.List;

public abstract class PlatformCapability<S extends Enum<S>>
implements LLVMCapability {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final S[] valueToSysCall;

    public abstract ByteOrder getPlatformByteOrder();

    public abstract Path getSulongLibrariesPath();

    public abstract String[] getSulongDefaultLibraries();

    public abstract LLVMSyscallOperationNode createSyscallNode(long var1);

    public abstract String getBuiltinsLibrary();

    public abstract String getLibraryPrefix();

    public abstract String getLibrarySuffix();

    public abstract String getLibrarySuffixVersioned(int var1);

    public String getLibrary(String libname) {
        return this.getLibraryPrefix() + libname + "." + this.getLibrarySuffix();
    }

    public String getLibraryVersioned(String libname, int version) {
        return this.getLibraryPrefix() + libname + "." + this.getLibrarySuffixVersioned(version);
    }

    public abstract boolean isGlobalDLOpenFlagSet(int var1);

    public abstract boolean isFirstDLOpenFlagSet(int var1);

    public abstract boolean isLazyDLOpenFlagSet(int var1);

    public abstract boolean isDefaultDLSymFlagSet(long var1);

    protected PlatformCapability(Class<S> cls) {
        this.valueToSysCall = this.initTable(cls);
    }

    public void initializeThread(LLVMContext context, Thread thread) {
    }

    public void disposeThread(LLVMContext context, Thread thread) {
        context.getpThreadContext().callDestructors(context, thread.getId());
    }

    private S[] initTable(Class<S> cls) {
        Enum[] constants = (Enum[])cls.getEnumConstants();
        if (constants == null) {
            return (Enum[])Array.newInstance(cls, 0);
        }
        int max = -1;
        for (Enum syscall : constants) {
            max = Math.max(max, ((LLVMSyscallEntry)((Object)syscall)).value());
        }
        Enum[] syscalls = (Enum[])Array.newInstance(cls, max + 1);
        Enum[] enumArray = constants;
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum syscall;
            syscalls[((LLVMSyscallEntry)((Object)syscall)).value()] = syscall = enumArray[i];
        }
        return syscalls;
    }

    protected S getSyscall(long value) {
        S syscall;
        if (value >= 0L && value < (long)this.valueToSysCall.length && (syscall = this.valueToSysCall[(int)value]) != null) {
            return syscall;
        }
        throw PlatformCapability.error(value);
    }

    @CompilerDirectives.TruffleBoundary
    private static IllegalArgumentException error(long value) {
        return new IllegalArgumentException("Unknown syscall number: " + value);
    }

    public List<String> preprocessDependencies(LLVMContext context, String libraryName, boolean isInternal, List<String> dependencies) {
        return dependencies;
    }

    public abstract Object createVAListStorage(LLVMVAListNode var1, LLVMPointer var2, Type var3);

    public final boolean isManagedVAListType(Type type) {
        Type global = this.getGlobalVAListType(type);
        return global != null && type != global;
    }

    public final boolean isVAListTypeInstanceForToNative(Type type) {
        Type global = this.getGlobalVAListType(type);
        return global != null && type == global;
    }

    public Object createActualVAListStorage() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    public abstract Type getGlobalVAListType(Type var1);

    public int getVAListAlignment() {
        return 16;
    }

    public abstract LLVMVaListStorage.VAListPointerWrapperFactory createNativeVAListWrapper(boolean var1);

    public abstract InlineAssemblyParserBase getInlineAssemblyParser();

    public abstract InternalResource.OS getOS();

    public abstract InternalResource.CPUArchitecture getArch();

    public abstract int getDoubleLongSize();
}

