/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptorFactory;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObjectGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=LLVMFunctionDescriptor.class)
public final class LLVMFunctionDescriptorGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LLVMFunctionDescriptorGen() {
    }

    private static void init() {
    }

    static {
        LibraryExport.register(LLVMFunctionDescriptor.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new LLVMNativeLibraryExports(), new LLVMAsForeignLibraryExports()});
    }

    @GeneratedBy(value=LLVMFunctionDescriptor.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMFunctionDescriptor.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMFunctionDescriptor);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMFunctionDescriptor);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMFunctionDescriptor.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Uncached {
            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                return LLVMFunctionDescriptor.Execute.doPolymorphic(arg0Value, arg1Value, IndirectCallNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                if (arg1Value == "createNativeClosure" && LLVMFunctionDescriptor.getCtxExtKey() != null) {
                    return LLVMFunctionDescriptor.IsMemberReadable.doCreate(arg0Value, arg1Value, (Node)this, LLVMFunctionDescriptor.getCtxExtKey());
                }
                if ("createNativeClosure".equals(arg1Value) && LLVMFunctionDescriptor.getCtxExtKey() != null) {
                    return LLVMFunctionDescriptor.IsMemberReadable.doEqualsCheck(arg0Value, arg1Value, (Node)this, LLVMFunctionDescriptor.getCtxExtKey());
                }
                return LLVMFunctionDescriptor.IsMemberReadable.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                if (arg1Value == "createNativeClosure" && LLVMFunctionDescriptor.getCtxExtKey() != null) {
                    return LLVMFunctionDescriptor.IsMemberReadable.doCreate(arg0Value, arg1Value, (Node)this, LLVMFunctionDescriptor.getCtxExtKey());
                }
                if ("createNativeClosure".equals(arg1Value) && LLVMFunctionDescriptor.getCtxExtKey() != null) {
                    return LLVMFunctionDescriptor.IsMemberReadable.doEqualsCheck(arg0Value, arg1Value, (Node)this, LLVMFunctionDescriptor.getCtxExtKey());
                }
                return LLVMFunctionDescriptor.IsMemberReadable.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                if (arg1Value == "createNativeClosure") {
                    return LLVMFunctionDescriptor.InvokeMember.doCreate(arg0Value, arg1Value, arg2Value, (Node)this, LLVMFunctionDescriptorFactory.CreateNativeClosureNodeGen.getUncached());
                }
                if ("createNativeClosure".equals(arg1Value)) {
                    return LLVMFunctionDescriptor.InvokeMember.doEqualsCheck(arg0Value, arg1Value, arg2Value, (Node)this, LLVMFunctionDescriptorFactory.CreateNativeClosureNodeGen.getUncached());
                }
                return LLVMFunctionDescriptor.InvokeMember.doOther(arg0Value, arg1Value, arg2Value);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                if (arg1Value == "createNativeClosure" && LLVMFunctionDescriptor.getCtxExtKey() != null) {
                    return LLVMFunctionDescriptor.ReadMember.doCreate(arg0Value, arg1Value, (Node)this, LLVMFunctionDescriptor.getCtxExtKey(), InlinedBranchProfile.getUncached());
                }
                if ("createNativeClosure".equals(arg1Value) && LLVMFunctionDescriptor.getCtxExtKey() != null) {
                    return LLVMFunctionDescriptor.ReadMember.doEqualsCheck(arg0Value, arg1Value, (Node)this, LLVMFunctionDescriptor.getCtxExtKey(), InlinedBranchProfile.getUncached());
                }
                return LLVMFunctionDescriptor.ReadMember.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                return arg0Value.asPointer(BranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((LLVMFunctionDescriptor)receiver).toNative();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isExecutable();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isInstantiable();
            }

            @CompilerDirectives.TruffleBoundary
            public Object instantiate(Object arg0Value_, Object ... arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                return arg0Value.instantiate(arg1Value, IndirectCallNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasExecutableName(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).hasExecutableName();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getExecutableName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).getExecutableName();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).hasSourceLocation();
            }

            @CompilerDirectives.TruffleBoundary
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).getSourceLocation();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                return arg0Value.getMembers(arg1Value, (Node)this, LLVMFunctionDescriptor.getCtxExtKey());
            }
        }

        @GeneratedBy(value=LLVMFunctionDescriptor.class)
        private static final class Cached
        extends LLVMInternalTruffleObjectGen.InteropLibraryExports.Cached {
            private static final InlineSupport.StateField CREATE_READ_MEMBER_CREATE_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)ReadMemberCreateData.lookup_(), (String)"create_state_0_");
            private static final InlinedBranchProfile INLINED_READ_MEMBER_CREATE_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CREATE_READ_MEMBER_CREATE_STATE_0_UPDATER.subUpdater(0, 1)}));
            private static final InlineSupport.StateField EQUALS_CHECK_READ_MEMBER_EQUALS_CHECK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)ReadMemberEqualsCheckData.lookup_(), (String)"equalsCheck_state_0_");
            private static final InlinedBranchProfile INLINED_READ_MEMBER_EQUALS_CHECK_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{EQUALS_CHECK_READ_MEMBER_EQUALS_CHECK_STATE_0_UPDATER.subUpdater(2, 1)}));
            static final InlineSupport.ReferenceField<ExecuteDescriptorData> EXECUTE_DESCRIPTOR_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"execute_descriptor_cache", ExecuteDescriptorData.class);
            static final InlineSupport.ReferenceField<ExecuteCachedData> EXECUTE_CACHED_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"execute_cached_cache", ExecuteCachedData.class);
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private ExecuteDescriptorData execute_descriptor_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private ExecuteCachedData execute_cached_cache;
            @Node.Child
            private IndirectCallNode execute_polymorphic_call_;
            @CompilerDirectives.CompilationFinal
            private IsMemberReadableCreateData isMemberReadable_create_cache;
            @CompilerDirectives.CompilationFinal
            private IsMemberReadableEqualsCheckData isMemberReadable_equalsCheck_cache;
            @Node.Child
            private LLVMFunctionDescriptor.CreateNativeClosureNode invokeMember_create_createNativeClosure_;
            @Node.Child
            private LLVMFunctionDescriptor.CreateNativeClosureNode invokeMember_equalsCheck_createNativeClosure_;
            @Node.Child
            private ReadMemberCreateData readMember_create_cache;
            @Node.Child
            private ReadMemberEqualsCheckData readMember_equalsCheck_cache;
            @CompilerDirectives.CompilationFinal
            private BranchProfile asPointerNode__asPointer_exception_;
            @Node.Child
            private IndirectCallNode instantiateNode__instantiate_call_;
            @CompilerDirectives.CompilationFinal
            private GetMembersNode_GetMembersData getMembersNode__getMembers_cache;

            protected Cached(Object receiver) {
                super(receiver);
            }

            @ExplodeLoop
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    IndirectCallNode call__;
                    if ((state_0 & 1) != 0) {
                        ExecuteDescriptorData s0_ = this.execute_descriptor_cache;
                        while (s0_ != null) {
                            if (arg0Value == s0_.cachedSelf_) {
                                assert (DSLSupport.assertIdempotence((boolean)LLVMLanguage.isSingleContext(s0_)));
                                return LLVMFunctionDescriptor.Execute.doDescriptor(arg0Value, arg1Value, s0_.cachedSelf_, s0_.call_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        ExecuteCachedData s1_ = this.execute_cached_cache;
                        while (s1_ != null) {
                            if (arg0Value.getFunctionCode() == s1_.cachedFunctionCode_) {
                                return LLVMFunctionDescriptor.Execute.doCached(arg0Value, arg1Value, s1_.cachedFunctionCode_, s1_.call_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0 && (call__ = this.execute_polymorphic_call_) != null) {
                        return LLVMFunctionDescriptor.Execute.doPolymorphic(arg0Value, arg1Value, call__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(LLVMFunctionDescriptor arg0Value, Object[] arg1Value) {
                int state_0;
                block13: {
                    ExecuteDescriptorData s0_;
                    block9: {
                        block10: {
                            block11: {
                                ExecuteDescriptorData s0_original;
                                state_0 = this.state_0_;
                                if ((state_0 & 6) != 0) break block13;
                                do {
                                    int count0_ = 0;
                                    s0_original = s0_ = (ExecuteDescriptorData)((Object)EXECUTE_DESCRIPTOR_CACHE_UPDATER.getVolatile((Node)this));
                                    while (s0_ != null) {
                                        if (arg0Value == s0_.cachedSelf_) {
                                            assert (DSLSupport.assertIdempotence((boolean)LLVMLanguage.isSingleContext(s0_)));
                                            break;
                                        }
                                        ++count0_;
                                        s0_ = s0_.next_;
                                    }
                                    if (s0_ != null) break block9;
                                    s0_ = (ExecuteDescriptorData)this.insert(new ExecuteDescriptorData(s0_original));
                                    if (!LLVMLanguage.isSingleContext(s0_)) break block10;
                                    if (count0_ >= 5) break block11;
                                    s0_.cachedSelf_ = arg0Value;
                                    s0_.call_ = (DirectCallNode)s0_.insert((Node)LLVMFunctionDescriptor.Execute.createCall(s0_.cachedSelf_));
                                } while (!EXECUTE_DESCRIPTOR_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                                this.state_0_ = state_0 |= 1;
                                break block9;
                            }
                            s0_ = null;
                            break block9;
                        }
                        s0_ = null;
                    }
                    if (s0_ != null) {
                        return LLVMFunctionDescriptor.Execute.doDescriptor(arg0Value, arg1Value, s0_.cachedSelf_, s0_.call_);
                    }
                }
                if ((state_0 & 4) == 0) {
                    ExecuteCachedData s1_;
                    block12: {
                        ExecuteCachedData s1_original;
                        do {
                            int count1_ = 0;
                            s1_original = s1_ = (ExecuteCachedData)((Object)EXECUTE_CACHED_CACHE_UPDATER.getVolatile((Node)this));
                            while (s1_ != null && arg0Value.getFunctionCode() != s1_.cachedFunctionCode_) {
                                ++count1_;
                                s1_ = s1_.next_;
                            }
                            if (s1_ != null) break block12;
                            LLVMFunctionCode cachedFunctionCode__ = arg0Value.getFunctionCode();
                            if (arg0Value.getFunctionCode() != cachedFunctionCode__ || count1_ >= 5) break block12;
                            s1_ = (ExecuteCachedData)this.insert(new ExecuteCachedData(s1_original));
                            s1_.cachedFunctionCode_ = cachedFunctionCode__;
                            s1_.call_ = (DirectCallNode)s1_.insert((Node)LLVMFunctionDescriptor.Execute.createCall(arg0Value));
                        } while (!EXECUTE_CACHED_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                        this.execute_descriptor_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s1_ != null) {
                        return LLVMFunctionDescriptor.Execute.doCached(arg0Value, arg1Value, s1_.cachedFunctionCode_, s1_.call_);
                    }
                }
                VarHandle.storeStoreFence();
                this.execute_polymorphic_call_ = (IndirectCallNode)this.insert((Node)IndirectCallNode.create());
                this.execute_descriptor_cache = null;
                this.execute_cached_cache = null;
                state_0 &= 0xFFFFFFFC;
                this.state_0_ = state_0 |= 4;
                return LLVMFunctionDescriptor.Execute.doPolymorphic(arg0Value, arg1Value, this.execute_polymorphic_call_);
            }

            private boolean isMemberReadableFallbackGuard_(int state_0, LLVMFunctionDescriptor arg0Value, String arg1Value) {
                IsMemberReadableEqualsCheckData s1_ = this.isMemberReadable_equalsCheck_cache;
                return !"createNativeClosure".equals(arg1Value) || s1_ != null && (s1_.equalsCheck_state_0_ & 1) != 0 && s1_.ctxExtKey_ == null;
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x38) != 0) {
                    IsMemberReadableEqualsCheckData s1_;
                    IsMemberReadableCreateData s0_;
                    if ((state_0 & 8) != 0 && (s0_ = this.isMemberReadable_create_cache) != null && arg1Value == "createNativeClosure") {
                        Cached node__ = this;
                        assert (DSLSupport.assertIdempotence((s0_.ctxExtKey_ != null ? 1 : 0) != 0));
                        return LLVMFunctionDescriptor.IsMemberReadable.doCreate(arg0Value, arg1Value, (Node)node__, s0_.ctxExtKey_);
                    }
                    if ((state_0 & 0x10) != 0 && (s1_ = this.isMemberReadable_equalsCheck_cache) != null && (s1_.equalsCheck_state_0_ & 2) != 0 && "createNativeClosure".equals(arg1Value)) {
                        Cached node__1 = this;
                        assert (DSLSupport.assertIdempotence((s1_.ctxExtKey_ != null ? 1 : 0) != 0));
                        return LLVMFunctionDescriptor.IsMemberReadable.doEqualsCheck(arg0Value, arg1Value, (Node)node__1, s1_.ctxExtKey_);
                    }
                    if ((state_0 & 0x20) != 0 && this.isMemberReadableFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return LLVMFunctionDescriptor.IsMemberReadable.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableAndSpecialize(LLVMFunctionDescriptor arg0Value, String arg1Value) {
                ContextExtension.Key<NativeContextExtension> ctxExtKey__;
                int state_0 = this.state_0_;
                Cached node__ = null;
                if ((state_0 & 0x10) == 0 && arg1Value == "createNativeClosure" && (ctxExtKey__ = LLVMFunctionDescriptor.getCtxExtKey()) != null) {
                    IsMemberReadableCreateData s0_ = new IsMemberReadableCreateData();
                    node__ = this;
                    s0_.ctxExtKey_ = ctxExtKey__;
                    VarHandle.storeStoreFence();
                    this.isMemberReadable_create_cache = s0_;
                    this.state_0_ = state_0 |= 8;
                    return LLVMFunctionDescriptor.IsMemberReadable.doCreate(arg0Value, arg1Value, (Node)node__, ctxExtKey__);
                }
                Cached node__1 = null;
                if ("createNativeClosure".equals(arg1Value)) {
                    IsMemberReadableEqualsCheckData s1_ = new IsMemberReadableEqualsCheckData();
                    ContextExtension.Key<NativeContextExtension> ctxExtKey__1 = LLVMFunctionDescriptor.getCtxExtKey();
                    if ((s1_.equalsCheck_state_0_ & 1) == 0) {
                        s1_.ctxExtKey_ = ctxExtKey__1;
                        s1_.equalsCheck_state_0_ |= 1;
                        VarHandle.storeStoreFence();
                        this.isMemberReadable_equalsCheck_cache = s1_;
                        s1_ = new IsMemberReadableEqualsCheckData(s1_);
                    }
                    if (ctxExtKey__1 != null) {
                        node__1 = this;
                        s1_.ctxExtKey_ = ctxExtKey__1;
                        s1_.equalsCheck_state_0_ |= 2;
                        VarHandle.storeStoreFence();
                        this.isMemberReadable_equalsCheck_cache = s1_;
                        this.isMemberReadable_create_cache = null;
                        state_0 &= 0xFFFFFFF7;
                        this.state_0_ = state_0 |= 0x10;
                        return LLVMFunctionDescriptor.IsMemberReadable.doEqualsCheck(arg0Value, arg1Value, (Node)node__1, ctxExtKey__1);
                    }
                }
                this.state_0_ = state_0 |= 0x20;
                return LLVMFunctionDescriptor.IsMemberReadable.doOther(arg0Value, arg1Value);
            }

            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x38) != 0) {
                    IsMemberReadableEqualsCheckData s1_;
                    IsMemberReadableCreateData s0_;
                    if ((state_0 & 8) != 0 && (s0_ = this.isMemberReadable_create_cache) != null && arg1Value == "createNativeClosure") {
                        Cached node__ = this;
                        assert (DSLSupport.assertIdempotence((s0_.ctxExtKey_ != null ? 1 : 0) != 0));
                        return LLVMFunctionDescriptor.IsMemberReadable.doCreate(arg0Value, arg1Value, (Node)node__, s0_.ctxExtKey_);
                    }
                    if ((state_0 & 0x10) != 0 && (s1_ = this.isMemberReadable_equalsCheck_cache) != null && (s1_.equalsCheck_state_0_ & 2) != 0 && "createNativeClosure".equals(arg1Value)) {
                        Cached node__1 = this;
                        assert (DSLSupport.assertIdempotence((s1_.ctxExtKey_ != null ? 1 : 0) != 0));
                        return LLVMFunctionDescriptor.IsMemberReadable.doEqualsCheck(arg0Value, arg1Value, (Node)node__1, s1_.ctxExtKey_);
                    }
                    if ((state_0 & 0x20) != 0 && this.isMemberReadableFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return LLVMFunctionDescriptor.IsMemberReadable.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean invokeMemberFallbackGuard_(int state_0, LLVMFunctionDescriptor arg0Value, String arg1Value, Object[] arg2Value) {
                return (state_0 & 0x80) != 0 || !"createNativeClosure".equals(arg1Value);
            }

            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1C0) != 0) {
                    LLVMFunctionDescriptor.CreateNativeClosureNode createNativeClosure__1;
                    LLVMFunctionDescriptor.CreateNativeClosureNode createNativeClosure__;
                    if ((state_0 & 0x40) != 0 && (createNativeClosure__ = this.invokeMember_create_createNativeClosure_) != null && arg1Value == "createNativeClosure") {
                        Cached node__ = this;
                        return LLVMFunctionDescriptor.InvokeMember.doCreate(arg0Value, arg1Value, arg2Value, (Node)node__, createNativeClosure__);
                    }
                    if ((state_0 & 0x80) != 0 && (createNativeClosure__1 = this.invokeMember_equalsCheck_createNativeClosure_) != null && "createNativeClosure".equals(arg1Value)) {
                        Cached node__1 = this;
                        return LLVMFunctionDescriptor.InvokeMember.doEqualsCheck(arg0Value, arg1Value, arg2Value, (Node)node__1, createNativeClosure__1);
                    }
                    if ((state_0 & 0x100) != 0 && this.invokeMemberFallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                        return LLVMFunctionDescriptor.InvokeMember.doOther(arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberAndSpecialize(LLVMFunctionDescriptor arg0Value, String arg1Value, Object[] arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException {
                int state_0 = this.state_0_;
                Cached node__ = null;
                if ((state_0 & 0x80) == 0 && arg1Value == "createNativeClosure") {
                    node__ = this;
                    LLVMFunctionDescriptor.CreateNativeClosureNode createNativeClosure__ = (LLVMFunctionDescriptor.CreateNativeClosureNode)this.insert(LLVMFunctionDescriptorFactory.CreateNativeClosureNodeGen.create());
                    Objects.requireNonNull(createNativeClosure__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.invokeMember_create_createNativeClosure_ = createNativeClosure__;
                    this.state_0_ = state_0 |= 0x40;
                    return LLVMFunctionDescriptor.InvokeMember.doCreate(arg0Value, arg1Value, arg2Value, (Node)node__, createNativeClosure__);
                }
                Cached node__1 = null;
                if ("createNativeClosure".equals(arg1Value)) {
                    node__1 = this;
                    LLVMFunctionDescriptor.CreateNativeClosureNode createNativeClosure__1 = (LLVMFunctionDescriptor.CreateNativeClosureNode)this.insert(LLVMFunctionDescriptorFactory.CreateNativeClosureNodeGen.create());
                    Objects.requireNonNull(createNativeClosure__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.invokeMember_equalsCheck_createNativeClosure_ = createNativeClosure__1;
                    this.invokeMember_create_createNativeClosure_ = null;
                    state_0 &= 0xFFFFFFBF;
                    this.state_0_ = state_0 |= 0x80;
                    return LLVMFunctionDescriptor.InvokeMember.doEqualsCheck(arg0Value, arg1Value, arg2Value, (Node)node__1, createNativeClosure__1);
                }
                this.state_0_ = state_0 |= 0x100;
                return LLVMFunctionDescriptor.InvokeMember.doOther(arg0Value, arg1Value, arg2Value);
            }

            private boolean readMemberFallbackGuard_(int state_0, LLVMFunctionDescriptor arg0Value, String arg1Value) {
                ReadMemberEqualsCheckData s1_ = this.readMember_equalsCheck_cache;
                return !"createNativeClosure".equals(arg1Value) || s1_ != null && (s1_.equalsCheck_state_0_ & 1) != 0 && s1_.ctxExtKey_ == null;
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xE00) != 0) {
                    ReadMemberEqualsCheckData s1_;
                    ReadMemberCreateData s0_;
                    if ((state_0 & 0x200) != 0 && (s0_ = this.readMember_create_cache) != null && arg1Value == "createNativeClosure") {
                        ReadMemberCreateData node__ = s0_;
                        assert (DSLSupport.assertIdempotence((s0_.ctxExtKey_ != null ? 1 : 0) != 0));
                        return LLVMFunctionDescriptor.ReadMember.doCreate(arg0Value, arg1Value, node__, s0_.ctxExtKey_, INLINED_READ_MEMBER_CREATE_EXCEPTION_);
                    }
                    if ((state_0 & 0x400) != 0 && (s1_ = this.readMember_equalsCheck_cache) != null && (s1_.equalsCheck_state_0_ & 2) != 0 && "createNativeClosure".equals(arg1Value)) {
                        ReadMemberEqualsCheckData node__1 = s1_;
                        assert (DSLSupport.assertIdempotence((s1_.ctxExtKey_ != null ? 1 : 0) != 0));
                        return LLVMFunctionDescriptor.ReadMember.doEqualsCheck(arg0Value, arg1Value, node__1, s1_.ctxExtKey_, INLINED_READ_MEMBER_EQUALS_CHECK_EXCEPTION_);
                    }
                    if ((state_0 & 0x800) != 0 && this.readMemberFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return LLVMFunctionDescriptor.ReadMember.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberAndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberAndSpecialize(LLVMFunctionDescriptor arg0Value, String arg1Value) throws UnknownIdentifierException {
                ContextExtension.Key<NativeContextExtension> ctxExtKey__;
                int state_0 = this.state_0_;
                ReadMemberCreateData node__ = null;
                if ((state_0 & 0x400) == 0 && arg1Value == "createNativeClosure" && (ctxExtKey__ = LLVMFunctionDescriptor.getCtxExtKey()) != null) {
                    ReadMemberCreateData s0_;
                    node__ = s0_ = (ReadMemberCreateData)this.insert(new ReadMemberCreateData());
                    s0_.ctxExtKey_ = ctxExtKey__;
                    VarHandle.storeStoreFence();
                    this.readMember_create_cache = s0_;
                    this.state_0_ = state_0 |= 0x200;
                    return LLVMFunctionDescriptor.ReadMember.doCreate(arg0Value, arg1Value, node__, ctxExtKey__, INLINED_READ_MEMBER_CREATE_EXCEPTION_);
                }
                ReadMemberEqualsCheckData node__1 = null;
                if ("createNativeClosure".equals(arg1Value)) {
                    ReadMemberEqualsCheckData s1_ = (ReadMemberEqualsCheckData)this.insert(new ReadMemberEqualsCheckData());
                    ContextExtension.Key<NativeContextExtension> ctxExtKey__1 = LLVMFunctionDescriptor.getCtxExtKey();
                    if ((s1_.equalsCheck_state_0_ & 1) == 0) {
                        s1_.ctxExtKey_ = ctxExtKey__1;
                        s1_.equalsCheck_state_0_ |= 1;
                        VarHandle.storeStoreFence();
                        this.readMember_equalsCheck_cache = s1_;
                        s1_ = (ReadMemberEqualsCheckData)this.insert(new ReadMemberEqualsCheckData(s1_));
                    }
                    if (ctxExtKey__1 != null) {
                        node__1 = s1_;
                        s1_.ctxExtKey_ = ctxExtKey__1;
                        s1_.equalsCheck_state_0_ |= 2;
                        VarHandle.storeStoreFence();
                        this.readMember_equalsCheck_cache = s1_;
                        this.readMember_create_cache = null;
                        state_0 &= 0xFFFFFDFF;
                        this.state_0_ = state_0 |= 0x400;
                        return LLVMFunctionDescriptor.ReadMember.doEqualsCheck(arg0Value, arg1Value, node__1, ctxExtKey__1, INLINED_READ_MEMBER_EQUALS_CHECK_EXCEPTION_);
                    }
                }
                this.state_0_ = state_0 |= 0x800;
                return LLVMFunctionDescriptor.ReadMember.doOther(arg0Value, arg1Value);
            }

            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                BranchProfile exception__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000) != 0 && (exception__ = this.asPointerNode__asPointer_exception_) != null) {
                    return arg0Value.asPointer(exception__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asPointerNode_AndSpecialize(arg0Value);
            }

            private long asPointerNode_AndSpecialize(LLVMFunctionDescriptor arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                BranchProfile exception__ = BranchProfile.create();
                Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.asPointerNode__asPointer_exception_ = exception__;
                this.state_0_ = state_0 |= 0x1000;
                return arg0Value.asPointer(exception__);
            }

            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).isPointer();
            }

            public void toNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((LLVMFunctionDescriptor)receiver).toNative();
            }

            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).isExecutable();
            }

            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).isInstantiable();
            }

            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                IndirectCallNode call__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000) != 0 && (call__ = this.instantiateNode__instantiate_call_) != null) {
                    return arg0Value.instantiate(arg1Value, call__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object instantiateNode_AndSpecialize(LLVMFunctionDescriptor arg0Value, Object[] arg1Value) {
                int state_0 = this.state_0_;
                VarHandle.storeStoreFence();
                this.instantiateNode__instantiate_call_ = (IndirectCallNode)this.insert((Node)IndirectCallNode.create());
                this.state_0_ = state_0 |= 0x2000;
                return arg0Value.instantiate(arg1Value, this.instantiateNode__instantiate_call_);
            }

            public boolean hasExecutableName(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).hasExecutableName();
            }

            public Object getExecutableName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).getExecutableName();
            }

            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).hasSourceLocation();
            }

            @CompilerDirectives.TruffleBoundary
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).getSourceLocation();
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((LLVMFunctionDescriptor)receiver).hasMembers();
            }

            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                GetMembersNode_GetMembersData s0_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x4000) != 0 && (s0_ = this.getMembersNode__getMembers_cache) != null) {
                    Cached node__ = this;
                    return arg0Value.getMembers(arg1Value, (Node)node__, s0_.ctxExtKey_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object getMembersNode_AndSpecialize(LLVMFunctionDescriptor arg0Value, boolean arg1Value) {
                int state_0 = this.state_0_;
                Cached node__ = null;
                GetMembersNode_GetMembersData s0_ = new GetMembersNode_GetMembersData();
                node__ = this;
                s0_.ctxExtKey_ = LLVMFunctionDescriptor.getCtxExtKey();
                VarHandle.storeStoreFence();
                this.getMembersNode__getMembers_cache = s0_;
                this.state_0_ = state_0 |= 0x4000;
                return arg0Value.getMembers(arg1Value, (Node)node__, s0_.ctxExtKey_);
            }

            @GeneratedBy(value=LLVMFunctionDescriptor.class)
            @DenyReplace
            private static final class ExecuteDescriptorData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                ExecuteDescriptorData next_;
                @CompilerDirectives.CompilationFinal
                LLVMFunctionDescriptor cachedSelf_;
                @Node.Child
                DirectCallNode call_;

                ExecuteDescriptorData(ExecuteDescriptorData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=LLVMFunctionDescriptor.class)
            @DenyReplace
            private static final class ExecuteCachedData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                ExecuteCachedData next_;
                @CompilerDirectives.CompilationFinal
                LLVMFunctionCode cachedFunctionCode_;
                @Node.Child
                DirectCallNode call_;

                ExecuteCachedData(ExecuteCachedData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=LLVMFunctionDescriptor.class)
            @DenyReplace
            private static final class IsMemberReadableEqualsCheckData
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                private int equalsCheck_state_0_;
                @CompilerDirectives.CompilationFinal
                ContextExtension.Key<NativeContextExtension> ctxExtKey_;

                IsMemberReadableEqualsCheckData() {
                }

                IsMemberReadableEqualsCheckData(IsMemberReadableEqualsCheckData delegate) {
                    this.equalsCheck_state_0_ = delegate.equalsCheck_state_0_;
                    this.ctxExtKey_ = delegate.ctxExtKey_;
                }
            }

            @GeneratedBy(value=LLVMFunctionDescriptor.class)
            @DenyReplace
            private static final class IsMemberReadableCreateData
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                ContextExtension.Key<NativeContextExtension> ctxExtKey_;

                IsMemberReadableCreateData() {
                }
            }

            @GeneratedBy(value=LLVMFunctionDescriptor.class)
            @DenyReplace
            private static final class ReadMemberEqualsCheckData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int equalsCheck_state_0_;
                @CompilerDirectives.CompilationFinal
                ContextExtension.Key<NativeContextExtension> ctxExtKey_;

                ReadMemberEqualsCheckData() {
                }

                ReadMemberEqualsCheckData(ReadMemberEqualsCheckData delegate) {
                    this.equalsCheck_state_0_ = delegate.equalsCheck_state_0_;
                    this.ctxExtKey_ = delegate.ctxExtKey_;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }

            @GeneratedBy(value=LLVMFunctionDescriptor.class)
            @DenyReplace
            private static final class ReadMemberCreateData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int create_state_0_;
                @CompilerDirectives.CompilationFinal
                ContextExtension.Key<NativeContextExtension> ctxExtKey_;

                ReadMemberCreateData() {
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }

            @GeneratedBy(value=LLVMFunctionDescriptor.class)
            @DenyReplace
            private static final class GetMembersNode_GetMembersData
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                ContextExtension.Key<NativeContextExtension> ctxExtKey_;

                GetMembersNode_GetMembersData() {
                }
            }
        }
    }

    @GeneratedBy(value=LLVMFunctionDescriptor.class)
    private static final class LLVMNativeLibraryExports
    extends LibraryExport<LLVMNativeLibrary> {
        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, LLVMFunctionDescriptor.class, false, false, 0);
        }

        protected LLVMNativeLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMFunctionDescriptor);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected LLVMNativeLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMFunctionDescriptor);
            return new Cached();
        }

        @GeneratedBy(value=LLVMFunctionDescriptor.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMNativeLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMFunctionDescriptor) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMFunctionDescriptor;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                return arg0Value.asPointer(BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isPointer();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                return arg0Value.toNativePointer(this, BranchProfile.getUncached());
            }
        }

        @GeneratedBy(value=LLVMFunctionDescriptor.class)
        private static final class Cached
        extends LLVMNativeLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile asPointerNode__asPointer_exception_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile toNativePointerNode__toNativePointer_exceptionProfile_;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMFunctionDescriptor) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMFunctionDescriptor;
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                BranchProfile exception__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMNativeLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (exception__ = this.asPointerNode__asPointer_exception_) != null) {
                    return arg0Value.asPointer(exception__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asPointerNode_AndSpecialize(arg0Value);
            }

            private long asPointerNode_AndSpecialize(LLVMFunctionDescriptor arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                BranchProfile exception__ = BranchProfile.create();
                Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.asPointerNode__asPointer_exception_ = exception__;
                this.state_0_ = state_0 |= 1;
                return arg0Value.asPointer(exception__);
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMNativeLibraryExports.assertAdopted((Node)((Node)this)));
                return ((LLVMFunctionDescriptor)receiver).isPointer();
            }

            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                BranchProfile exceptionProfile__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (LLVMNativeLibraryExports.assertAdopted((Node)((Node)this)));
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0 && (exceptionProfile__ = this.toNativePointerNode__toNativePointer_exceptionProfile_) != null) {
                    Cached self__ = this;
                    return arg0Value.toNativePointer(self__, exceptionProfile__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.toNativePointerNode_AndSpecialize(arg0Value);
            }

            private LLVMNativePointer toNativePointerNode_AndSpecialize(LLVMFunctionDescriptor arg0Value) {
                int state_0 = this.state_0_;
                Cached self__ = null;
                self__ = this;
                BranchProfile exceptionProfile__ = BranchProfile.create();
                Objects.requireNonNull(exceptionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.toNativePointerNode__toNativePointer_exceptionProfile_ = exceptionProfile__;
                this.state_0_ = state_0 |= 2;
                return arg0Value.toNativePointer(self__, exceptionProfile__);
            }
        }
    }

    @GeneratedBy(value=LLVMFunctionDescriptor.class)
    private static final class LLVMAsForeignLibraryExports
    extends LibraryExport<LLVMAsForeignLibrary> {
        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMFunctionDescriptor.class, false, true, 2);
        }

        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMFunctionDescriptor);
            Uncached uncached = UNCACHED;
            return uncached;
        }

        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMFunctionDescriptor || receiver instanceof LibraryExport);
            return CACHE;
        }

        @GeneratedBy(value=LLVMFunctionDescriptor.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMAsForeignLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMFunctionDescriptor) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMFunctionDescriptor;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMFunctionDescriptor.isForeign((LLVMFunctionDescriptor)receiver);
            }
        }

        @GeneratedBy(value=LLVMFunctionDescriptor.class)
        private static final class Cached
        extends LLVMAsForeignLibrary
        implements UnadoptableNode {
            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMFunctionDescriptor) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMFunctionDescriptor;
            }

            @Override
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMFunctionDescriptor.isForeign((LLVMFunctionDescriptor)receiver);
            }
        }
    }

    @GeneratedBy(value=LLVMFunctionDescriptor.class)
    public static final class LLVMAsForeignLibraryEagerProvider
    implements EagerExportProvider {
        public void ensureRegistered() {
            LLVMFunctionDescriptorGen.init();
        }

        public String getLibraryClassName() {
            return "com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary";
        }
    }
}

