/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public final class CleanupRetInstruction
extends VoidInstruction
implements TerminatingInstruction {
    private SymbolImpl from;
    private final InstructionBlock unwindSuccessor;

    private CleanupRetInstruction(InstructionBlock unwindSuccessor) {
        this.unwindSuccessor = unwindSuccessor;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
        if (this.from == oldValue) {
            this.from = newValue;
        }
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public static CleanupRetInstruction generate(SymbolTable table, int fromIndex, InstructionBlock unwindSuccessor) {
        CleanupRetInstruction l = new CleanupRetInstruction(unwindSuccessor);
        l.from = table.getForwardReferencedOrNull(fromIndex, l);
        return l;
    }

    @Override
    public int getSuccessorCount() {
        return this.unwindSuccessor == null ? 0 : 1;
    }

    @Override
    public InstructionBlock getSuccessor(int index) {
        assert (this.unwindSuccessor != null);
        assert (index == 0);
        return this.unwindSuccessor;
    }
}

