/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class AllocateInstruction
extends ValueInstruction {
    private SymbolImpl count;
    private final int align;

    private AllocateInstruction(Type type, int align) {
        super(type);
        this.align = align;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public int getAlign() {
        return this.align;
    }

    public SymbolImpl getCount() {
        return this.count;
    }

    public Type getPointeeType() {
        return ((PointerType)super.getType()).getPointeeType();
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.count == original) {
            this.count = replacement;
        }
    }

    public static AllocateInstruction fromSymbols(SymbolTable symbols, Type type, int count, int align) {
        AllocateInstruction inst = new AllocateInstruction(type, align);
        inst.count = symbols.getForwardReferenced(count, inst);
        return inst;
    }
}

