/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDVariable;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;

public final class MDGlobalVariable
extends MDVariable
implements MDBaseNode {
    private final boolean isLocalToCompileUnit;
    private final boolean isDefinedInCompileUnit;
    private MDBaseNode displayName;
    private MDBaseNode linkageName;
    private MDBaseNode staticMemberDeclaration;
    private MDBaseNode variable;
    private MDBaseNode compileUnit;
    private static final int ARGINDEX_38_SCOPE = 1;
    private static final int ARGINDEX_38_NAME = 2;
    private static final int ARGINDEX_38_LINKAGENAME = 3;
    private static final int ARGINDEX_38_FILE = 4;
    private static final int ARGINDEX_38_LINE = 5;
    private static final int ARGINDEX_38_TYPE = 6;
    private static final int ARGINDEX_38_LOCALTOCOMPILEUNIT = 7;
    private static final int ARGINDEX_38_DEFINEDINCOMPILEUNIT = 8;
    private static final int ARGINDEX_32_SCOPE = 2;
    private static final int ARGINDEX_32_NAME = 3;
    private static final int ARGINDEX_32_DISPLAYNAME = 4;
    private static final int ARGINDEX_32_LINKAGENAME = 5;
    private static final int ARGINDEX_32_FILE = 6;
    private static final int ARGINDEX_32_LINE = 7;
    private static final int ARGINDEX_32_TYPE = 8;
    private static final int ARGINDEX_32_LOCALTOCOMPILEUNIT = 9;
    private static final int ARGINDEX_32_DEFINEDINCOMPILEUNIT = 10;
    private static final int ARGINDEX_32_VARIABLE = 11;

    private MDGlobalVariable(long line, boolean isLocalToCompileUnit, boolean isDefinedInCompileUnit) {
        super(line);
        this.isLocalToCompileUnit = isLocalToCompileUnit;
        this.isDefinedInCompileUnit = isDefinedInCompileUnit;
        this.displayName = MDVoidNode.INSTANCE;
        this.linkageName = MDVoidNode.INSTANCE;
        this.staticMemberDeclaration = MDVoidNode.INSTANCE;
        this.variable = MDVoidNode.INSTANCE;
        this.compileUnit = MDVoidNode.INSTANCE;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public MDBaseNode getDisplayName() {
        return this.displayName;
    }

    public MDBaseNode getLinkageName() {
        return this.linkageName;
    }

    public boolean isLocalToCompileUnit() {
        return this.isLocalToCompileUnit;
    }

    public boolean isDefinedInCompileUnit() {
        return this.isDefinedInCompileUnit;
    }

    public MDBaseNode getStaticMemberDeclaration() {
        return this.staticMemberDeclaration;
    }

    public MDBaseNode getVariable() {
        return this.variable;
    }

    public MDBaseNode getCompileUnit() {
        return this.compileUnit;
    }

    public void setCompileUnit(MDBaseNode compileUnit) {
        this.compileUnit = compileUnit;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.displayName == oldValue) {
            this.displayName = newValue;
        }
        if (this.linkageName == oldValue) {
            this.linkageName = newValue;
        }
        if (this.staticMemberDeclaration == oldValue) {
            this.staticMemberDeclaration = newValue;
        }
        if (this.variable == oldValue) {
            this.variable = newValue;
        }
        if (this.compileUnit == oldValue) {
            this.compileUnit = newValue;
        }
    }

    public static MDGlobalVariable create38(long[] args, MetadataValueList md) {
        long version = args[0] >> 1;
        long line = args[5];
        boolean localToCompileUnit = args[7] == 1L;
        boolean definedInCompileUnit = args[8] == 1L;
        MDGlobalVariable globalVariable = new MDGlobalVariable(line, localToCompileUnit, definedInCompileUnit);
        globalVariable.setScope(md.getNullable(args[1], globalVariable));
        globalVariable.setFile(md.getNullable(args[4], globalVariable));
        globalVariable.setType(md.getNullable(args[6], globalVariable));
        MDBaseNode name = md.getNullable(args[2], globalVariable);
        globalVariable.setName(name);
        globalVariable.displayName = name;
        if (version == 2L) {
            globalVariable.staticMemberDeclaration = md.getNullable(args[9], globalVariable);
        } else {
            globalVariable.staticMemberDeclaration = md.getNullable(args[10], globalVariable);
            globalVariable.variable = md.getNullable(args[9], globalVariable);
        }
        globalVariable.linkageName = md.getNullable(args[3], globalVariable);
        return globalVariable;
    }

    public static MDGlobalVariable create32(long[] args, Metadata md) {
        long line = ParseUtil.asInt(args, 7, md);
        boolean localToCompileUnit = ParseUtil.asBoolean(args, 9, md);
        boolean inCompileUnit = ParseUtil.asBoolean(args, 10, md);
        MDGlobalVariable globalVariable = new MDGlobalVariable(line, localToCompileUnit, inCompileUnit);
        globalVariable.setScope(ParseUtil.resolveReference(args, 2, globalVariable, md));
        globalVariable.setFile(ParseUtil.resolveReference(args, 6, globalVariable, md));
        globalVariable.setType(ParseUtil.resolveReference(args, 8, globalVariable, md));
        globalVariable.setName(ParseUtil.resolveReference(args, 3, globalVariable, md));
        globalVariable.displayName = ParseUtil.resolveReference(args, 4, globalVariable, md);
        globalVariable.linkageName = ParseUtil.resolveReference(args, 5, globalVariable, md);
        globalVariable.variable = ParseUtil.resolveSymbol(args, 11, md);
        return globalVariable;
    }
}

