/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;
import com.oracle.truffle.llvm.runtime.types.DwLangNameRecord;

public final class MDCompileUnit
implements MDBaseNode {
    private final DwLangNameRecord language;
    private final boolean isOptimized;
    private final long runtimeVersion;
    private final long emissionKind;
    private final long dwoId;
    private MDBaseNode file;
    private MDBaseNode directory;
    private MDBaseNode producer;
    private MDBaseNode flags;
    private MDBaseNode splitdebugFilename;
    private MDBaseNode enums;
    private MDBaseNode retainedTypes;
    private MDBaseNode subprograms;
    private MDBaseNode globalVariables;
    private MDBaseNode importedEntities;
    private MDBaseNode macros;
    private static final int ARGINDEX_38_LANGUAGE = 1;
    private static final int ARGINDEX_38_FILE = 2;
    private static final int ARGINDEX_38_PRODUCER = 3;
    private static final int ARGINDEX_38_OPTIMIZED = 4;
    private static final int ARGINDEX_38_FLAGS = 5;
    private static final int ARGINDEX_38_RUNTIMEVERSION = 6;
    private static final int ARGINDEX_38_SPLITDEBUGFILENAME = 7;
    private static final int ARGINDEX_38_EMISSIONKIND = 8;
    private static final int ARGINDEX_38_ENUMS = 9;
    private static final int ARGINDEX_38_RETAINEDTYPES = 10;
    private static final int ARGINDEX_38_SUBPROGRAMS = 11;
    private static final int ARGINDEX_38_GLOBALVARIABLES = 12;
    private static final int ARGINDEX_38_IMPORTEDENTITIES = 13;
    private static final int ARGINDEX_38_DWOID = 14;
    private static final int ARGINDEX_38_MACROS = 15;
    private static final int ARGINDEX_32_LANGUAGE = 2;
    private static final int ARGINDEX_32_FILE = 3;
    private static final int ARGINDEX_32_DIRECTORY = 4;
    private static final int ARGINDEX_32_PRODUCER = 5;
    private static final int ARGINDEX_32_OPTIMIZED = 7;
    private static final int ARGINDEX_32_FLAGS = 8;
    private static final int ARGINDEX_32_RUNTIMEVERSION = 9;
    private static final int ARGINDEX_32_ENUMS = 10;
    private static final int ARGINDEX_32_RETAINEDTYPES = 11;
    private static final int ARGINDEX_32_SUBPROGRAMS = 12;
    private static final int ARGINDEX_32_GLOBALVARIABLES = 13;

    private MDCompileUnit(DwLangNameRecord language, boolean isOptimized, long runtimeVersion, long emissionKind, long dwoId) {
        this.language = language;
        this.isOptimized = isOptimized;
        this.runtimeVersion = runtimeVersion;
        this.emissionKind = emissionKind;
        this.dwoId = dwoId;
        this.file = MDVoidNode.INSTANCE;
        this.directory = MDVoidNode.INSTANCE;
        this.producer = MDVoidNode.INSTANCE;
        this.flags = MDVoidNode.INSTANCE;
        this.splitdebugFilename = MDVoidNode.INSTANCE;
        this.enums = MDVoidNode.INSTANCE;
        this.retainedTypes = MDVoidNode.INSTANCE;
        this.subprograms = MDVoidNode.INSTANCE;
        this.globalVariables = MDVoidNode.INSTANCE;
        this.importedEntities = MDVoidNode.INSTANCE;
        this.macros = MDVoidNode.INSTANCE;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public DwLangNameRecord getLanguage() {
        return this.language;
    }

    public MDBaseNode getFile() {
        return this.file;
    }

    public MDBaseNode getDirectory() {
        return this.directory;
    }

    public MDBaseNode getProducer() {
        return this.producer;
    }

    public boolean isOptimized() {
        return this.isOptimized;
    }

    public MDBaseNode getFlags() {
        return this.flags;
    }

    public long getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public MDBaseNode getEnums() {
        return this.enums;
    }

    public MDBaseNode getRetainedTypes() {
        return this.retainedTypes;
    }

    public MDBaseNode getSubprograms() {
        return this.subprograms;
    }

    public MDBaseNode getGlobalVariables() {
        return this.globalVariables;
    }

    public MDBaseNode getSplitdebugFilename() {
        return this.splitdebugFilename;
    }

    public long getEmissionKind() {
        return this.emissionKind;
    }

    public MDBaseNode getImportedEntities() {
        return this.importedEntities;
    }

    public MDBaseNode getMacros() {
        return this.macros;
    }

    public long getDwoId() {
        return this.dwoId;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        if (this.file == oldValue) {
            this.file = newValue;
        }
        if (this.directory == oldValue) {
            this.directory = newValue;
        }
        if (this.producer == oldValue) {
            this.producer = newValue;
        }
        if (this.flags == oldValue) {
            this.flags = newValue;
        }
        if (this.splitdebugFilename == oldValue) {
            this.splitdebugFilename = newValue;
        }
        if (this.enums == oldValue) {
            this.enums = newValue;
        }
        if (this.retainedTypes == oldValue) {
            this.retainedTypes = newValue;
        }
        if (this.subprograms == oldValue) {
            this.subprograms = newValue;
        }
        if (this.globalVariables == oldValue) {
            this.globalVariables = newValue;
        }
        if (this.importedEntities == oldValue) {
            this.importedEntities = newValue;
        }
        if (this.macros == oldValue) {
            this.macros = newValue;
        }
    }

    public static MDCompileUnit create38(long[] args, MetadataValueList md) {
        DwLangNameRecord language = DwLangNameRecord.decode(args[1]);
        boolean optimized = args[4] == 1L;
        long runtimeVersion = args[6];
        long emissionKind = args[8];
        long dwoId = args.length > 14 ? args[14] : 0L;
        MDCompileUnit compileUnit = new MDCompileUnit(language, optimized, runtimeVersion, emissionKind, dwoId);
        compileUnit.file = md.getNullable(args[2], compileUnit);
        compileUnit.producer = md.getNullable(args[3], compileUnit);
        compileUnit.flags = md.getNullable(args[5], compileUnit);
        compileUnit.splitdebugFilename = md.getNullable(args[7], compileUnit);
        compileUnit.enums = md.getNullable(args[9], compileUnit);
        compileUnit.retainedTypes = md.getNullable(args[10], compileUnit);
        compileUnit.subprograms = md.getNullable(args[11], compileUnit);
        compileUnit.globalVariables = md.getNullable(args[12], compileUnit);
        compileUnit.importedEntities = md.getNullable(args[13], compileUnit);
        if (args.length > 15) {
            compileUnit.macros = md.getNullable(args[15], compileUnit);
        }
        return compileUnit;
    }

    public static MDCompileUnit create32(long[] args, Metadata md) {
        DwLangNameRecord language = DwLangNameRecord.decode(ParseUtil.asInt(args, 2, md));
        boolean optimized = ParseUtil.asBoolean(args, 7, md);
        long runtimeVersion = ParseUtil.asInt(args, 9, md);
        MDCompileUnit compileUnit = new MDCompileUnit(language, optimized, runtimeVersion, -1L, -1L);
        compileUnit.file = ParseUtil.resolveReference(args, 3, compileUnit, md);
        compileUnit.directory = ParseUtil.resolveReference(args, 4, compileUnit, md);
        compileUnit.producer = ParseUtil.resolveReference(args, 5, compileUnit, md);
        compileUnit.flags = ParseUtil.resolveReference(args, 8, compileUnit, md);
        compileUnit.enums = ParseUtil.resolveReference(args, 10, compileUnit, md);
        compileUnit.retainedTypes = ParseUtil.resolveReference(args, 11, compileUnit, md);
        compileUnit.subprograms = ParseUtil.resolveReference(args, 12, compileUnit, md);
        compileUnit.globalVariables = ParseUtil.resolveReference(args, 13, compileUnit, md);
        return compileUnit;
    }
}

