/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.llvm.parser.factories.BasicAMD64PlatformCapability;
import com.oracle.truffle.llvm.runtime.LLVMSyscallEntry;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMUnsupportedSyscallNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVAListNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86_win.LLVMX86_64_WinVaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86_win.LLVMX86_64_WinVaListStorageFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMMaybeVaPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.Type;

final class WindowsAMD64PlatformCapability
extends BasicAMD64PlatformCapability<UnknownSyscalls> {
    WindowsAMD64PlatformCapability(boolean loadCxxLibraries) {
        super(UnknownSyscalls.class, loadCxxLibraries);
    }

    @Override
    public String[] getSulongDefaultLibraries() {
        return new String[]{this.getLibsulongFilename(), this.getLibsulongxxFilename()};
    }

    @Override
    public LLVMSyscallOperationNode createSyscallNode(long index) {
        return LLVMUnsupportedSyscallNode.create(index);
    }

    @Override
    protected LLVMSyscallOperationNode createSyscallNode(UnknownSyscalls syscall) {
        return LLVMUnsupportedSyscallNode.create(syscall);
    }

    @Override
    public Object createVAListStorage(LLVMVAListNode allocaNode, LLVMPointer vaListStackPtr, Type vaListType) {
        return LLVMMaybeVaPointer.createWithAlloca(vaListStackPtr, allocaNode);
    }

    @Override
    public Object createActualVAListStorage() {
        return new LLVMX86_64_WinVaListStorage();
    }

    @Override
    public Type getGlobalVAListType(Type type) {
        return PointerType.I8.equals(type) ? PointerType.I8 : null;
    }

    @Override
    public LLVMVaListStorage.VAListPointerWrapperFactory createNativeVAListWrapper(boolean cached) {
        return cached ? LLVMX86_64_WinVaListStorageFactory.PointerWrapperFactoryNodeGen.create() : LLVMX86_64_WinVaListStorageFactory.PointerWrapperFactoryNodeGen.getUncached();
    }

    @Override
    public InternalResource.OS getOS() {
        return InternalResource.OS.WINDOWS;
    }

    @Override
    public int getDoubleLongSize() {
        return 80;
    }

    static final class UnknownSyscalls
    extends Enum<UnknownSyscalls>
    implements LLVMSyscallEntry {
        private static final /* synthetic */ UnknownSyscalls[] $VALUES;

        public static UnknownSyscalls[] values() {
            return (UnknownSyscalls[])$VALUES.clone();
        }

        public static UnknownSyscalls valueOf(String name) {
            return Enum.valueOf(UnknownSyscalls.class, name);
        }

        @Override
        public int value() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        private static /* synthetic */ UnknownSyscalls[] $values() {
            return new UnknownSyscalls[0];
        }

        static {
            $VALUES = UnknownSyscalls.$values();
        }
    }
}

