/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMReadStringNode.class)
public final class LLVMReadStringNodeGen
extends LLVMReadStringNode
implements GenerateAOT.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<LLVMAsForeignLibrary> LL_VM_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private ReadForeignData readForeign_cache;
    @Node.Child
    private FallbackData fallback_cache;

    private LLVMReadStringNodeGen() {
    }

    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        if ((state_0 & 2) == 0 && arg0Value instanceof String) {
            return false;
        }
        if (LLVMTypes.isManagedPointer(arg0Value)) {
            LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            if (LLVMReadStringNode.isString(arg0Value_)) {
                return false;
            }
            ReadForeignData s2_ = this.readForeign_cache;
            LLVMManagedPointer arg0Value_2 = LLVMTypes.asManagedPointer(arg0Value);
            if (s2_ == null || (s2_.readForeign_state_0_ & 1) == 0 || s2_.foreigns_.isForeign(arg0Value_2)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0x1E) != 0) {
            FallbackData s3_;
            if ((state_0 & 2) != 0 && arg0Value instanceof String) {
                String arg0Value_ = (String)arg0Value;
                return this.readString(arg0Value_);
            }
            if ((state_0 & 0xC) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                ReadForeignData s2_;
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state_0 & 4) != 0 && LLVMReadStringNode.isString(arg0Value_)) {
                    return this.readString(arg0Value_);
                }
                if ((state_0 & 8) != 0 && (s2_ = this.readForeign_cache) != null && (s2_.readForeign_state_0_ & 2) != 0 && s2_.foreigns_.isForeign(arg0Value_)) {
                    return this.readForeign(arg0Value_, s2_.foreigns_, s2_.read_);
                }
            }
            if ((state_0 & 0x10) != 0 && (s3_ = this.fallback_cache) != null && this.fallbackGuard_(state_0, arg0Value)) {
                return this.readOther(arg0Value, s3_.readOther_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private String executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            this.state_0_ = state_0 |= 2;
            return this.readString(arg0Value_);
        }
        if (LLVMTypes.isManagedPointer(arg0Value)) {
            LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            if (LLVMReadStringNode.isString(arg0Value_)) {
                this.state_0_ = state_0 |= 4;
                return this.readString(arg0Value_);
            }
            ReadForeignData s2_ = (ReadForeignData)this.insert(new ReadForeignData());
            LLVMAsForeignLibrary foreigns__ = (LLVMAsForeignLibrary)s2_.insert((Node)((LLVMAsForeignLibrary)LL_VM_AS_FOREIGN_LIBRARY_.createDispatched(3)));
            if ((s2_.readForeign_state_0_ & 1) == 0) {
                Objects.requireNonNull((LLVMAsForeignLibrary)s2_.insert((Node)foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s2_.foreigns_ = foreigns__;
                s2_.readForeign_state_0_ |= 1;
                VarHandle.storeStoreFence();
                this.readForeign_cache = s2_;
                s2_ = (ReadForeignData)this.insert(new ReadForeignData(s2_));
            }
            if (foreigns__.isForeign(arg0Value_)) {
                Objects.requireNonNull((LLVMAsForeignLibrary)s2_.insert((Node)foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s2_.foreigns_ = foreigns__;
                s2_.read_ = (LLVMReadStringNode.ForeignReadStringNode)s2_.insert(LLVMReadStringNode.ForeignReadStringNode.create());
                s2_.readForeign_state_0_ |= 2;
                VarHandle.storeStoreFence();
                this.readForeign_cache = s2_;
                this.state_0_ = state_0 |= 8;
                return this.readForeign(arg0Value_, foreigns__, s2_.read_);
            }
        }
        FallbackData s3_ = (FallbackData)this.insert(new FallbackData());
        s3_.readOther_ = (LLVMReadStringNode.PointerReadStringNode)s3_.insert(LLVMReadStringNode.PointerReadStringNode.create());
        VarHandle.storeStoreFence();
        this.fallback_cache = s3_;
        this.state_0_ = state_0 |= 0x10;
        return this.readOther(arg0Value, s3_.readOther_);
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        FallbackData s3_ = (FallbackData)this.insert(new FallbackData());
        s3_.readOther_ = (LLVMReadStringNode.PointerReadStringNode)s3_.insert(LLVMReadStringNode.PointerReadStringNode.create());
        VarHandle.storeStoreFence();
        this.fallback_cache = s3_;
        assert (NodeUtil.assertRecursion((Node)s3_.readOther_, (int)1));
        ((GenerateAOT.Provider)s3_.readOther_).prepareForAOT(language, root);
        this.state_0_ |= 0x10;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
        this.fallback_cache = null;
    }

    @NeverDefault
    public static LLVMReadStringNode create() {
        return new LLVMReadStringNodeGen();
    }

    @GeneratedBy(value=LLVMReadStringNode.class)
    @DenyReplace
    private static final class ReadForeignData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @CompilerDirectives.CompilationFinal
        private int readForeign_state_0_;
        @Node.Child
        LLVMAsForeignLibrary foreigns_;
        @Node.Child
        LLVMReadStringNode.ForeignReadStringNode read_;

        ReadForeignData() {
        }

        ReadForeignData(ReadForeignData delegate) {
            this.readForeign_state_0_ = delegate.readForeign_state_0_;
            this.foreigns_ = delegate.foreigns_;
            this.read_ = delegate.read_;
        }
    }

    @GeneratedBy(value=LLVMReadStringNode.class)
    @DenyReplace
    private static final class FallbackData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        LLVMReadStringNode.PointerReadStringNode readOther_;

        FallbackData() {
        }
    }

    @GeneratedBy(value=LLVMReadStringNode.PointerReadStringNode.class)
    static final class PointerReadStringNodeGen
    extends LLVMReadStringNode.PointerReadStringNode
    implements GenerateAOT.Provider {
        static final InlineSupport.ReferenceField<CachedPointerData> CACHED_POINTER_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"cachedPointer_cache", CachedPointerData.class);
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private CachedPointerData cachedPointer_cache;

        private PointerReadStringNodeGen() {
        }

        @Override
        @ExplodeLoop
        protected String execute(Object arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 6) != 0 && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if ((state_0 & 2) != 0) {
                    CachedPointerData s0_ = this.cachedPointer_cache;
                    while (s0_ != null) {
                        if (s0_.cachedAddress_.isSame(arg0Value_)) {
                            assert (DSLSupport.assertIdempotence((boolean)this.isReadOnlyMemory(s0_.cachedAddress_)));
                            return this.doCachedPointer(arg0Value_, s0_.cachedAddress_, s0_.result_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 4) != 0) {
                    return this.doReadString(arg0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        private String executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if ((state_0 & 4) == 0) {
                    CachedPointerData s0_;
                    block8: {
                        CachedPointerData s0_original;
                        do {
                            LLVMPointer cachedAddress__;
                            int count0_ = 0;
                            s0_original = s0_ = (CachedPointerData)CACHED_POINTER_CACHE_UPDATER.getVolatile((Node)this);
                            while (s0_ != null) {
                                if (s0_.cachedAddress_.isSame(arg0Value_)) {
                                    assert (DSLSupport.assertIdempotence((boolean)this.isReadOnlyMemory(s0_.cachedAddress_)));
                                    break;
                                }
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null || !(cachedAddress__ = arg0Value_).isSame(arg0Value_) || !this.isReadOnlyMemory(cachedAddress__) || count0_ >= 3) break block8;
                            s0_ = new CachedPointerData(s0_original);
                            s0_.cachedAddress_ = cachedAddress__;
                            s0_.result_ = this.doReadString(cachedAddress__);
                        } while (!CACHED_POINTER_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s0_ != null) {
                        return this.doCachedPointer(arg0Value_, s0_.cachedAddress_, s0_.result_);
                    }
                }
                this.cachedPointer_cache = null;
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                return this.doReadString(arg0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.cachedPointer_cache = null;
            this.state_0_ &= 0xFFFFFFFD;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMReadStringNode.PointerReadStringNode create() {
            return new PointerReadStringNodeGen();
        }

        @GeneratedBy(value=LLVMReadStringNode.PointerReadStringNode.class)
        @DenyReplace
        private static final class CachedPointerData
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            final CachedPointerData next_;
            @CompilerDirectives.CompilationFinal
            LLVMPointer cachedAddress_;
            @CompilerDirectives.CompilationFinal
            String result_;

            CachedPointerData(CachedPointerData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=LLVMReadStringNode.ForeignReadStringNode.class)
    static final class ForeignReadStringNodeGen
    extends LLVMReadStringNode.ForeignReadStringNode
    implements GenerateAOT.Provider {
        static final InlineSupport.ReferenceField<Default0Data> DEFAULT0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"default0_cache", Default0Data.class);
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private Default0Data default0_cache;
        @Node.Child
        private Default1Data default1_cache;

        private ForeignReadStringNodeGen() {
        }

        @Override
        @ExplodeLoop
        protected String execute(LLVMManagedPointer arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 6) != 0) {
                Default1Data s1_;
                if ((state_0 & 2) != 0) {
                    Default0Data s0_ = this.default0_cache;
                    while (s0_ != null) {
                        if (s0_.interop_.accepts(arg1Value)) {
                            return this.doDefault(arg0Value, arg1Value, s0_.interop_, s0_.read_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 4) != 0 && (s1_ = this.default1_cache) != null) {
                    return this.default1Boundary(state_0, s1_, arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private String default1Boundary(int state_0, Default1Data s1_, LLVMManagedPointer arg0Value, Object arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                String string = this.doDefault(arg0Value, arg1Value, interop__, s1_.read_);
                return string;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(LLVMManagedPointer arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if ((state_0 & 4) == 0) {
                Default0Data s0_;
                block8: {
                    Default0Data s0_original;
                    do {
                        int count0_ = 0;
                        s0_original = s0_ = (Default0Data)((Object)DEFAULT0_CACHE_UPDATER.getVolatile((Node)this));
                        while (s0_ != null && !s0_.interop_.accepts(arg1Value)) {
                            ++count0_;
                            s0_ = s0_.next_;
                        }
                        if (s0_ != null || count0_ >= 3) break block8;
                        s0_ = (Default0Data)this.insert(new Default0Data(s0_original));
                        InteropLibrary interop__ = (InteropLibrary)s0_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)));
                        Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.interop_ = interop__;
                        s0_.read_ = (LLVMReadStringNode.PointerReadStringNode)s0_.insert(LLVMReadStringNode.PointerReadStringNode.create());
                    } while (!DEFAULT0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                    this.state_0_ = state_0 |= 2;
                }
                if (s0_ != null) {
                    return this.doDefault(arg0Value, arg1Value, s0_.interop_, s0_.read_);
                }
            }
            InteropLibrary interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                Default1Data s1_ = (Default1Data)this.insert(new Default1Data());
                interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                s1_.read_ = (LLVMReadStringNode.PointerReadStringNode)s1_.insert(LLVMReadStringNode.PointerReadStringNode.create());
                VarHandle.storeStoreFence();
                this.default1_cache = s1_;
                this.default0_cache = null;
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                String string = this.doDefault(arg0Value, arg1Value, interop__, s1_.read_);
                return string;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMReadStringNode.ForeignReadStringNode create() {
            return new ForeignReadStringNodeGen();
        }

        @GeneratedBy(value=LLVMReadStringNode.ForeignReadStringNode.class)
        @DenyReplace
        private static final class Default0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            Default0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            LLVMReadStringNode.PointerReadStringNode read_;

            Default0Data(Default0Data next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=LLVMReadStringNode.ForeignReadStringNode.class)
        @DenyReplace
        private static final class Default1Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMReadStringNode.PointerReadStringNode read_;

            Default1Data() {
            }
        }
    }
}

