/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCallNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMPrepareArgumentNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMPrepareArgumentNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessGlobalSymbolNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

@NodeChild(value="dispatchTarget", type=LLVMExpressionNode.class)
public abstract class LLVMCallNode
extends LLVMExpressionNode {
    public static final int USER_ARGUMENT_OFFSET = 1;
    @Node.Children
    private final LLVMExpressionNode[] argumentNodes;
    @Node.Children
    private final LLVMPrepareArgumentNode[] prepareArgumentNodes;
    @Node.Child
    private LLVMDispatchNode dispatchNode;
    private final boolean isSourceCall;
    protected boolean mustTail;

    public static LLVMCallNode create(FunctionType functionType, LLVMExpressionNode functionNode, LLVMExpressionNode[] argumentNodes, boolean isSourceCall, boolean mustTail) {
        LLVMAccessGlobalSymbolNode node;
        LLVMFunction llvmFun = null;
        if (functionNode instanceof LLVMAccessGlobalSymbolNode && (node = (LLVMAccessGlobalSymbolNode)functionNode).getSymbol() instanceof LLVMFunction) {
            llvmFun = (LLVMFunction)node.getSymbol();
        }
        return LLVMCallNodeGen.create(functionType, argumentNodes, isSourceCall, mustTail, llvmFun, LLVMLookupDispatchTargetNode.createOptimized(functionNode));
    }

    LLVMCallNode(FunctionType functionType, LLVMExpressionNode[] argumentNodes, boolean isSourceCall, boolean mustTail, LLVMFunction llvmFunction) {
        this.argumentNodes = argumentNodes;
        this.mustTail = mustTail;
        this.prepareArgumentNodes = LLVMCallNode.createPrepareArgumentNodes(argumentNodes);
        this.dispatchNode = LLVMDispatchNodeGen.create(functionType, llvmFunction);
        this.isSourceCall = isSourceCall;
    }

    @ExplodeLoop
    @Specialization(guards={"!mustTail"})
    Object doCall(VirtualFrame frame, Object function) {
        Object[] argValues = new Object[this.argumentNodes.length];
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            argValues[i] = this.prepareArgumentNodes[i].executeWithTarget(this.argumentNodes[i].executeGeneric(frame));
        }
        return this.dispatchNode.executeDispatch(function, argValues);
    }

    @ExplodeLoop
    @Specialization(guards={"mustTail"})
    Object doTailCall(VirtualFrame frame, Object function) {
        Object[] argValues = frame.getArguments();
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            argValues[i] = this.prepareArgumentNodes[i].executeWithTarget(this.argumentNodes[i].executeGeneric(frame));
        }
        return this.dispatchNode.executeDispatch(function, argValues);
    }

    private static LLVMPrepareArgumentNode[] createPrepareArgumentNodes(LLVMExpressionNode[] argumentNodes) {
        LLVMPrepareArgumentNode[] nodes = new LLVMPrepareArgumentNode[argumentNodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = LLVMPrepareArgumentNodeGen.create();
        }
        return nodes;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.CallTag.class) {
            return this.isSourceCall && this.getSourceLocation() != null;
        }
        return super.hasTag(tag);
    }
}

