/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import java.math.BigInteger;

public class LongMultiplication {
    private static long high(BigInteger x) {
        BigInteger hi = x.shiftRight(64);
        return hi.longValue();
    }

    @CompilerDirectives.TruffleBoundary
    public static long multiplyHigh(long u, long v) {
        BigInteger x = BigInteger.valueOf(u);
        BigInteger y = BigInteger.valueOf(v);
        BigInteger z = x.multiply(y);
        return LongMultiplication.high(z);
    }

    public static long multiplyHighUnsigned(long x, long y) {
        long high = LongMultiplication.multiplyHigh(x, y);
        return high + ((x < 0L ? y : 0L) + (y < 0L ? x : 0L));
    }
}

