/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;

@NodeChild(value="valueNode")
public abstract class LLVMAMD64IncNode
extends LLVMExpressionNode {
    @Node.Child
    protected LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags;

    public LLVMAMD64IncNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags) {
        this.flags = flags;
    }

    public static abstract class LLVMAMD64IncqNode
    extends LLVMAMD64IncNode {
        public LLVMAMD64IncqNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected long doI64(VirtualFrame frame, long value) {
            long result = value + 1L;
            boolean of = value == Long.MAX_VALUE;
            this.flags.execute(frame, of, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64InclNode
    extends LLVMAMD64IncNode {
        public LLVMAMD64InclNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected int doI32(VirtualFrame frame, int value) {
            int result = value + 1;
            boolean of = value == Integer.MAX_VALUE;
            this.flags.execute(frame, of, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64IncwNode
    extends LLVMAMD64IncNode {
        public LLVMAMD64IncwNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected short doI16(VirtualFrame frame, short value) {
            short result = (short)(value + 1);
            boolean of = value == Short.MAX_VALUE;
            this.flags.execute(frame, of, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64IncbNode
    extends LLVMAMD64IncNode {
        public LLVMAMD64IncbNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected byte doI8(VirtualFrame frame, byte value) {
            byte result = (byte)(value + 1);
            boolean of = value == 127;
            this.flags.execute(frame, of, result);
            return result;
        }
    }
}

