/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.attributes;

import com.oracle.truffle.llvm.runtime.types.Type;

public abstract class Attribute {
    public abstract String getIrString();

    public static final class StringValueAttribute
    extends StringAttribute {
        private final String value;

        public StringValueAttribute(String stringAttr, String value) {
            super(stringAttr);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public String getIrString() {
            return String.format("\"%s\"=\"%s\"", this.stringAttr, this.value);
        }
    }

    public static class StringAttribute
    extends Attribute {
        protected final String stringAttr;

        public StringAttribute(String stringAttr) {
            this.stringAttr = stringAttr;
        }

        @Override
        public String getIrString() {
            return String.format("\"%s\"", this.stringAttr);
        }
    }

    public static final class KnownIntegerValueAttribute
    extends KnownAttribute {
        private final int value;

        public KnownIntegerValueAttribute(Kind paramAttr, long value) {
            super(paramAttr);
            int eltSizeParam;
            this.value = paramAttr == Kind.ALLOCSIZE ? (eltSizeParam = (int)(value >> 32)) : (int)value;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public String getIrString() {
            if (this.paramAttr == Kind.ALIGN) {
                return String.format("%s %d", this.paramAttr.getIrString(), this.value);
            }
            return String.format("%s(%d)", this.paramAttr.getIrString(), this.value);
        }
    }

    public static class KnownTypedAttribute
    extends KnownAttribute {
        private final Type type;

        public KnownTypedAttribute(Kind paramAttr, Type type) {
            super(paramAttr);
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static class KnownAttribute
    extends Attribute {
        protected final Kind paramAttr;

        public KnownAttribute(Kind paramAttr) {
            this.paramAttr = paramAttr;
        }

        public Kind getAttr() {
            return this.paramAttr;
        }

        @Override
        public String getIrString() {
            return this.paramAttr.getIrString();
        }
    }

    public static enum Kind {
        NONE,
        ALIGN,
        ALWAYSINLINE,
        BYVAL,
        INLINEHINT,
        INREG,
        MINSIZE,
        NAKED,
        NEST,
        NOALIAS,
        NOBUILTIN,
        NOCAPTURE,
        NODUPLICATES,
        NOIMPLICITFLOAT,
        NOINLINE,
        NONLAZYBIND,
        NOREDZONE,
        NORETURN,
        NOUNWIND,
        OPTSIZE,
        READNONE,
        READONLY,
        RETURNED,
        RETURNS_TWICE,
        SIGNEXT,
        ALIGNSTACK,
        SSP,
        SSPREQ,
        SSPSTRONG,
        SRET,
        SANITIZE_ADDRESS,
        SANITIZE_THREAD,
        SANITIZE_MEMORY,
        UWTABLE,
        ZEROEXT,
        BUILTIN,
        COLD,
        OPTNONE,
        INALLOCA,
        NONNULL,
        JUMPTABLE,
        DEREFERENCEABLE,
        DEREFERENCEABLE_OR_NULL,
        CONVERGENT,
        SAFESTACK,
        ARGMEMONLY,
        SWIFTSELF,
        SWIFTERROR,
        NORECURSE,
        INACCESSIBLEMEMONLY,
        INACCESSIBLEMEM_OR_ARGMEMONLY,
        ALLOCSIZE,
        WRITEONLY,
        SPECULATABLE,
        STRICT_FP,
        SANITIZE_HWADDRESS,
        NOCF_CHECK,
        OPT_FOR_FUZZING,
        SHADOWCALLSTACK,
        SPECULATIVE_LOAD_HARDENING,
        IMMARG,
        WILLRETURN,
        NOFREE,
        NOSYNC,
        SANITIZE_MEMTAG,
        PREALLOCATED,
        NO_MERGE,
        NULL_POINTER_IS_VALID,
        NOUNDEF,
        BYREF,
        MUSTPROGRESS,
        NO_CALLBACK,
        HOT,
        NO_PROFILE,
        VSCALE_RANGE,
        SWIFT_ASYNC,
        NO_SANITIZE_COVERAGE,
        ELEMENTTYPE,
        DISABLE_SANITIZER_INSTRUMENTATION,
        NO_SANITIZE_BOUNDS,
        ALLOC_ALIGN,
        ALLOCATED_POINTER,
        ALLOC_KIND,
        PRESPLIT_COROUTINE,
        FNRETTHUNK_EXTERN,
        SKIP_PROFILE,
        MEMORY,
        NOFPCLASS,
        OPTIMIZE_FOR_DEBUGGING,
        WRITABLE,
        CORO_ONLY_DESTROY_WHEN_COMPLETE,
        DEAD_ON_UNWIND,
        RANGE,
        SANITIZE_NUMERICAL_STABILITY,
        INITIALIZES,
        HYBRID_PATCHABLE,
        SANITIZE_REALTIME,
        SANITIZE_REALTIME_BLOCKING,
        CORO_ELIDE_SAFE,
        NO_EXT,
        NO_DIVERGENCE_SOURCE,
        SANITIZE_TYPE,
        CAPTURES;

        private static final Kind[] VALUES;

        public static Kind decode(long id) {
            if (id > 0L && id < (long)VALUES.length) {
                return VALUES[(int)id];
            }
            return NONE;
        }

        public String getIrString() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = Kind.values();
        }
    }
}

