/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.llvm.parser.factories.DarwinAArch64PlatformCapability;
import com.oracle.truffle.llvm.parser.factories.DarwinAMD64PlatformCapability;
import com.oracle.truffle.llvm.parser.factories.LinuxAArch64PlatformCapability;
import com.oracle.truffle.llvm.parser.factories.LinuxAMD64PlatformCapability;
import com.oracle.truffle.llvm.parser.factories.PlatformCapabilityBase;
import com.oracle.truffle.llvm.parser.factories.UnknownBasicPlatformCapability;
import com.oracle.truffle.llvm.parser.factories.WindowsAMD64PlatformCapability;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.inlineasm.InlineAssemblyParserBase;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMInfo;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMNativeSyscallNode;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public abstract class BasicPlatformCapability<S extends Enum<S>>
extends PlatformCapabilityBase<S> {
    public static final int RTLD_LAZY = 1;
    public static final int RTLD_GLOBAL = 256;
    public static final long RTLD_DEFAULT = 0L;
    private static final Path SULONG_LIBDIR = Paths.get("native", "lib");
    public static final String LIBCXX_FILENAME = NativeContextExtension.getNativeLibrary("c++");
    public static final String LIBCXXABI_FILENAME = NativeContextExtension.getNativeLibrary("c++abi");
    public static final String LIBSULONG_FILENAME = NativeContextExtension.getNativeLibrary("sulong");
    public static final String LIBSULONGXX_FILENAME = NativeContextExtension.getNativeLibrary("sulong++");

    @Override
    public ByteOrder getPlatformByteOrder() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public boolean isGlobalDLOpenFlagSet(int flag) {
        return (flag & 0x100) == 256;
    }

    @Override
    public boolean isLazyDLOpenFlagSet(int flag) {
        return (flag & 1) == 1;
    }

    @Override
    public boolean isFirstDLOpenFlagSet(int flag) {
        return false;
    }

    @Override
    public boolean isDefaultDLSymFlagSet(long flag) {
        return flag == 0L;
    }

    public static BasicPlatformCapability<?> create(boolean loadCxxLibraries) {
        if (LLVMInfo.SYSNAME.equalsIgnoreCase("linux")) {
            if (LLVMInfo.MACHINE.equalsIgnoreCase("x86_64")) {
                return new LinuxAMD64PlatformCapability(loadCxxLibraries);
            }
            if (LLVMInfo.MACHINE.equalsIgnoreCase("aarch64")) {
                return new LinuxAArch64PlatformCapability(loadCxxLibraries);
            }
        }
        if (LLVMInfo.SYSNAME.equalsIgnoreCase("mac os x")) {
            if (LLVMInfo.MACHINE.equalsIgnoreCase("x86_64")) {
                return new DarwinAMD64PlatformCapability(loadCxxLibraries);
            }
            if (LLVMInfo.MACHINE.equalsIgnoreCase("aarch64")) {
                return new DarwinAArch64PlatformCapability(loadCxxLibraries);
            }
        }
        if (LLVMInfo.SYSNAME.toLowerCase(Locale.ROOT).startsWith("windows") && LLVMInfo.MACHINE.equalsIgnoreCase("x86_64")) {
            return new WindowsAMD64PlatformCapability(loadCxxLibraries);
        }
        return new UnknownBasicPlatformCapability(loadCxxLibraries);
    }

    protected BasicPlatformCapability(Class<S> cls, boolean loadCxxLibraries, InlineAssemblyParserBase inlineAssemblyParser) {
        super(cls, loadCxxLibraries, inlineAssemblyParser);
    }

    @Override
    public String getBuiltinsLibrary() {
        return NativeContextExtension.getNativeLibraryVersioned("graalvm-llvm", 1);
    }

    @Override
    public Path getSulongLibrariesPath() {
        return SULONG_LIBDIR;
    }

    @Override
    public String getLibsulongxxFilename() {
        return LIBSULONGXX_FILENAME;
    }

    @Override
    public String getLibsulongFilename() {
        return LIBSULONG_FILENAME;
    }

    @Override
    public String getCxxFilename() {
        return LIBCXX_FILENAME;
    }

    @Override
    public String getCxxAbiFilename() {
        return LIBCXXABI_FILENAME;
    }

    @Override
    public LLVMSyscallOperationNode createSyscallNode(long index) {
        try {
            return this.createSyscallNode(this.getSyscall(index));
        }
        catch (IllegalArgumentException e) {
            return new LLVMNativeSyscallNode(index);
        }
    }

    @Override
    public String getLibraryPrefix() {
        return NativeContextExtension.getNativeLibraryPrefix();
    }

    @Override
    public String getLibrarySuffix() {
        return NativeContextExtension.getNativeLibrarySuffix();
    }

    @Override
    public String getLibrarySuffixVersioned(int version) {
        return NativeContextExtension.getNativeLibrarySuffixVersioned(version);
    }

    protected abstract LLVMSyscallOperationNode createSyscallNode(S var1);
}

