/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.initialization.DataSectionFactory;
import com.oracle.truffle.llvm.initialization.InitializeGlobalsBlockNode;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalPointer;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.ArrayList;
import java.util.List;

public final class InitializeSymbolsNode
extends LLVMNode {
    private final String moduleName;
    private final LLVMGlobal imageBase;
    @Node.Child
    private InitializeGlobalsBlockNode initializeGlobalsBlockNode;
    private final BranchProfile exception;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] globalOffsets;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] threadLocalGlobalOffsets;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final boolean[] globalIsReadOnly;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMSymbol[] globals;
    @Node.Children
    private final AllocSymbolNode[] allocFuncs;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMSymbol[] functions;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private LLVMSymbol[] threadLocalGlobalsArray;
    private final LLVMScope fileScope;
    private final NodeFactory nodeFactory;
    private final IDGenerater.BitcodeID bitcodeID;
    private final int globalLength;

    public InitializeSymbolsNode(LLVMParserResult result, boolean lazyParsing, boolean isInternalSulongLibrary, String moduleName, DataSectionFactory dataSectionFactory, LLVMLanguage language) {
        LLVMSymbol symbol;
        int i;
        this.nodeFactory = result.getRuntime().getNodeFactory();
        this.fileScope = result.getRuntime().getFileScope();
        this.globalLength = result.getSymbolTableSize();
        this.bitcodeID = result.getRuntime().getBitcodeID();
        this.moduleName = moduleName;
        this.exception = BranchProfile.create();
        List<GlobalVariable> definedGlobals = result.getDefinedGlobals();
        List<GlobalVariable> threadLocalGlobals = result.getThreadLocalGlobals();
        int globalsCount = definedGlobals.size();
        int threadLocalGlobalsCount = threadLocalGlobals.size();
        this.threadLocalGlobalsArray = new LLVMSymbol[threadLocalGlobalsCount];
        this.globals = new LLVMSymbol[globalsCount];
        LLVMIntrinsicProvider intrinsicProvider = LLVMLanguage.get(null).getCapability(LLVMIntrinsicProvider.class);
        this.globalOffsets = dataSectionFactory.getGlobalOffsets();
        this.threadLocalGlobalOffsets = dataSectionFactory.getThreadLocalGlobalOffsets();
        this.globalIsReadOnly = dataSectionFactory.getGlobalIsReadOnly();
        assert (this.threadLocalGlobalOffsets.length == this.threadLocalGlobalsArray.length);
        for (i = 0; i < globalsCount; ++i) {
            GlobalVariable global = definedGlobals.get(i);
            symbol = this.fileScope.get(global.getName());
            assert (symbol != null);
            this.globals[i] = symbol;
        }
        for (i = 0; i < threadLocalGlobalsCount; ++i) {
            GlobalVariable tlGlobals = threadLocalGlobals.get(i);
            symbol = this.fileScope.get(tlGlobals.getName());
            assert (symbol != null);
            this.threadLocalGlobalsArray[i] = symbol;
        }
        List<FunctionSymbol> definedFunctions = result.getDefinedFunctions();
        int functionCount = definedFunctions.size();
        this.functions = new LLVMSymbol[functionCount];
        this.allocFuncs = new AllocSymbolNode[functionCount];
        for (int i2 = 0; i2 < functionCount; ++i2) {
            FunctionSymbol functionSymbol = definedFunctions.get(i2);
            LLVMFunction function = this.fileScope.getFunction(functionSymbol.getName());
            LLVMFunctionCode functionCode = new LLVMFunctionCode(function);
            this.allocFuncs[i2] = isInternalSulongLibrary && intrinsicProvider.isIntrinsified(function.getName()) ? new AllocIntrinsicFunctionNode(function, functionCode, this.nodeFactory, intrinsicProvider) : (lazyParsing ? new AllocLLVMFunctionNode(function, functionCode) : new AllocLLVMEagerFunctionNode(function, functionCode));
            this.functions[i2] = function;
        }
        this.initializeGlobalsBlockNode = new InitializeGlobalsBlockNode(result, dataSectionFactory, language);
        this.imageBase = result.getRuntime().getFileScope().getGlobalVariable("__ImageBase");
    }

    public void initializeSymbolTable(LLVMContext context) {
        context.initializeSymbolTable(this.bitcodeID, this.globalLength);
        context.registerScope(this.fileScope);
    }

    public void execute(LLVMContext ctx) {
        if (LibraryLocator.loggingEnabled()) {
            LibraryLocator.traceStaticInits(ctx, "symbol initializers", this.moduleName);
        }
        LLVMPointer basePointer = this.initializeGlobalsBlockNode.allocateGlobalsSectionBlock();
        LLVMPointer rwBase = this.initializeGlobalsBlockNode.getRwSectionPointer(basePointer);
        LLVMPointer roBase = this.initializeGlobalsBlockNode.getRoSectionPointer(basePointer);
        if (this.initializeGlobalsBlockNode.hasGlobalsBlock()) {
            assert (basePointer != null);
            ctx.registerGlobals(this.bitcodeID.getId(), basePointer, this.initializeGlobalsBlockNode.getGlobalsBlockSize(), this.nodeFactory);
            if (roBase != null) {
                ctx.registerReadOnlyGlobals(this.bitcodeID.getId(), roBase, this.initializeGlobalsBlockNode.getRoBlockSize(), this.nodeFactory);
            }
            if (this.imageBase != null) {
                ctx.initializeSymbol(this.imageBase, basePointer);
            }
        }
        this.initializeGlobalSymbols(ctx, roBase, rwBase);
        this.initializeFunctionSymbols(ctx);
        this.initializeTLGlobalSymbols(ctx);
    }

    public void initializeTLGlobalSymbols(LLVMContext context) {
        for (int i = 0; i < this.threadLocalGlobalOffsets.length; ++i) {
            int offset = this.threadLocalGlobalOffsets[i];
            LLVMThreadLocalPointer pointer = new LLVMThreadLocalPointer(this.threadLocalGlobalsArray[i], offset);
            LLVMSymbol symbol = pointer.getSymbol();
            LLVMManagedPointer llvmPointer = LLVMManagedPointer.create(pointer);
            if (symbol == null) {
                this.exception.enter();
                throw new LLVMLinkerException((Node)this, "Thread local global variable %s not found", pointer.toString());
            }
            context.initializeSymbol(symbol, llvmPointer);
            if (!symbol.isExported()) continue;
            LLVMGlobal descriptor = this.fileScope.getGlobalVariable(symbol.getName());
            ArrayList<LLVMSymbol> list = new ArrayList<LLVMSymbol>(1);
            list.add(descriptor);
            context.registerSymbolReverseMap(list, llvmPointer);
        }
    }

    private void initializeGlobalSymbols(LLVMContext context, LLVMPointer roBase, LLVMPointer rwBase) {
        for (int i = 0; i < this.globals.length; ++i) {
            LLVMPointer ref;
            LLVMSymbol allocGlobal = this.globals[i];
            assert (allocGlobal != null);
            assert (this.fileScope != null);
            LLVMGlobal descriptor = this.fileScope.getGlobalVariable(allocGlobal.getName());
            if (descriptor == null) {
                this.exception.enter();
                throw new LLVMLinkerException((Node)this, "Global variable %s not found", allocGlobal.getName());
            }
            if (context.checkSymbol(allocGlobal)) continue;
            if (this.globalOffsets[i] == -1) {
                ref = LLVMManagedPointer.create(new LLVMGlobalContainer());
            } else {
                LLVMPointer base = this.globalIsReadOnly[i] ? roBase : rwBase;
                ref = base.increment(this.globalOffsets[i]);
            }
            context.initializeSymbol(this.globals[i], ref);
            ArrayList<LLVMSymbol> list = new ArrayList<LLVMSymbol>(1);
            list.add(descriptor);
            context.registerSymbolReverseMap(list, ref);
        }
    }

    private void initializeFunctionSymbols(LLVMContext context) {
        for (int i = 0; i < this.allocFuncs.length; ++i) {
            AllocSymbolNode allocSymbol = this.allocFuncs[i];
            LLVMPointer pointer = allocSymbol.allocate(context);
            context.initializeSymbol(this.functions[i], pointer);
            ArrayList<LLVMSymbol> list = new ArrayList<LLVMSymbol>(1);
            list.add(allocSymbol.symbol);
            context.registerSymbolReverseMap(list, pointer);
        }
    }

    static abstract class AllocSymbolNode
    extends LLVMNode {
        static final AllocSymbolNode[] EMPTY = new AllocSymbolNode[0];
        final LLVMSymbol symbol;

        AllocSymbolNode(LLVMSymbol symbol) {
            this.symbol = symbol;
        }

        abstract LLVMPointer allocate(LLVMContext var1);
    }

    static final class AllocIntrinsicFunctionNode
    extends AllocSymbolNode {
        private final NodeFactory nodeFactory;
        LLVMIntrinsicProvider intrinsicProvider;
        private final LLVMFunctionCode functionCode;

        AllocIntrinsicFunctionNode(LLVMFunction function, LLVMFunctionCode functionCode, NodeFactory nodeFactory, LLVMIntrinsicProvider intrinsicProvider) {
            super(function);
            this.functionCode = functionCode;
            this.nodeFactory = nodeFactory;
            this.intrinsicProvider = intrinsicProvider;
        }

        @CompilerDirectives.TruffleBoundary
        private LLVMFunctionDescriptor createAndDefine(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(this.symbol.asFunction(), this.functionCode);
            if (this.intrinsicProvider.isIntrinsified(this.symbol.getName())) {
                functionDescriptor.getFunctionCode().define(this.intrinsicProvider, this.nodeFactory);
                return functionDescriptor;
            }
            throw new IllegalStateException("Failed to allocate intrinsic function " + this.symbol.getName());
        }

        @Override
        LLVMPointer allocate(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = this.createAndDefine(context);
            return LLVMManagedPointer.create(functionDescriptor);
        }
    }

    static final class AllocLLVMFunctionNode
    extends AllocSymbolNode {
        private final LLVMFunctionCode functionCode;

        AllocLLVMFunctionNode(LLVMFunction function, LLVMFunctionCode functionCode) {
            super(function);
            this.functionCode = functionCode;
        }

        @CompilerDirectives.TruffleBoundary
        private LLVMFunctionDescriptor createAndResolve(LLVMContext context) {
            return context.createFunctionDescriptor(this.symbol.asFunction(), this.functionCode);
        }

        @Override
        LLVMPointer allocate(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = this.createAndResolve(context);
            return LLVMManagedPointer.create(functionDescriptor);
        }
    }

    static final class AllocLLVMEagerFunctionNode
    extends AllocSymbolNode {
        private final LLVMFunctionCode functionCode;

        AllocLLVMEagerFunctionNode(LLVMFunction function, LLVMFunctionCode functionCode) {
            super(function);
            this.functionCode = functionCode;
        }

        @CompilerDirectives.TruffleBoundary
        private LLVMFunctionDescriptor createAndResolve(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(this.symbol.asFunction(), this.functionCode);
            functionDescriptor.getFunctionCode().resolveIfLazyLLVMIRFunction();
            return functionDescriptor;
        }

        @Override
        LLVMPointer allocate(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = this.createAndResolve(context);
            if (context.isAOTCacheLoad() || context.isAOTCacheStore()) {
                functionDescriptor.toNative();
            }
            return LLVMManagedPointer.create(functionDescriptor);
        }
    }
}

