/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.initialization.InitObjcSelectorsNode;
import com.oracle.truffle.llvm.initialization.InitObjcSelectorsNodeGen;
import com.oracle.truffle.llvm.initialization.StaticInitsNode;
import com.oracle.truffle.llvm.initialization.StaticInitsNodeGen;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.ArrayConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.StructureConstant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.parser.util.Pair;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMVoidStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMVoidStatementNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMStatementRootNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import java.util.ArrayList;
import java.util.Comparator;

public final class InitializeModuleNode
extends LLVMNode
implements LLVMHasDatalayoutNode {
    private static final int LEAST_CONSTRUCTOR_PRIORITY = 65535;
    private static final Comparator<Pair<Integer, ?>> ASCENDING_PRIORITY = (p1, p2) -> (Integer)p1.getFirst() - (Integer)p2.getFirst();
    private static final Comparator<Pair<Integer, ?>> DESCENDING_PRIORITY = (p1, p2) -> (Integer)p2.getFirst() - (Integer)p1.getFirst();
    private final RootCallTarget destructor;
    private final DataLayout dataLayout;
    private final IDGenerater.BitcodeID bitcodeID;
    @Node.Child
    private StaticInitsNode constructor;
    @Node.Child
    private InitObjcSelectorsNode selectors;

    public InitializeModuleNode(LLVMLanguage language, LLVMParserResult parserResult, String moduleName) {
        this.destructor = InitializeModuleNode.createDestructor(parserResult, moduleName, language);
        this.dataLayout = parserResult.getDataLayout();
        this.bitcodeID = parserResult.getRuntime().getBitcodeID();
        this.constructor = InitializeModuleNode.createConstructor(parserResult, moduleName);
        if (language.getCapability(PlatformCapability.class).getOS() == InternalResource.OS.DARWIN) {
            this.selectors = InitObjcSelectorsNodeGen.create(parserResult);
        }
    }

    public void execute(VirtualFrame frame, LLVMContext ctx) {
        if (this.destructor != null) {
            ctx.registerDestructorFunctions(this.bitcodeID, this.destructor);
        }
        this.constructor.execute(frame);
        if (this.selectors != null) {
            this.selectors.execute(frame);
        }
    }

    @Override
    public DataLayout getDatalayout() {
        return this.dataLayout;
    }

    public static RootCallTarget createDestructor(LLVMParserResult parserResult, String moduleName, LLVMLanguage language) {
        LLVMStatementNode[] destructors = InitializeModuleNode.createStructor("llvm.global_dtors", parserResult, DESCENDING_PRIORITY);
        if (destructors.length > 0) {
            NodeFactory nodeFactory = parserResult.getRuntime().getNodeFactory();
            FrameDescriptor.Builder builder = FrameDescriptor.newBuilder();
            nodeFactory.addStackSlots(builder);
            FrameDescriptor frameDescriptor = builder.build();
            LLVMStatementRootNode root = new LLVMStatementRootNode(language, StaticInitsNodeGen.create(destructors, "fini", moduleName), frameDescriptor, nodeFactory.createStackAccess());
            return root.getCallTarget();
        }
        return null;
    }

    private static StaticInitsNode createConstructor(LLVMParserResult parserResult, String moduleName) {
        return StaticInitsNodeGen.create(InitializeModuleNode.createStructor("llvm.global_ctors", parserResult, ASCENDING_PRIORITY), "init", moduleName);
    }

    private static LLVMStatementNode[] createStructor(String name, LLVMParserResult parserResult, Comparator<Pair<Integer, ?>> priorityComparator) {
        for (GlobalVariable globalVariable : parserResult.getDefinedGlobals()) {
            if (!globalVariable.getName().equals(name)) continue;
            return InitializeModuleNode.resolveStructor(parserResult, globalVariable, priorityComparator);
        }
        return LLVMStatementNode.NO_STATEMENTS;
    }

    private static LLVMStatementNode[] resolveStructor(LLVMParserResult parserResult, GlobalVariable globalSymbol, Comparator<Pair<Integer, ?>> priorityComparator) {
        if (!(globalSymbol.getValue() instanceof ArrayConstant)) {
            return LLVMStatementNode.NO_STATEMENTS;
        }
        LLVMParserRuntime runtime = parserResult.getRuntime();
        NodeFactory nodeFactory = runtime.getNodeFactory();
        ArrayConstant arrayConstant = (ArrayConstant)globalSymbol.getValue();
        int elemCount = arrayConstant.getElementCount();
        ArrayList<Pair<Integer, LLVMVoidStatementNode>> structors = new ArrayList<Pair<Integer, LLVMVoidStatementNode>>(elemCount);
        for (int i = 0; i < elemCount; ++i) {
            FunctionType functionType;
            StructureConstant structorDefinition = (StructureConstant)arrayConstant.getElement(i);
            Constant function = structorDefinition.getElement(1);
            if (function.getType() instanceof FunctionType) {
                functionType = (FunctionType)function.getType();
            } else {
                PointerType ptrType = (PointerType)function.getType();
                functionType = (FunctionType)ptrType.getPointeeType();
            }
            LLVMExpressionNode functionPtr = function.createNode(runtime, parserResult.getDataLayout(), null);
            LLVMExpressionNode[] argNodes = new LLVMExpressionNode[]{nodeFactory.createGetStackFromFrame()};
            LLVMVoidStatementNode functionCall = LLVMVoidStatementNodeGen.create(CommonNodeFactory.createFunctionCall(functionPtr, argNodes, functionType));
            Constant prioritySymbol = structorDefinition.getElement(0);
            Integer priority = LLVMSymbolReadResolver.evaluateIntegerConstant(prioritySymbol);
            structors.add(new Pair<Integer, LLVMVoidStatementNode>(priority != null ? priority : 65535, functionCall));
        }
        return (LLVMStatementNode[])structors.stream().sorted(priorityComparator).map(Pair::getSecond).toArray(LLVMStatementNode[]::new);
    }
}

