/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMVectorSelectNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMVectorSelectNode.class)
public final class LLVMVectorSelectNodeGen
extends LLVMVectorSelectNode
implements GenerateAOT.Provider {
    private final int vectorLength;
    @Node.Child
    private LLVMExpressionNode conditionNode_;
    @Node.Child
    private LLVMExpressionNode trueNode_;
    @Node.Child
    private LLVMExpressionNode elseNode_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @CompilerDirectives.CompilationFinal
    private CountingConditionProfile conditionProfile_;

    private LLVMVectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
        this.vectorLength = vectorLength;
        this.conditionNode_ = conditionNode;
        this.trueNode_ = trueNode;
        this.elseNode_ = elseNode;
    }

    @Override
    protected int getVectorLength() {
        return this.vectorLength;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        CountingConditionProfile conditionProfile__;
        boolean conditionNodeValue_;
        int state_0 = this.state_0_;
        try {
            conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
        }
        Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
        Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }
        if ((state_0 & 2) != 0 && (conditionProfile__ = this.conditionProfile_) != null) {
            return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
    }

    private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (conditionNodeValue instanceof Boolean) {
            boolean conditionNodeValue_ = (Boolean)conditionNodeValue;
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.conditionProfile_ = conditionProfile__;
            this.state_0_ = state_0 |= 2;
            return this.doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
        Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        VarHandle.storeStoreFence();
        this.conditionProfile_ = conditionProfile__;
        this.conditionProfile_.disable();
        this.state_0_ |= 2;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
        this.conditionProfile_.reset();
    }

    @NeverDefault
    public static LLVMVectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
        return new LLVMVectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMDoubleVectorSelectNode.class)
    public static final class LLVMDoubleVectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMDoubleVectorSelectNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op0_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op1_conditionProfile_;

        private LLVMDoubleVectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            return this.executeGeneric_generic1(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean conditionNodeValue_;
            int state_0 = state_0__;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
            if (conditionProfile__ != null) {
                return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (Boolean)conditionNodeValue_;
                    CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                    if (conditionProfile__ != null) {
                        return this.doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                    }
                }
                if ((state_0 & 4) != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMDoubleVector) {
                        LLVMDoubleVector trueNodeValue__ = (LLVMDoubleVector)trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMDoubleVector) {
                            LLVMDoubleVector elseNodeValue__ = (LLVMDoubleVector)elseNodeValue_;
                            CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                            if (conditionProfile__1 != null) {
                                return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (Boolean)conditionNodeValue;
                CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.state_0_ = state_0 |= 2;
                return this.doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector trueNodeValue_ = (LLVMDoubleVector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMDoubleVector) {
                        LLVMDoubleVector elseNodeValue_ = (LLVMDoubleVector)elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        this.state_0_ = state_0 |= 4;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op0_conditionProfile_ = conditionProfile__;
            this.op0_conditionProfile_.disable();
            this.state_0_ |= 2;
            CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op1_conditionProfile_ = conditionProfile__1;
            this.op1_conditionProfile_.disable();
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMVectorSelectNode.LLVMDoubleVectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMDoubleVectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMFloatVectorSelectNode.class)
    public static final class LLVMFloatVectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMFloatVectorSelectNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op0_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op1_conditionProfile_;

        private LLVMFloatVectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            return this.executeGeneric_generic1(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean conditionNodeValue_;
            int state_0 = state_0__;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
            if (conditionProfile__ != null) {
                return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (Boolean)conditionNodeValue_;
                    CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                    if (conditionProfile__ != null) {
                        return this.doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                    }
                }
                if ((state_0 & 4) != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMFloatVector) {
                        LLVMFloatVector trueNodeValue__ = (LLVMFloatVector)trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMFloatVector) {
                            LLVMFloatVector elseNodeValue__ = (LLVMFloatVector)elseNodeValue_;
                            CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                            if (conditionProfile__1 != null) {
                                return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (Boolean)conditionNodeValue;
                CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.state_0_ = state_0 |= 2;
                return this.doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMFloatVector) {
                    LLVMFloatVector trueNodeValue_ = (LLVMFloatVector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMFloatVector) {
                        LLVMFloatVector elseNodeValue_ = (LLVMFloatVector)elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        this.state_0_ = state_0 |= 4;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op0_conditionProfile_ = conditionProfile__;
            this.op0_conditionProfile_.disable();
            this.state_0_ |= 2;
            CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op1_conditionProfile_ = conditionProfile__1;
            this.op1_conditionProfile_.disable();
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMVectorSelectNode.LLVMFloatVectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMFloatVectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMI64VectorSelectNode.class)
    public static final class LLVMI64VectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMI64VectorSelectNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op0_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op1_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op2_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op3_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op4_conditionProfile_;

        private LLVMI64VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3C) == 0 && (state_0 & 0x3E) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            return this.executeGeneric_generic1(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean conditionNodeValue_;
            int state_0 = state_0__;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
            if (conditionProfile__ != null) {
                return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 0x3E) != 0) {
                if ((state_0 & 2) != 0 && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (Boolean)conditionNodeValue_;
                    CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                    if (conditionProfile__ != null) {
                        return this.doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                    }
                }
                if ((state_0 & 0x3C) != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMVector elseNodeValue__;
                    LLVMVector trueNodeValue__;
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                    if ((state_0 & 0xC) != 0 && trueNodeValue_ instanceof LLVMI64Vector) {
                        trueNodeValue__ = (LLVMI64Vector)trueNodeValue_;
                        if ((state_0 & 4) != 0 && elseNodeValue_ instanceof LLVMI64Vector) {
                            elseNodeValue__ = (LLVMI64Vector)elseNodeValue_;
                            CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                            if (conditionProfile__1 != null) {
                                return this.doOp(conditionNodeValue__, (LLVMI64Vector)trueNodeValue__, (LLVMI64Vector)elseNodeValue__, conditionProfile__1);
                            }
                        }
                        if ((state_0 & 8) != 0 && elseNodeValue_ instanceof LLVMPointerVector) {
                            elseNodeValue__ = (LLVMPointerVector)elseNodeValue_;
                            CountingConditionProfile conditionProfile__2 = this.op2_conditionProfile_;
                            if (conditionProfile__2 != null) {
                                return this.doOp(conditionNodeValue__, (LLVMI64Vector)trueNodeValue__, (LLVMPointerVector)elseNodeValue__, conditionProfile__2);
                            }
                        }
                    }
                    if ((state_0 & 0x30) != 0 && trueNodeValue_ instanceof LLVMPointerVector) {
                        trueNodeValue__ = (LLVMPointerVector)trueNodeValue_;
                        if ((state_0 & 0x10) != 0 && elseNodeValue_ instanceof LLVMI64Vector) {
                            elseNodeValue__ = (LLVMI64Vector)elseNodeValue_;
                            CountingConditionProfile conditionProfile__3 = this.op3_conditionProfile_;
                            if (conditionProfile__3 != null) {
                                return this.doOp(conditionNodeValue__, (LLVMPointerVector)trueNodeValue__, (LLVMI64Vector)elseNodeValue__, conditionProfile__3);
                            }
                        }
                        if ((state_0 & 0x20) != 0 && elseNodeValue_ instanceof LLVMPointerVector) {
                            elseNodeValue__ = (LLVMPointerVector)elseNodeValue_;
                            CountingConditionProfile conditionProfile__4 = this.op4_conditionProfile_;
                            if (conditionProfile__4 != null) {
                                return this.doOp(conditionNodeValue__, (LLVMPointerVector)trueNodeValue__, (LLVMPointerVector)elseNodeValue__, conditionProfile__4);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (Boolean)conditionNodeValue;
                CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.state_0_ = state_0 |= 2;
                return this.doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMVector trueNodeValue_;
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMI64Vector) {
                    trueNodeValue_ = (LLVMI64Vector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI64Vector) {
                        LLVMI64Vector elseNodeValue_ = (LLVMI64Vector)elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        this.state_0_ = state_0 |= 4;
                        return this.doOp(conditionNodeValue_, (LLVMI64Vector)trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                    if (elseNodeValue instanceof LLVMPointerVector) {
                        LLVMPointerVector elseNodeValue_ = (LLVMPointerVector)elseNodeValue;
                        CountingConditionProfile conditionProfile__2 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.op2_conditionProfile_ = conditionProfile__2;
                        this.state_0_ = state_0 |= 8;
                        return this.doOp(conditionNodeValue_, (LLVMI64Vector)trueNodeValue_, elseNodeValue_, conditionProfile__2);
                    }
                }
                if (trueNodeValue instanceof LLVMPointerVector) {
                    trueNodeValue_ = (LLVMPointerVector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI64Vector) {
                        LLVMI64Vector elseNodeValue_ = (LLVMI64Vector)elseNodeValue;
                        CountingConditionProfile conditionProfile__3 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__3, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.op3_conditionProfile_ = conditionProfile__3;
                        this.state_0_ = state_0 |= 0x10;
                        return this.doOp(conditionNodeValue_, (LLVMPointerVector)trueNodeValue_, elseNodeValue_, conditionProfile__3);
                    }
                    if (elseNodeValue instanceof LLVMPointerVector) {
                        LLVMPointerVector elseNodeValue_ = (LLVMPointerVector)elseNodeValue;
                        CountingConditionProfile conditionProfile__4 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__4, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.op4_conditionProfile_ = conditionProfile__4;
                        this.state_0_ = state_0 |= 0x20;
                        return this.doOp(conditionNodeValue_, (LLVMPointerVector)trueNodeValue_, elseNodeValue_, conditionProfile__4);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op0_conditionProfile_ = conditionProfile__;
            this.op0_conditionProfile_.disable();
            this.state_0_ |= 2;
            CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op1_conditionProfile_ = conditionProfile__1;
            this.op1_conditionProfile_.disable();
            this.state_0_ |= 4;
            CountingConditionProfile conditionProfile__2 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op2_conditionProfile_ = conditionProfile__2;
            this.op2_conditionProfile_.disable();
            this.state_0_ |= 8;
            CountingConditionProfile conditionProfile__3 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__3, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op3_conditionProfile_ = conditionProfile__3;
            this.op3_conditionProfile_.disable();
            this.state_0_ |= 0x10;
            CountingConditionProfile conditionProfile__4 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__4, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op4_conditionProfile_ = conditionProfile__4;
            this.op4_conditionProfile_.disable();
            this.state_0_ |= 0x20;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
            this.op2_conditionProfile_.reset();
            this.op3_conditionProfile_.reset();
            this.op4_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMVectorSelectNode.LLVMI64VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI64VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMI32VectorSelectNode.class)
    public static final class LLVMI32VectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMI32VectorSelectNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op0_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op1_conditionProfile_;

        private LLVMI32VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            return this.executeGeneric_generic1(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean conditionNodeValue_;
            int state_0 = state_0__;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
            if (conditionProfile__ != null) {
                return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (Boolean)conditionNodeValue_;
                    CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                    if (conditionProfile__ != null) {
                        return this.doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                    }
                }
                if ((state_0 & 4) != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector trueNodeValue__ = (LLVMI32Vector)trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMI32Vector) {
                            LLVMI32Vector elseNodeValue__ = (LLVMI32Vector)elseNodeValue_;
                            CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                            if (conditionProfile__1 != null) {
                                return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (Boolean)conditionNodeValue;
                CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.state_0_ = state_0 |= 2;
                return this.doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMI32Vector) {
                    LLVMI32Vector trueNodeValue_ = (LLVMI32Vector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI32Vector) {
                        LLVMI32Vector elseNodeValue_ = (LLVMI32Vector)elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        this.state_0_ = state_0 |= 4;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op0_conditionProfile_ = conditionProfile__;
            this.op0_conditionProfile_.disable();
            this.state_0_ |= 2;
            CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op1_conditionProfile_ = conditionProfile__1;
            this.op1_conditionProfile_.disable();
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMVectorSelectNode.LLVMI32VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI32VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMI16VectorSelectNode.class)
    public static final class LLVMI16VectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMI16VectorSelectNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op0_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op1_conditionProfile_;

        private LLVMI16VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            return this.executeGeneric_generic1(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean conditionNodeValue_;
            int state_0 = state_0__;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
            if (conditionProfile__ != null) {
                return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (Boolean)conditionNodeValue_;
                    CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                    if (conditionProfile__ != null) {
                        return this.doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                    }
                }
                if ((state_0 & 4) != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMI16Vector) {
                        LLVMI16Vector trueNodeValue__ = (LLVMI16Vector)trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMI16Vector) {
                            LLVMI16Vector elseNodeValue__ = (LLVMI16Vector)elseNodeValue_;
                            CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                            if (conditionProfile__1 != null) {
                                return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (Boolean)conditionNodeValue;
                CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.state_0_ = state_0 |= 2;
                return this.doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMI16Vector) {
                    LLVMI16Vector trueNodeValue_ = (LLVMI16Vector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI16Vector) {
                        LLVMI16Vector elseNodeValue_ = (LLVMI16Vector)elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        this.state_0_ = state_0 |= 4;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op0_conditionProfile_ = conditionProfile__;
            this.op0_conditionProfile_.disable();
            this.state_0_ |= 2;
            CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op1_conditionProfile_ = conditionProfile__1;
            this.op1_conditionProfile_.disable();
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMVectorSelectNode.LLVMI16VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI16VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMI8VectorSelectNode.class)
    public static final class LLVMI8VectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMI8VectorSelectNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op0_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op1_conditionProfile_;

        private LLVMI8VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            return this.executeGeneric_generic1(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean conditionNodeValue_;
            int state_0 = state_0__;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
            if (conditionProfile__ != null) {
                return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (Boolean)conditionNodeValue_;
                    CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                    if (conditionProfile__ != null) {
                        return this.doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                    }
                }
                if ((state_0 & 4) != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMI8Vector) {
                        LLVMI8Vector trueNodeValue__ = (LLVMI8Vector)trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMI8Vector) {
                            LLVMI8Vector elseNodeValue__ = (LLVMI8Vector)elseNodeValue_;
                            CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                            if (conditionProfile__1 != null) {
                                return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (Boolean)conditionNodeValue;
                CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.state_0_ = state_0 |= 2;
                return this.doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMI8Vector) {
                    LLVMI8Vector trueNodeValue_ = (LLVMI8Vector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI8Vector) {
                        LLVMI8Vector elseNodeValue_ = (LLVMI8Vector)elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        this.state_0_ = state_0 |= 4;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op0_conditionProfile_ = conditionProfile__;
            this.op0_conditionProfile_.disable();
            this.state_0_ |= 2;
            CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op1_conditionProfile_ = conditionProfile__1;
            this.op1_conditionProfile_.disable();
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMVectorSelectNode.LLVMI8VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI8VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMVectorSelectNode.LLVMI1VectorSelectNode.class)
    public static final class LLVMI1VectorSelectNodeGen
    extends LLVMVectorSelectNode.LLVMI1VectorSelectNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode conditionNode_;
        @Node.Child
        private LLVMExpressionNode trueNode_;
        @Node.Child
        private LLVMExpressionNode elseNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op0_conditionProfile_;
        @CompilerDirectives.CompilationFinal
        private CountingConditionProfile op1_conditionProfile_;

        private LLVMI1VectorSelectNodeGen(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.conditionNode_ = conditionNode;
            this.trueNode_ = trueNode;
            this.elseNode_ = elseNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            return this.executeGeneric_generic1(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean conditionNodeValue_;
            int state_0 = state_0__;
            try {
                conditionNodeValue_ = this.conditionNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object trueNodeValue = this.trueNode_.executeGeneric(frameValue);
                Object elseNodeValue = this.elseNode_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), trueNodeValue, elseNodeValue);
            }
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
            if (conditionProfile__ != null) {
                return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object conditionNodeValue_ = this.conditionNode_.executeGeneric(frameValue);
            Object trueNodeValue_ = this.trueNode_.executeGeneric(frameValue);
            Object elseNodeValue_ = this.elseNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && conditionNodeValue_ instanceof Boolean) {
                    boolean conditionNodeValue__ = (Boolean)conditionNodeValue_;
                    CountingConditionProfile conditionProfile__ = this.op0_conditionProfile_;
                    if (conditionProfile__ != null) {
                        return this.doOp(conditionNodeValue__, trueNodeValue_, elseNodeValue_, conditionProfile__);
                    }
                }
                if ((state_0 & 4) != 0 && conditionNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector conditionNodeValue__ = (LLVMI1Vector)conditionNodeValue_;
                    if (trueNodeValue_ instanceof LLVMI1Vector) {
                        LLVMI1Vector trueNodeValue__ = (LLVMI1Vector)trueNodeValue_;
                        if (elseNodeValue_ instanceof LLVMI1Vector) {
                            LLVMI1Vector elseNodeValue__ = (LLVMI1Vector)elseNodeValue_;
                            CountingConditionProfile conditionProfile__1 = this.op1_conditionProfile_;
                            if (conditionProfile__1 != null) {
                                return this.doOp(conditionNodeValue__, trueNodeValue__, elseNodeValue__, conditionProfile__1);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(conditionNodeValue_, trueNodeValue_, elseNodeValue_);
        }

        private Object executeAndSpecialize(Object conditionNodeValue, Object trueNodeValue, Object elseNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionNodeValue instanceof Boolean) {
                boolean conditionNodeValue_ = (Boolean)conditionNodeValue;
                CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
                Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.op0_conditionProfile_ = conditionProfile__;
                this.state_0_ = state_0 |= 2;
                return this.doOp(conditionNodeValue_, trueNodeValue, elseNodeValue, conditionProfile__);
            }
            if (conditionNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector conditionNodeValue_ = (LLVMI1Vector)conditionNodeValue;
                if (trueNodeValue instanceof LLVMI1Vector) {
                    LLVMI1Vector trueNodeValue_ = (LLVMI1Vector)trueNodeValue;
                    if (elseNodeValue instanceof LLVMI1Vector) {
                        LLVMI1Vector elseNodeValue_ = (LLVMI1Vector)elseNodeValue;
                        CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
                        Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.op1_conditionProfile_ = conditionProfile__1;
                        this.state_0_ = state_0 |= 4;
                        return this.doOp(conditionNodeValue_, trueNodeValue_, elseNodeValue_, conditionProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.conditionNode_, this.trueNode_, this.elseNode_}, new Object[]{conditionNodeValue, trueNodeValue, elseNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            CountingConditionProfile conditionProfile__ = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op0_conditionProfile_ = conditionProfile__;
            this.op0_conditionProfile_.disable();
            this.state_0_ |= 2;
            CountingConditionProfile conditionProfile__1 = CountingConditionProfile.create();
            Objects.requireNonNull(conditionProfile__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.op1_conditionProfile_ = conditionProfile__1;
            this.op1_conditionProfile_.disable();
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.op0_conditionProfile_.reset();
            this.op1_conditionProfile_.reset();
        }

        @NeverDefault
        public static LLVMVectorSelectNode.LLVMI1VectorSelectNode create(LLVMExpressionNode conditionNode, LLVMExpressionNode trueNode, LLVMExpressionNode elseNode, int vectorLength) {
            return new LLVMI1VectorSelectNodeGen(conditionNode, trueNode, elseNode, vectorLength);
        }
    }
}

