/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMUnsupportedInstructionNodeGen;

public abstract class LLVMUnsupportedInstructionNode
extends LLVMStatementNode {
    private final String message;
    private final LLVMUnsupportedException.UnsupportedReason reason;

    public static LLVMUnsupportedInstructionNode create(LLVMUnsupportedException.UnsupportedReason reason) {
        return LLVMUnsupportedInstructionNodeGen.create(reason, null);
    }

    public static LLVMUnsupportedInstructionNode create(LLVMUnsupportedException.UnsupportedReason reason, String message) {
        return LLVMUnsupportedInstructionNodeGen.create(reason, message);
    }

    public static LLVMUnsupportedExpressionNode createExpression(LLVMUnsupportedException.UnsupportedReason reason) {
        return LLVMUnsupportedInstructionNodeGen.LLVMUnsupportedExpressionNodeGen.create(LLVMUnsupportedInstructionNode.create(reason));
    }

    public static LLVMUnsupportedExpressionNode createExpression(LLVMUnsupportedException.UnsupportedReason reason, String message) {
        return LLVMUnsupportedInstructionNodeGen.LLVMUnsupportedExpressionNodeGen.create(LLVMUnsupportedInstructionNode.create(reason, message));
    }

    LLVMUnsupportedInstructionNode(LLVMUnsupportedException.UnsupportedReason reason, String message) {
        this.message = message;
        this.reason = reason;
    }

    @Specialization
    void doUnsupported() {
        if (this.message == null) {
            throw new LLVMUnsupportedException((Node)this, this.reason);
        }
        throw new LLVMUnsupportedException(this, this.reason, "Unsupported operation: %s", this.message);
    }

    public static abstract class LLVMUnsupportedExpressionNode
    extends LLVMExpressionNode {
        @Node.Child
        private LLVMUnsupportedInstructionNode instruction;

        LLVMUnsupportedExpressionNode(LLVMUnsupportedInstructionNode instruction) {
            this.instruction = instruction;
        }

        @Specialization
        public Object doUnsupported(VirtualFrame frame) {
            this.instruction.execute(frame);
            return null;
        }
    }
}

