/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMDoubleLoadNode
extends LLVMLoadNode {
    public static LLVMDoubleLoadNode create() {
        return LLVMDoubleLoadNodeGen.create(null);
    }

    public abstract double executeWithTarget(Object var1);

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected double doDoubleNative(LLVMNativePointer addr) {
        return this.getLanguage().getLLVMMemory().getDouble((Node)this, addr);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected static double doDoubleDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return LLVMDoubleLoadNode.doDoubleManaged(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    @GenerateAOT.Exclude
    protected static double doDoubleManaged(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readDouble(addr.getObject(), addr.getOffset());
    }

    @GenerateUncached
    public static abstract class LLVMDoubleOffsetLoadNode
    extends LLVMOffsetLoadNode {
        public static LLVMDoubleOffsetLoadNode create() {
            return LLVMDoubleLoadNodeGen.LLVMDoubleOffsetLoadNodeGen.create();
        }

        public abstract double executeWithTarget(LLVMPointer var1, long var2);

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected double doDoubleNative(LLVMNativePointer addr, long offset) {
            return this.getLanguage().getLLVMMemory().getDouble((Node)this, addr.asNative() + offset);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        protected static double doDoubleDerefHandle(LLVMNativePointer addr, long offset, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
            return LLVMDoubleOffsetLoadNode.doDoubleManaged(getReceiver.execute(addr), offset, nativeRead);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        protected static double doDoubleManaged(LLVMManagedPointer addr, long offset, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            return nativeRead.readDouble(addr.getObject(), addr.getOffset() + offset);
        }
    }
}

