/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadStart;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pthread.LLVMPThreadContext;
import com.oracle.truffle.llvm.runtime.pthread.LLVMThreadException;
import com.oracle.truffle.llvm.runtime.pthread.PThreadExitException;

public final class LLVMThreadIntrinsics {

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="threadID"), @NodeChild(type=LLVMExpressionNode.class, value="buffer"), @NodeChild(type=LLVMExpressionNode.class, value="targetLen")})
    public static abstract class LLVMThreadGetName
    extends LLVMBuiltin {
        @Node.Child
        private LLVMI8StoreNode.LLVMI8OffsetStoreNode write = LLVMI8StoreNode.LLVMI8OffsetStoreNode.create();

        @Specialization
        protected int doIntrinsic(long threadID, LLVMPointer buffer, long targetLen) {
            Thread thread = this.getContext().getpThreadContext().getThread(threadID);
            if (thread == null) {
                return 34;
            }
            byte[] byteString = this.getThreadNameAsBytes(thread);
            long bytesWritten = 0L;
            for (int i = 0; i < byteString.length && (long)i < targetLen - 1L; ++i) {
                this.write.executeWithTarget(buffer, bytesWritten, byteString[i]);
                ++bytesWritten;
            }
            this.write.executeWithTarget(buffer, bytesWritten, (byte)0);
            if (targetLen <= (long)byteString.length) {
                return 34;
            }
            return 0;
        }

        @CompilerDirectives.TruffleBoundary
        protected byte[] getThreadNameAsBytes(Thread thread) {
            if (thread == null) {
                throw new IllegalStateException("The thread is null");
            }
            if (thread.getName() == null) {
                throw new IllegalStateException("The thread's name is null");
            }
            return thread.getName().getBytes();
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="id"), @NodeChild(type=LLVMExpressionNode.class, value="namePointer")})
    public static abstract class LLVMThreadSetName
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(long id, LLVMPointer namePointer, @Cached LLVMReadStringNode readString) {
            String name = readString.executeWithTarget(namePointer);
            LLVMPThreadContext threadContext = this.getContext().getpThreadContext();
            Thread thread = threadContext.getThread(id);
            if (thread == null) {
                return 34;
            }
            this.setName(thread, name);
            return 0;
        }

        @CompilerDirectives.TruffleBoundary
        protected void setName(Thread thread, String name) {
            thread.setName(name);
        }
    }

    public static abstract class LLVMThreadSelf
    extends LLVMBuiltin {
        @Specialization
        protected long doIntrinsic() {
            return LLVMThreadSelf.getThreadId();
        }

        @CompilerDirectives.TruffleBoundary
        private static long getThreadId() {
            return Thread.currentThread().getId();
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="threadId")
    public static abstract class LLVMThreadJoin
    extends LLVMBuiltin {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object doIntrinsic(long threadID) {
            LLVMContext context = this.getContext();
            Thread thread = context.getpThreadContext().getThread(threadID);
            if (thread != null) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    throw new LLVMThreadException(this, "Failed to join thread", e);
                }
            }
            LLVMPThreadContext pthreadContext = context.getpThreadContext();
            Object threadReturnValue = pthreadContext.getThreadReturnValue(threadID);
            pthreadContext.clearThreadReturnValue(threadID);
            pthreadContext.clearThreadID(threadID);
            return threadReturnValue;
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="millis"), @NodeChild(type=LLVMExpressionNode.class, value="nanos")})
    public static abstract class LLVMThreadSleep
    extends LLVMBuiltin {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected int doSleep(long millis, int nanos) {
            try {
                Thread.sleep(millis, nanos);
            }
            catch (InterruptedException ex) {
                return -1;
            }
            catch (IllegalArgumentException ex) {
                return 1;
            }
            return 0;
        }
    }

    public static abstract class LLVMThreadYield
    extends LLVMBuiltin {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object doYield() {
            Thread.yield();
            return null;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="retval")
    public static abstract class LLVMThreadExit
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(Object returnValue) {
            LLVMThreadExit.setThreadReturnValue(returnValue, this.getContext());
            throw new PThreadExitException();
        }

        @CompilerDirectives.TruffleBoundary
        private static void setThreadReturnValue(Object returnValue, LLVMContext context) {
            context.getpThreadContext().setThreadReturnValue(Thread.currentThread().getId(), returnValue);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="thread"), @NodeChild(type=LLVMExpressionNode.class, value="startRoutine"), @NodeChild(type=LLVMExpressionNode.class, value="arg")})
    public static abstract class LLVMThreadCreate
    extends LLVMBuiltin {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected int doIntrinsic(LLVMPointer thread, LLVMPointer startRoutine, LLVMPointer arg, @Cached LLVMI64StoreNode store) {
            LLVMContext context = this.getContext();
            LLVMThreadStart.LLVMThreadRunnable init = new LLVMThreadStart.LLVMThreadRunnable(startRoutine, arg, context);
            Thread t = context.getpThreadContext().createThread(init);
            if (t == null) {
                return 11;
            }
            store.executeWithTarget(thread, t.getId());
            t.start();
            return 0;
        }
    }
}

