/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsStringNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteBuffer;

@NodeChildren(value={@NodeChild(value="object", type=LLVMExpressionNode.class), @NodeChild(value="buffer", type=LLVMExpressionNode.class), @NodeChild(value="buflen", type=LLVMExpressionNode.class), @NodeChild(value="charset", type=LLVMReadCharsetNode.class)})
public abstract class LLVMPolyglotAsString
extends LLVMIntrinsic {
    @Node.Child
    EncodeStringNode encodeString = LLVMPolyglotAsStringNodeGen.EncodeStringNodeGen.create();
    @Node.Child
    WriteStringNode writeString = LLVMPolyglotAsStringNodeGen.WriteStringNodeGen.create();

    public static LLVMPolyglotAsString create(LLVMExpressionNode object, LLVMExpressionNode buffer, LLVMExpressionNode buflen, LLVMExpressionNode charset) {
        return LLVMPolyglotAsStringNodeGen.create(object, buffer, buflen, LLVMReadCharsetNodeGen.create(charset));
    }

    @Specialization
    long doAsString(Object object, Object buffer, long buflen, LLVMReadCharsetNode.LLVMCharset charset) {
        ByteBuffer result = this.encodeString.execute(object, charset);
        return this.writeString.execute(result, buffer, buflen, charset.zeroTerminatorLen);
    }

    static abstract class EncodeStringNode
    extends LLVMNode {
        EncodeStringNode() {
        }

        protected abstract ByteBuffer execute(Object var1, LLVMReadCharsetNode.LLVMCharset var2);

        @Specialization
        ByteBuffer doString(String str, LLVMReadCharsetNode.LLVMCharset charset) {
            return charset.encode(str);
        }

        @Specialization
        ByteBuffer doForeign(LLVMManagedPointer obj, LLVMReadCharsetNode.LLVMCharset charset, @Cached LLVMAsForeignNode asForeign, @Cached BoxedEncodeStringNode encode) {
            return encode.execute(asForeign.execute(obj), charset);
        }
    }

    @ImportStatic(value={CompilerDirectives.class})
    static abstract class WriteStringNode
    extends LLVMNode {
        WriteStringNode() {
        }

        protected abstract long execute(ByteBuffer var1, Object var2, long var3, int var5);

        @Specialization(guards={"isExact(srcBuffer, srcBufferClass)"})
        @GenerateAOT.Exclude
        long doWrite(ByteBuffer srcBuffer, LLVMPointer target, long targetLen, int zeroTerminatorLen, @Cached(value="srcBuffer.getClass()") Class<? extends ByteBuffer> srcBufferClass, @Cached LLVMI8StoreNode.LLVMI8OffsetStoreNode write) {
            long bytesWritten;
            ByteBuffer source = (ByteBuffer)CompilerDirectives.castExact((Object)srcBuffer, srcBufferClass);
            for (bytesWritten = 0L; source.hasRemaining() && bytesWritten < targetLen; ++bytesWritten) {
                write.executeWithTarget(target, bytesWritten, source.get());
            }
            long ret = bytesWritten;
            for (int i = 0; i < zeroTerminatorLen && bytesWritten < targetLen; ++bytesWritten, ++i) {
                write.executeWithTarget(target, bytesWritten, (byte)0);
            }
            return ret;
        }
    }

    static abstract class BoxedEncodeStringNode
    extends LLVMNode {
        BoxedEncodeStringNode() {
        }

        abstract ByteBuffer execute(Object var1, LLVMReadCharsetNode.LLVMCharset var2);

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        ByteBuffer doBoxed(Object object, LLVMReadCharsetNode.LLVMCharset charset, @CachedLibrary(value="object") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                String unboxed = interop.asString(object);
                return charset.encode(unboxed);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Polyglot value is not a string.");
            }
        }
    }
}

