/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToDoubleNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMToDoubleNode.class)
public final class LLVMToDoubleNodeGen
extends LLVMToDoubleNode
implements GenerateAOT.Provider {
    private static final LibraryFactory<LLVMAsForeignLibrary> LL_VM_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @Node.Child
    private LLVMExpressionNode fromNode_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private ManagedPointerData managedPointer_cache;
    @Node.Child
    private PointerData pointer_cache;

    private LLVMToDoubleNodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    private LLVMToDoubleNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
        super(isRecursive);
        this.fromNode_ = fromNode;
    }

    @Override
    protected double executeWith(long fromNodeValue) {
        throw CompilerDirectives.shouldNotReachHere((String)"Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 6) != 0) {
            LLVMPointer fromNodeValue__;
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s0_ = this.managedPointer_cache;
                if (s0_ != null && LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                }
            }
            if ((state_0 & 4) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                PointerData s1_ = this.pointer_cache;
                if (s1_ != null) {
                    assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                    return this.doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 6) != 0) {
            LLVMPointer fromNodeValue__;
            if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s0_ = this.managedPointer_cache;
                if (s0_ != null && LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                }
            }
            if ((state_0 & 4) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                PointerData s1_ = this.pointer_cache;
                if (s1_ != null) {
                    assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                    return this.doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    private double executeAndSpecialize(Object fromNodeValue) {
        InteropLibrary interop__;
        LLVMAsForeignLibrary foreigns__;
        LLVMPointer fromNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToDoubleNode.isForeignNumber(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue), foreigns__ = (LLVMAsForeignLibrary)this.insert((Node)((LLVMAsForeignLibrary)LL_VM_AS_FOREIGN_LIBRARY_.createDispatched(1))), interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3))))) {
            ManagedPointerData s0_ = (ManagedPointerData)this.insert(new ManagedPointerData());
            s0_.toLLVM_ = (ForeignToLLVM)s0_.insert(this.createForeignToLLVM());
            s0_.recursive_ = (LLVMToDoubleNode)s0_.insert(this.createRecursive());
            Objects.requireNonNull((LLVMAsForeignLibrary)s0_.insert((Node)foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s0_.foreigns_ = foreigns__;
            Objects.requireNonNull((InteropLibrary)s0_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s0_.interop_ = interop__;
            VarHandle.storeStoreFence();
            this.managedPointer_cache = s0_;
            this.state_0_ = state_0 |= 2;
            return this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
        }
        if (LLVMTypes.isPointer(fromNodeValue)) {
            fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            if (!this.isRecursive) {
                PointerData s1_ = (PointerData)this.insert(new PointerData());
                s1_.toNative_ = (LLVMToNativeNode)s1_.insert(LLVMToNativeNode.createToNativeWithTarget());
                s1_.recursive_ = (LLVMToDoubleNode)s1_.insert(this.createRecursive());
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                this.state_0_ = state_0 |= 4;
                return this.doPointer(fromNodeValue_, s1_.toNative_, s1_.recursive_);
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        if (!this.isRecursive) {
            PointerData s1_ = (PointerData)this.insert(new PointerData());
            s1_.toNative_ = (LLVMToNativeNode)s1_.insert(LLVMToNativeNode.createToNativeWithTarget());
            s1_.recursive_ = (LLVMToDoubleNode)s1_.insert(this.createRecursive());
            VarHandle.storeStoreFence();
            this.pointer_cache = s1_;
            assert (NodeUtil.assertRecursion((Node)s1_.toNative_, (int)1));
            ((GenerateAOT.Provider)s1_.toNative_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s1_.recursive_, (int)1));
            ((GenerateAOT.Provider)s1_.recursive_).prepareForAOT(language, root);
            this.state_0_ |= 4;
        }
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
        this.pointer_cache = null;
    }

    @NeverDefault
    public static LLVMToDoubleNode create(LLVMExpressionNode fromNode) {
        return new LLVMToDoubleNodeGen(fromNode);
    }

    @NeverDefault
    public static LLVMToDoubleNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
        return new LLVMToDoubleNodeGen(isRecursive, fromNode);
    }

    @GeneratedBy(value=LLVMToDoubleNode.class)
    @DenyReplace
    private static final class ManagedPointerData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        ForeignToLLVM toLLVM_;
        @Node.Child
        LLVMToDoubleNode recursive_;
        @Node.Child
        LLVMAsForeignLibrary foreigns_;
        @Node.Child
        InteropLibrary interop_;

        ManagedPointerData() {
        }
    }

    @GeneratedBy(value=LLVMToDoubleNode.class)
    @DenyReplace
    private static final class PointerData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        LLVMToNativeNode toNative_;
        @Node.Child
        LLVMToDoubleNode recursive_;

        PointerData() {
        }
    }

    @GeneratedBy(value=LLVMToDoubleNode.LLVMBitcastToDoubleNode.class)
    public static final class LLVMBitcastToDoubleNodeGen
    extends LLVMToDoubleNode.LLVMBitcastToDoubleNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private PointerData pointer_cache;

        private LLVMBitcastToDoubleNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMBitcastToDoubleNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected double executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 8) != 0) {
                return this.doDouble(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FF6) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_long0(state_0, frameValue);
            }
            if ((state_0 & 0x1FEE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_double1(state_0, frameValue);
            }
            if ((state_0 & 0x1FDE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_float2(state_0, frameValue);
            }
            return this.executeGeneric_generic3(state_0, frameValue);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_double1(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_float2(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 0x20) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_generic3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x1FFE) != 0) {
                Object fromNodeValue__;
                if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null && LLVMToDoubleNode.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s0_.foreigns_, s0_.interop_)) {
                        return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                    }
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                        return this.doPointer((LLVMPointer)fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__2 = (Long)fromNodeValue_;
                    return this.doDouble(fromNodeValue__2);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__3 = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__3);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__4 = ((Float)fromNodeValue_).floatValue();
                    return this.doFloat(fromNodeValue__4);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector((LLVMI1Vector)fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8Vector((LLVMI8Vector)fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16Vector((LLVMI16Vector)fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32Vector((LLVMI32Vector)fromNodeValue__);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloatVector((LLVMFloatVector)fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64Vector((LLVMI64Vector)fromNodeValue__);
                }
                if ((state_0 & 0x1000) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDoubleVector((LLVMDoubleVector)fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FF6) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeDouble_long4(state_0, frameValue);
            }
            if ((state_0 & 0x1FEE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeDouble_double5(state_0, frameValue);
            }
            if ((state_0 & 0x1FDE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeDouble_float6(state_0, frameValue);
            }
            return this.executeDouble_generic7(state_0, frameValue);
        }

        private double executeDouble_long4(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_double5(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_float6(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 0x20) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private double executeDouble_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x1FFE) != 0) {
                Object fromNodeValue__;
                if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null && LLVMToDoubleNode.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s0_.foreigns_, s0_.interop_)) {
                        return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                    }
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                        return this.doPointer((LLVMPointer)fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__2 = (Long)fromNodeValue_;
                    return this.doDouble(fromNodeValue__2);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__3 = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__3);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__4 = ((Float)fromNodeValue_).floatValue();
                    return this.doFloat(fromNodeValue__4);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector((LLVMI1Vector)fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8Vector((LLVMI8Vector)fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16Vector((LLVMI16Vector)fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32Vector((LLVMI32Vector)fromNodeValue__);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloatVector((LLVMFloatVector)fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64Vector((LLVMI64Vector)fromNodeValue__);
                }
                if ((state_0 & 0x1000) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDoubleVector((LLVMDoubleVector)fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private double executeAndSpecialize(Object fromNodeValue) {
            InteropLibrary interop__;
            LLVMAsForeignLibrary foreigns__;
            Object fromNodeValue_;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToDoubleNode.isForeignNumber((LLVMManagedPointer)(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue)), foreigns__ = (LLVMAsForeignLibrary)this.insert((Node)((LLVMAsForeignLibrary)LL_VM_AS_FOREIGN_LIBRARY_.createDispatched(1))), interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3))))) {
                ManagedPointerData s0_ = (ManagedPointerData)this.insert(new ManagedPointerData());
                s0_.toLLVM_ = (ForeignToLLVM)s0_.insert(this.createForeignToLLVM());
                s0_.recursive_ = (LLVMToDoubleNode)s0_.insert(this.createRecursive());
                Objects.requireNonNull((LLVMAsForeignLibrary)s0_.insert((Node)foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.foreigns_ = foreigns__;
                Objects.requireNonNull((InteropLibrary)s0_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.interop_ = interop__;
                VarHandle.storeStoreFence();
                this.managedPointer_cache = s0_;
                this.state_0_ = state_0 |= 2;
                return this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if (!this.isRecursive) {
                    PointerData s1_ = (PointerData)this.insert(new PointerData());
                    s1_.toNative_ = (LLVMToNativeNode)s1_.insert(LLVMToNativeNode.createToNativeWithTarget());
                    s1_.recursive_ = (LLVMToDoubleNode)s1_.insert(this.createRecursive());
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    this.state_0_ = state_0 |= 4;
                    return this.doPointer((LLVMPointer)fromNodeValue_, s1_.toNative_, s1_.recursive_);
                }
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_2 = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doDouble(fromNodeValue_2);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_3 = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doDouble(fromNodeValue_3);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_4 = ((Float)fromNodeValue).floatValue();
                this.state_0_ = state_0 |= 0x20;
                return this.doFloat(fromNodeValue_4);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doI1Vector((LLVMI1Vector)fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doI8Vector((LLVMI8Vector)fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x100;
                return this.doI16Vector((LLVMI16Vector)fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x200;
                return this.doI32Vector((LLVMI32Vector)fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x400;
                return this.doFloatVector((LLVMFloatVector)fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x800;
                return this.doI64Vector((LLVMI64Vector)fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x1000;
                return this.doDoubleVector((LLVMDoubleVector)fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            if (!this.isRecursive) {
                PointerData s1_ = (PointerData)this.insert(new PointerData());
                s1_.toNative_ = (LLVMToNativeNode)s1_.insert(LLVMToNativeNode.createToNativeWithTarget());
                s1_.recursive_ = (LLVMToDoubleNode)s1_.insert(this.createRecursive());
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                assert (NodeUtil.assertRecursion((Node)s1_.toNative_, (int)1));
                ((GenerateAOT.Provider)s1_.toNative_).prepareForAOT(language, root);
                assert (NodeUtil.assertRecursion((Node)s1_.recursive_, (int)1));
                ((GenerateAOT.Provider)s1_.recursive_).prepareForAOT(language, root);
                this.state_0_ |= 4;
            }
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            this.state_0_ |= 0x400;
            this.state_0_ |= 0x800;
            this.state_0_ |= 0x1000;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMToDoubleNode.LLVMBitcastToDoubleNode create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToDoubleNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMToDoubleNode.LLVMBitcastToDoubleNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMBitcastToDoubleNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(value=LLVMToDoubleNode.LLVMBitcastToDoubleNode.class)
        @DenyReplace
        private static final class ManagedPointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMToDoubleNode recursive_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }
        }

        @GeneratedBy(value=LLVMToDoubleNode.LLVMBitcastToDoubleNode.class)
        @DenyReplace
        private static final class PointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMToNativeNode toNative_;
            @Node.Child
            LLVMToDoubleNode recursive_;

            PointerData() {
            }
        }
    }

    @GeneratedBy(value=LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.class)
    public static final class LLVMUnsignedCastToDoubleNodeGen
    extends LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private PointerData pointer_cache;

        private LLVMUnsignedCastToDoubleNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMUnsignedCastToDoubleNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected double executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0x80) != 0) {
                return this.doDouble(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1F6) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0x1EE) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0x1DE) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0x1BE) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0x17E) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            if ((state_0 & 0xFE) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_double5(state_0, frameValue);
            }
            return this.executeGeneric_generic6(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x20) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x40) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x80) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_double5(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x100) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x1FE) != 0) {
                LLVMPointer fromNodeValue__;
                if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null && LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_)) {
                        return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                    }
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                        return this.doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                    return this.doDouble(fromNodeValue__2);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__3 = (Byte)fromNodeValue_;
                    return this.doDouble(fromNodeValue__3);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__4 = (Short)fromNodeValue_;
                    return this.doDouble(fromNodeValue__4);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__5 = (Integer)fromNodeValue_;
                    return this.doDouble(fromNodeValue__5);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__6 = (Long)fromNodeValue_;
                    return this.doDouble(fromNodeValue__6);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__7 = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__7);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1F6) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeDouble_boolean7(state_0, frameValue);
            }
            if ((state_0 & 0x1EE) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeDouble_byte8(state_0, frameValue);
            }
            if ((state_0 & 0x1DE) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeDouble_short9(state_0, frameValue);
            }
            if ((state_0 & 0x1BE) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeDouble_int10(state_0, frameValue);
            }
            if ((state_0 & 0x17E) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeDouble_long11(state_0, frameValue);
            }
            if ((state_0 & 0xFE) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeDouble_double12(state_0, frameValue);
            }
            return this.executeDouble_generic13(state_0, frameValue);
        }

        private double executeDouble_boolean7(int state_0__, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_byte8(int state_0__, VirtualFrame frameValue) {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_short9(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x20) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_int10(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x40) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_long11(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x80) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_double12(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x100) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_generic13(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x1FE) != 0) {
                LLVMPointer fromNodeValue__;
                if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null && LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_)) {
                        return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                    }
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                        return this.doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                    return this.doDouble(fromNodeValue__2);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__3 = (Byte)fromNodeValue_;
                    return this.doDouble(fromNodeValue__3);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__4 = (Short)fromNodeValue_;
                    return this.doDouble(fromNodeValue__4);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__5 = (Integer)fromNodeValue_;
                    return this.doDouble(fromNodeValue__5);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__6 = (Long)fromNodeValue_;
                    return this.doDouble(fromNodeValue__6);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__7 = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__7);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private double executeAndSpecialize(Object fromNodeValue) {
            InteropLibrary interop__;
            LLVMAsForeignLibrary foreigns__;
            LLVMPointer fromNodeValue_;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToDoubleNode.isForeignNumber(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue), foreigns__ = (LLVMAsForeignLibrary)this.insert((Node)((LLVMAsForeignLibrary)LL_VM_AS_FOREIGN_LIBRARY_.createDispatched(1))), interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3))))) {
                ManagedPointerData s0_ = (ManagedPointerData)this.insert(new ManagedPointerData());
                s0_.toLLVM_ = (ForeignToLLVM)s0_.insert(this.createForeignToLLVM());
                s0_.recursive_ = (LLVMToDoubleNode)s0_.insert(this.createRecursive());
                Objects.requireNonNull((LLVMAsForeignLibrary)s0_.insert((Node)foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.foreigns_ = foreigns__;
                Objects.requireNonNull((InteropLibrary)s0_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.interop_ = interop__;
                VarHandle.storeStoreFence();
                this.managedPointer_cache = s0_;
                this.state_0_ = state_0 |= 2;
                return this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if (!this.isRecursive) {
                    PointerData s1_ = (PointerData)this.insert(new PointerData());
                    s1_.toNative_ = (LLVMToNativeNode)s1_.insert(LLVMToNativeNode.createToNativeWithTarget());
                    s1_.recursive_ = (LLVMToDoubleNode)s1_.insert(this.createRecursive());
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    this.state_0_ = state_0 |= 4;
                    return this.doPointer(fromNodeValue_, s1_.toNative_, s1_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_2 = (Boolean)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doDouble(fromNodeValue_2);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_3 = (Byte)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doDouble(fromNodeValue_3);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_4 = (Short)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doDouble(fromNodeValue_4);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_5 = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doDouble(fromNodeValue_5);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_6 = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doDouble(fromNodeValue_6);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_7 = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 0x100;
                return this.doDouble(fromNodeValue_7);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            if (!this.isRecursive) {
                PointerData s1_ = (PointerData)this.insert(new PointerData());
                s1_.toNative_ = (LLVMToNativeNode)s1_.insert(LLVMToNativeNode.createToNativeWithTarget());
                s1_.recursive_ = (LLVMToDoubleNode)s1_.insert(this.createRecursive());
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                assert (NodeUtil.assertRecursion((Node)s1_.toNative_, (int)1));
                ((GenerateAOT.Provider)s1_.toNative_).prepareForAOT(language, root);
                assert (NodeUtil.assertRecursion((Node)s1_.recursive_, (int)1));
                ((GenerateAOT.Provider)s1_.recursive_).prepareForAOT(language, root);
                this.state_0_ |= 4;
            }
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToDoubleNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToDoubleNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(value=LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.class)
        @DenyReplace
        private static final class ManagedPointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMToDoubleNode recursive_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }
        }

        @GeneratedBy(value=LLVMToDoubleNode.LLVMUnsignedCastToDoubleNode.class)
        @DenyReplace
        private static final class PointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMToNativeNode toNative_;
            @Node.Child
            LLVMToDoubleNode recursive_;

            PointerData() {
            }
        }
    }

    @GeneratedBy(value=LLVMToDoubleNode.LLVMSignedCastToDoubleNode.class)
    public static final class LLVMSignedCastToDoubleNodeGen
    extends LLVMToDoubleNode.LLVMSignedCastToDoubleNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private PointerData pointer_cache;

        private LLVMSignedCastToDoubleNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMSignedCastToDoubleNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected double executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0x80) != 0) {
                return this.doDouble(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFF6) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0xFEE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0xFDE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0xFBE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0xF7E) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            if ((state_0 & 0xEFE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_float5(state_0, frameValue);
            }
            if ((state_0 & 0xDFE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_double6(state_0, frameValue);
            }
            return this.executeGeneric_generic7(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x20) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x40) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x80) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 0x100) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x200) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0xFFE) != 0) {
                TruffleObject fromNodeValue__;
                if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null && LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_)) {
                        return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                    }
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                        return this.doPointer((LLVMPointer)fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                    return this.doDouble(fromNodeValue__2);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__3 = (Byte)fromNodeValue_;
                    return this.doDouble(fromNodeValue__3);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__4 = (Short)fromNodeValue_;
                    return this.doDouble(fromNodeValue__4);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__5 = (Integer)fromNodeValue_;
                    return this.doDouble(fromNodeValue__5);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__6 = (Long)fromNodeValue_;
                    return this.doDouble(fromNodeValue__6);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__7 = ((Float)fromNodeValue_).floatValue();
                    return this.doDouble(fromNodeValue__7);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__8 = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__8);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                    fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                    return this.doDouble((LLVM80BitFloat)fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVM128BitFloat) {
                    fromNodeValue__ = (LLVM128BitFloat)fromNodeValue_;
                    return this.doDouble((LLVM128BitFloat)fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFF6) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeDouble_boolean8(state_0, frameValue);
            }
            if ((state_0 & 0xFEE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeDouble_byte9(state_0, frameValue);
            }
            if ((state_0 & 0xFDE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeDouble_short10(state_0, frameValue);
            }
            if ((state_0 & 0xFBE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeDouble_int11(state_0, frameValue);
            }
            if ((state_0 & 0xF7E) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeDouble_long12(state_0, frameValue);
            }
            if ((state_0 & 0xEFE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeDouble_float13(state_0, frameValue);
            }
            if ((state_0 & 0xDFE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeDouble_double14(state_0, frameValue);
            }
            return this.executeDouble_generic15(state_0, frameValue);
        }

        private double executeDouble_boolean8(int state_0__, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_byte9(int state_0__, VirtualFrame frameValue) {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_short10(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x20) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_int11(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x40) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_long12(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x80) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_float13(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 0x100) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_double14(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x200) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private double executeDouble_generic15(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0xFFE) != 0) {
                TruffleObject fromNodeValue__;
                if ((state_0 & 2) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null && LLVMToDoubleNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_)) {
                        return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                    }
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                    fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                        return this.doPointer((LLVMPointer)fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                    return this.doDouble(fromNodeValue__2);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__3 = (Byte)fromNodeValue_;
                    return this.doDouble(fromNodeValue__3);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__4 = (Short)fromNodeValue_;
                    return this.doDouble(fromNodeValue__4);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__5 = (Integer)fromNodeValue_;
                    return this.doDouble(fromNodeValue__5);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__6 = (Long)fromNodeValue_;
                    return this.doDouble(fromNodeValue__6);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__7 = ((Float)fromNodeValue_).floatValue();
                    return this.doDouble(fromNodeValue__7);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__8 = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__8);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                    fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                    return this.doDouble((LLVM80BitFloat)fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVM128BitFloat) {
                    fromNodeValue__ = (LLVM128BitFloat)fromNodeValue_;
                    return this.doDouble((LLVM128BitFloat)fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private double executeAndSpecialize(Object fromNodeValue) {
            InteropLibrary interop__;
            LLVMAsForeignLibrary foreigns__;
            TruffleObject fromNodeValue_;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToDoubleNode.isForeignNumber(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue), foreigns__ = (LLVMAsForeignLibrary)this.insert((Node)((LLVMAsForeignLibrary)LL_VM_AS_FOREIGN_LIBRARY_.createDispatched(1))), interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3))))) {
                ManagedPointerData s0_ = (ManagedPointerData)this.insert(new ManagedPointerData());
                s0_.toLLVM_ = (ForeignToLLVM)s0_.insert(this.createForeignToLLVM());
                s0_.recursive_ = (LLVMToDoubleNode)s0_.insert(this.createRecursive());
                Objects.requireNonNull((LLVMAsForeignLibrary)s0_.insert((Node)foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.foreigns_ = foreigns__;
                Objects.requireNonNull((InteropLibrary)s0_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.interop_ = interop__;
                VarHandle.storeStoreFence();
                this.managedPointer_cache = s0_;
                this.state_0_ = state_0 |= 2;
                return this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if (!this.isRecursive) {
                    PointerData s1_ = (PointerData)this.insert(new PointerData());
                    s1_.toNative_ = (LLVMToNativeNode)s1_.insert(LLVMToNativeNode.createToNativeWithTarget());
                    s1_.recursive_ = (LLVMToDoubleNode)s1_.insert(this.createRecursive());
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    this.state_0_ = state_0 |= 4;
                    return this.doPointer((LLVMPointer)fromNodeValue_, s1_.toNative_, s1_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_2 = (Boolean)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doDouble(fromNodeValue_2);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_3 = (Byte)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doDouble(fromNodeValue_3);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_4 = (Short)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doDouble(fromNodeValue_4);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_5 = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doDouble(fromNodeValue_5);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_6 = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doDouble(fromNodeValue_6);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_7 = ((Float)fromNodeValue).floatValue();
                this.state_0_ = state_0 |= 0x100;
                return this.doDouble(fromNodeValue_7);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_8 = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 0x200;
                return this.doDouble(fromNodeValue_8);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x400;
                return this.doDouble((LLVM80BitFloat)fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM128BitFloat) {
                fromNodeValue_ = (LLVM128BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x800;
                return this.doDouble((LLVM128BitFloat)fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            if (!this.isRecursive) {
                PointerData s1_ = (PointerData)this.insert(new PointerData());
                s1_.toNative_ = (LLVMToNativeNode)s1_.insert(LLVMToNativeNode.createToNativeWithTarget());
                s1_.recursive_ = (LLVMToDoubleNode)s1_.insert(this.createRecursive());
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                assert (NodeUtil.assertRecursion((Node)s1_.toNative_, (int)1));
                ((GenerateAOT.Provider)s1_.toNative_).prepareForAOT(language, root);
                assert (NodeUtil.assertRecursion((Node)s1_.recursive_, (int)1));
                ((GenerateAOT.Provider)s1_.recursive_).prepareForAOT(language, root);
                this.state_0_ |= 4;
            }
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            this.state_0_ |= 0x400;
            this.state_0_ |= 0x800;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMToDoubleNode.LLVMSignedCastToDoubleNode create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToDoubleNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMToDoubleNode.LLVMSignedCastToDoubleNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToDoubleNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(value=LLVMToDoubleNode.LLVMSignedCastToDoubleNode.class)
        @DenyReplace
        private static final class ManagedPointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMToDoubleNode recursive_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }
        }

        @GeneratedBy(value=LLVMToDoubleNode.LLVMSignedCastToDoubleNode.class)
        @DenyReplace
        private static final class PointerData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMToNativeNode toNative_;
            @Node.Child
            LLVMToDoubleNode recursive_;

            PointerData() {
            }
        }
    }
}

